/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.gridtable;

import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.cube.gridtable.ComparatorEx;
import org.apache.kylin.gridtable.GTRecord;

public class RecordComparator
extends ComparatorEx<GTRecord> {
    public final ComparatorEx<ByteArray> comparator;

    RecordComparator(ComparatorEx<ByteArray> byteComparator) {
        this.comparator = byteComparator;
    }

    @Override
    public int compare(GTRecord a, GTRecord b) {
        assert (a.getInfo() == b.getInfo());
        ImmutableBitSet allColumns = a.getInfo().getAllColumns();
        for (int i = 0; i < allColumns.trueBitCount(); ++i) {
            int c = allColumns.trueBitAt(i);
            int comp = this.comparator.compare(a.get(c), b.get(c));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

