/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.BitSet;
import java.util.Set;
import org.apache.commons.math3.genetics.Chromosome;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosomeHelper;

public class BitsChromosome
extends Chromosome {
    private final BitsChromosomeHelper helper;
    private final BitSet representation;
    private final ImmutableSet<Long> cuboids;
    private final BenefitPolicy benefitPolicy;
    private final double spaceCost;

    public BitsChromosome(BitSet representation, BenefitPolicy benefitPolicy, BitsChromosomeHelper helper) {
        this.helper = helper;
        this.representation = representation;
        this.cuboids = ImmutableSet.copyOf(helper.toCuboidList(representation));
        this.benefitPolicy = benefitPolicy;
        this.spaceCost = helper.getCuboidSize(Sets.newHashSet(this.cuboids));
    }

    public BitsChromosome newBitsChromosome(BitSet newRepresentation) {
        return new BitsChromosome(newRepresentation, this.benefitPolicy.getInstance(), this.helper);
    }

    public BitSet getRepresentation() {
        return this.representation;
    }

    public int getLength() {
        return this.helper.getLength();
    }

    public ImmutableSet<Long> getCuboids() {
        return this.cuboids;
    }

    public synchronized double fitness() {
        CuboidBenefitModel.BenefitModel benefitModel = this.benefitPolicy.calculateBenefitTotal((Set<Long>)this.cuboids, (Set<Long>)this.helper.getMandatoryCuboids());
        double totalBenefit = benefitModel.benefit;
        if (this.spaceCost > this.helper.spaceLimit) {
            totalBenefit = totalBenefit * this.helper.spaceLimit / this.spaceCost;
        }
        return totalBenefit;
    }

    protected boolean isSame(Chromosome another) {
        return this.equals(another);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BitsChromosome that = (BitsChromosome)((Object)o);
        if (this.helper != null ? !this.helper.equals(that.helper) : that.helper != null) {
            return false;
        }
        return this.representation != null ? this.representation.equals(that.representation) : that.representation == null;
    }

    public int hashCode() {
        int result = this.helper != null ? this.helper.hashCode() : 0;
        result = 31 * result + (this.representation != null ? this.representation.hashCode() : 0);
        return result;
    }
}

