/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2.coprocessor.endpoint;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.RpcCallback;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionServerCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.TestRowProcessorEndpoint;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.CompressionUtils;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.gridtable.CubeCodeSystem;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.TrieDictionaryBuilder;
import org.apache.kylin.dimension.DateDimEnc;
import org.apache.kylin.dimension.DictionaryDimEnc;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.gridtable.GTBuilder;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.GTScanRequestBuilder;
import org.apache.kylin.gridtable.GridTable;
import org.apache.kylin.gridtable.IGTCodeSystem;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStore;
import org.apache.kylin.gridtable.memstore.GTSimpleMemStore;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.expression.BinaryTupleExpression;
import org.apache.kylin.metadata.expression.CaseTupleExpression;
import org.apache.kylin.metadata.expression.ColumnTupleExpression;
import org.apache.kylin.metadata.expression.NumberTupleExpression;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.gtrecord.PartitionResultIterator;
import org.apache.kylin.storage.hbase.cube.v2.CubeHBaseEndpointRPC;
import org.apache.kylin.storage.hbase.cube.v2.RawScan;
import org.apache.kylin.storage.hbase.cube.v2.coprocessor.endpoint.CubeVisitService;
import org.apache.kylin.storage.hbase.cube.v2.coprocessor.endpoint.generated.CubeVisitProtos;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.powermock.api.mockito.PowerMockito;

public class CubeVisitServiceTest
extends LocalFileMetadataTestCase {
    private static final TableName TABLE = TableName.valueOf((String)"KYLIN_testtable");
    private static HBaseTestingUtility util = new HBaseTestingUtility();
    private static volatile HRegion region = null;
    private static volatile GTInfo gtInfo = null;
    private static final long baseCuboid = 3L;
    private static final byte[] FAM = Bytes.toBytes((String)"f1");
    private static final byte[] COL_M = Bytes.toBytes((String)"m");
    private static final List<String> dateList = Lists.newArrayList((Object[])new String[]{"2018-01-14", "2018-01-15", "2018-01-16"});
    private static final List<String> userList = Lists.newArrayList((Object[])new String[]{"Ken", "Lisa", "Gang", "Kalin", "Julian", "John"});
    private static final List<BigDecimal> priceList = Lists.newArrayList((Object[])new BigDecimal[]{new BigDecimal("10.5"), new BigDecimal("15.5")});
    private static final Map<String, Double> expUserStddevRet = Maps.newHashMap();
    private static final Map<String, BigDecimal> expUserRet = Maps.newHashMap();
    private static final BigDecimal userCnt = new BigDecimal(dateList.size());

    public static void prepareTestData() throws Exception {
        try {
            util.getHBaseAdmin().disableTable(TABLE);
            util.getHBaseAdmin().deleteTable(TABLE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HTable table = util.createTable(TABLE, FAM);
        HRegionInfo hRegionInfo = new HRegionInfo(table.getName());
        region = util.createLocalHRegion(hRegionInfo, table.getTableDescriptor());
        gtInfo = CubeVisitServiceTest.newInfo();
        GridTable gridTable = CubeVisitServiceTest.newTable(gtInfo);
        IGTScanner scanner = gridTable.scan(new GTScanRequestBuilder().setInfo(gtInfo).setRanges(null).setDimensions(null).setFilterPushDown(null).createGTScanRequest());
        for (GTRecord record : scanner) {
            byte[] value = record.exportColumns(gtInfo.getPrimaryKey()).toBytes();
            byte[] key = new byte[10 + value.length];
            System.arraycopy(Bytes.toBytes((long)3L), 0, key, 2, 8);
            System.arraycopy(value, 0, key, 10, value.length);
            Put put = new Put(key);
            put.addColumn(FAM, COL_M, record.exportColumns(gtInfo.getColumnBlock(1)).toBytes());
            region.put(put);
        }
    }

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        Configuration conf = util.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{TestRowProcessorEndpoint.RowProcessorEndpoint.class.getName()});
        conf.setInt("hbase.client.retries.number", 2);
        conf.setInt("hbase.master.port", 17000);
        conf.setInt("hbase.master.info.port", 17010);
        conf.setInt("hbase.regionserver.port", 17020);
        conf.setLong("hbase.hregion.row.processor.timeout", 1000L);
        util.startMiniCluster();
        CubeVisitServiceTest.staticCreateTestMetadata((String[])new String[0]);
        CubeVisitServiceTest.prepareTestData();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        util.shutdownMiniCluster();
        CubeVisitServiceTest.staticCleanupTestMetadata();
    }

    @Test(expected=CoprocessorException.class)
    public void testStart() throws IOException {
        CoprocessorEnvironment env = (CoprocessorEnvironment)PowerMockito.mock(RegionServerCoprocessorEnvironment.class);
        CubeVisitService service = new CubeVisitService();
        service.start(env);
    }

    @Test
    public void testVisitCube() throws Exception {
        RawScan rawScan = CubeVisitServiceTest.mockFullScan(gtInfo, CubeVisitServiceTest.getTestConfig());
        CoprocessorEnvironment env = (CoprocessorEnvironment)PowerMockito.mock(RegionCoprocessorEnvironment.class);
        PowerMockito.when((Object)env, (String)"getRegion", (Object[])new Object[0]).thenReturn((Object)region);
        CubeVisitService service = new CubeVisitService();
        service.start(env);
        CubeVisitProtos.CubeVisitRequest request = CubeVisitServiceTest.mockFullScanRequest(gtInfo, Lists.newArrayList((Object[])new RawScan[]{rawScan}));
        RpcCallback<CubeVisitProtos.CubeVisitResponse> done = new RpcCallback<CubeVisitProtos.CubeVisitResponse>(){

            public void run(CubeVisitProtos.CubeVisitResponse result) {
                CubeVisitProtos.CubeVisitResponse.Stats stats = result.getStats();
                Assert.assertEquals((long)0L, (long)stats.getAggregatedRowCount());
                Assert.assertEquals((long)0L, (long)stats.getFilteredRowCount());
                Assert.assertEquals((long)(dateList.size() * userList.size()), (long)stats.getScannedRowCount());
                try {
                    byte[] rawData = CompressionUtils.decompress((byte[])HBaseZeroCopyByteString.zeroCopyGetBytes((ByteString)result.getCompressedRows()));
                    PartitionResultIterator iterator = new PartitionResultIterator(rawData, gtInfo, CubeVisitServiceTest.setOf(0, 1, 2, 3));
                    int nReturn = 0;
                    while (iterator.hasNext()) {
                        iterator.next();
                        ++nReturn;
                    }
                    Assert.assertEquals((long)(dateList.size() * userList.size()), (long)nReturn);
                }
                catch (Exception e) {
                    Assert.fail((String)("Fail due to " + e));
                }
            }
        };
        service.visitCube(null, request, (RpcCallback)done);
    }

    @Test
    public void testVisitCubeWithRuntimeAggregates() throws Exception {
        RawScan rawScan = CubeVisitServiceTest.mockFullScan(gtInfo, CubeVisitServiceTest.getTestConfig());
        CoprocessorEnvironment env = (CoprocessorEnvironment)PowerMockito.mock(RegionCoprocessorEnvironment.class);
        PowerMockito.when((Object)env, (String)"getRegion", (Object[])new Object[0]).thenReturn((Object)region);
        CubeVisitService service = new CubeVisitService();
        service.start(env);
        CubeVisitProtos.CubeVisitRequest request = CubeVisitServiceTest.mockScanRequestWithRuntimeAggregates(gtInfo, Lists.newArrayList((Object[])new RawScan[]{rawScan}));
        RpcCallback<CubeVisitProtos.CubeVisitResponse> done = new RpcCallback<CubeVisitProtos.CubeVisitResponse>(){

            public void run(CubeVisitProtos.CubeVisitResponse result) {
                try {
                    byte[] rawData = CompressionUtils.decompress((byte[])HBaseZeroCopyByteString.zeroCopyGetBytes((ByteString)result.getCompressedRows()));
                    PartitionResultIterator iterator = new PartitionResultIterator(rawData, gtInfo, CubeVisitServiceTest.setOf(1, 3));
                    HashMap actRet = Maps.newHashMap();
                    while (iterator.hasNext()) {
                        GTRecord record = iterator.next();
                        String key = (String)record.decodeValue(1);
                        BigDecimal value = (BigDecimal)record.decodeValue(3);
                        actRet.put(key, value);
                    }
                    HashMap innerExpUserRet = Maps.newHashMap();
                    for (String key : expUserRet.keySet()) {
                        BigDecimal value = new BigDecimal(0);
                        if (key.equals("Ken")) {
                            value = value.add((BigDecimal)expUserRet.get(key));
                            value = value.multiply(new BigDecimal(2));
                            value = value.add(userCnt);
                        } else {
                            value = value.add(userCnt);
                        }
                        innerExpUserRet.put(key, value);
                    }
                    Assert.assertEquals((Object)innerExpUserRet, (Object)actRet);
                }
                catch (Exception e) {
                    Assert.fail((String)("Fail due to " + e));
                }
            }
        };
        service.visitCube(null, request, (RpcCallback)done);
    }

    @Test
    public void testVisitCubeWithRuntimeDimensions() throws Exception {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setColumns(new DataType[]{DataType.getType((String)"date"), DataType.getType((String)"string"), DataType.getType((String)"decimal"), DataType.getType((String)"decimal")});
        builder.enableDynamicDims(CubeVisitServiceTest.setOf(3));
        final GTInfo gtInfo = CubeVisitServiceTest.newInfo(builder);
        RawScan rawScan = CubeVisitServiceTest.mockFullScan(gtInfo, CubeVisitServiceTest.getTestConfig());
        CoprocessorEnvironment env = (CoprocessorEnvironment)PowerMockito.mock(RegionCoprocessorEnvironment.class);
        PowerMockito.when((Object)env, (String)"getRegion", (Object[])new Object[0]).thenReturn((Object)region);
        CubeVisitService service = new CubeVisitService();
        service.start(env);
        CubeVisitProtos.CubeVisitRequest request = CubeVisitServiceTest.mockScanRequestWithRuntimeDimensions(gtInfo, Lists.newArrayList((Object[])new RawScan[]{rawScan}));
        RpcCallback<CubeVisitProtos.CubeVisitResponse> done = new RpcCallback<CubeVisitProtos.CubeVisitResponse>(){

            public void run(CubeVisitProtos.CubeVisitResponse result) {
                try {
                    byte[] rawData = CompressionUtils.decompress((byte[])HBaseZeroCopyByteString.zeroCopyGetBytes((ByteString)result.getCompressedRows()));
                    PartitionResultIterator iterator = new PartitionResultIterator(rawData, gtInfo, CubeVisitServiceTest.setOf(2, 3));
                    HashMap actRet = Maps.newHashMap();
                    while (iterator.hasNext()) {
                        GTRecord record = iterator.next();
                        BigDecimal key = (BigDecimal)record.decodeValue(3);
                        BigDecimal value = (BigDecimal)record.decodeValue(2);
                        actRet.put(key, value);
                    }
                    HashMap innerExpUserRet = Maps.newHashMap();
                    for (String key : expUserRet.keySet()) {
                        BigDecimal keyI = key.equals("Ken") ? new BigDecimal(1) : new BigDecimal(2);
                        BigDecimal value = (BigDecimal)innerExpUserRet.get(keyI);
                        if (value == null) {
                            value = new BigDecimal(0);
                        }
                        value = value.add((BigDecimal)expUserRet.get(key));
                        innerExpUserRet.put(keyI, value);
                    }
                    Assert.assertEquals((Object)innerExpUserRet, (Object)actRet);
                }
                catch (Exception e) {
                    Assert.fail((String)("Fail due to " + e));
                }
            }
        };
        service.visitCube(null, request, (RpcCallback)done);
    }

    public static CubeVisitProtos.CubeVisitRequest mockScanRequestWithRuntimeDimensions(GTInfo gtInfo, List<RawScan> rawScans) throws IOException {
        ImmutableBitSet dimensions = CubeVisitServiceTest.setOf(new int[0]);
        ImmutableBitSet aggrGroupBy = CubeVisitServiceTest.setOf(3);
        ImmutableBitSet aggrMetrics = CubeVisitServiceTest.setOf(2);
        String[] aggrMetricsFuncs = new String[]{"SUM"};
        ImmutableBitSet dynColumns = CubeVisitServiceTest.setOf(3);
        CompareTupleFilter whenFilter = CubeVisitServiceTest.getCompareTupleFilter(1, "Ken");
        NumberTupleExpression thenExpr = new NumberTupleExpression((Object)1);
        ArrayList whenList = Lists.newArrayList();
        whenList.add(new Pair((Object)whenFilter, (Object)thenExpr));
        NumberTupleExpression elseExpr = new NumberTupleExpression((Object)2);
        CaseTupleExpression caseExpression = new CaseTupleExpression((List)whenList, (TupleExpression)elseExpr);
        HashMap tupleExpressionMap = Maps.newHashMap();
        tupleExpressionMap.put(3, caseExpression);
        GTScanRequest scanRequest = new GTScanRequestBuilder().setInfo(gtInfo).setRanges(null).setDimensions(dimensions).setAggrGroupBy(aggrGroupBy).setAggrMetrics(aggrMetrics).setAggrMetricsFuncs(aggrMetricsFuncs).setDynamicColumns(dynColumns).setExprsPushDown((Map)tupleExpressionMap).setStartTime(System.currentTimeMillis()).createGTScanRequest();
        List<CubeVisitProtos.CubeVisitRequest.IntList> intListList = CubeVisitServiceTest.mockIntList(CubeVisitServiceTest.setOf(2));
        return CubeVisitServiceTest.mockScanRequest(rawScans, scanRequest, intListList);
    }

    public static CubeVisitProtos.CubeVisitRequest mockScanRequestWithRuntimeAggregates(GTInfo gtInfo, List<RawScan> rawScans) throws IOException {
        ImmutableBitSet dimensions = CubeVisitServiceTest.setOf(1);
        ImmutableBitSet aggrGroupBy = CubeVisitServiceTest.setOf(1);
        ImmutableBitSet aggrMetrics = CubeVisitServiceTest.setOf(3);
        String[] aggrMetricsFuncs = new String[]{"SUM"};
        ImmutableBitSet dynColumns = CubeVisitServiceTest.setOf(3);
        ImmutableBitSet rtAggrMetrics = CubeVisitServiceTest.setOf(2);
        CompareTupleFilter whenFilter = CubeVisitServiceTest.getCompareTupleFilter(1, "Ken");
        ColumnTupleExpression colExpression = new ColumnTupleExpression(gtInfo.colRef(2));
        NumberTupleExpression constExpression1 = new NumberTupleExpression((Object)1);
        NumberTupleExpression constExpression2 = new NumberTupleExpression((Object)2);
        BinaryTupleExpression biExpression = new BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum.MULTIPLE, (List)Lists.newArrayList((Object[])new TupleExpression[]{colExpression, constExpression2}));
        BinaryTupleExpression thenExpression = new BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum.PLUS, (List)Lists.newArrayList((Object[])new TupleExpression[]{biExpression, constExpression1}));
        ArrayList whenList = Lists.newArrayList();
        whenList.add(new Pair((Object)whenFilter, (Object)thenExpression));
        NumberTupleExpression elseExpression = new NumberTupleExpression((Object)1);
        CaseTupleExpression caseExpression = new CaseTupleExpression((List)whenList, (TupleExpression)elseExpression);
        HashMap tupleExpressionMap = Maps.newHashMap();
        tupleExpressionMap.put(3, caseExpression);
        GTScanRequest scanRequest = new GTScanRequestBuilder().setInfo(gtInfo).setRanges(null).setDimensions(dimensions).setAggrGroupBy(aggrGroupBy).setAggrMetrics(aggrMetrics).setAggrMetricsFuncs(aggrMetricsFuncs).setRtAggrMetrics(rtAggrMetrics).setDynamicColumns(dynColumns).setExprsPushDown((Map)tupleExpressionMap).setStartTime(System.currentTimeMillis()).createGTScanRequest();
        List<CubeVisitProtos.CubeVisitRequest.IntList> intListList = CubeVisitServiceTest.mockIntList(CubeVisitServiceTest.setOf(2));
        return CubeVisitServiceTest.mockScanRequest(rawScans, scanRequest, intListList);
    }

    public static CompareTupleFilter getCompareTupleFilter(int col, Object value) {
        TblColRef colRef = gtInfo.colRef(col);
        ColumnTupleFilter colFilter = new ColumnTupleFilter(colRef);
        ByteArray space = new ByteArray(gtInfo.getCodeSystem().maxCodeLength(col));
        gtInfo.getCodeSystem().encodeColumnValue(col, value, space.asBuffer());
        ConstantTupleFilter constFilter = new ConstantTupleFilter((Object)space);
        CompareTupleFilter compareFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
        compareFilter.addChild((TupleFilter)colFilter);
        compareFilter.addChild((TupleFilter)constFilter);
        return compareFilter;
    }

    public static CubeVisitProtos.CubeVisitRequest mockFullScanRequest(GTInfo gtInfo, List<RawScan> rawScans) throws IOException {
        GTScanRequest scanRequest = new GTScanRequestBuilder().setInfo(gtInfo).setRanges(null).setDimensions(null).setStartTime(System.currentTimeMillis()).createGTScanRequest();
        List<CubeVisitProtos.CubeVisitRequest.IntList> intListList = CubeVisitServiceTest.mockIntList(CubeVisitServiceTest.setOf(2, 3));
        return CubeVisitServiceTest.mockScanRequest(rawScans, scanRequest, intListList);
    }

    public static CubeVisitProtos.CubeVisitRequest mockScanRequest(List<RawScan> rawScans, GTScanRequest scanRequest, List<CubeVisitProtos.CubeVisitRequest.IntList> intListList) throws IOException {
        CubeVisitProtos.CubeVisitRequest.Builder builder = CubeVisitProtos.CubeVisitRequest.newBuilder();
        builder.setGtScanRequest(CubeHBaseEndpointRPC.serializeGTScanReq((GTScanRequest)scanRequest)).setHbaseRawScan(CubeHBaseEndpointRPC.serializeRawScans(rawScans));
        for (CubeVisitProtos.CubeVisitRequest.IntList intList : intListList) {
            builder.addHbaseColumnsToGT(intList);
        }
        builder.setRowkeyPreambleSize(10);
        builder.setKylinProperties(CubeVisitServiceTest.getTestConfig().exportAllToString());
        builder.setQueryId(UUID.randomUUID().toString());
        builder.setSpillEnabled(CubeVisitServiceTest.getTestConfig().getQueryCoprocessorSpillEnabled());
        builder.setMaxScanBytes(CubeVisitServiceTest.getTestConfig().getPartitionMaxScanBytes());
        return builder.build();
    }

    private static List<CubeVisitProtos.CubeVisitRequest.IntList> mockIntList(ImmutableBitSet selectedCols) {
        ArrayList hbaseColumnsToGT = Lists.newArrayList();
        hbaseColumnsToGT.add(Lists.newArrayList((Iterator)selectedCols.iterator()));
        ArrayList hbaseColumnsToGTIntList = Lists.newArrayList();
        for (List list : hbaseColumnsToGT) {
            hbaseColumnsToGTIntList.add(CubeVisitProtos.CubeVisitRequest.IntList.newBuilder().addAllInts((Iterable)list).build());
        }
        return hbaseColumnsToGTIntList;
    }

    private static RawScan mockFullScan(GTInfo gtInfo, KylinConfig kylinConfig) {
        ArrayList selectedColumns = Lists.newArrayList();
        selectedColumns.add(new Pair((Object)FAM, (Object)COL_M));
        int headerLength = 10;
        int bodyLength = 0;
        ImmutableBitSet primaryKey = gtInfo.getPrimaryKey();
        for (int i = 0; i < primaryKey.trueBitCount(); ++i) {
            bodyLength += gtInfo.getCodeSystem().getDimEnc(primaryKey.trueBitAt(i)).getLengthOfEncoding();
        }
        byte[] start = new byte[headerLength + bodyLength];
        BytesUtil.writeShort((short)0, (byte[])start, (int)0, (int)2);
        System.arraycopy(Bytes.toBytes((long)3L), 0, start, 2, 8);
        byte[] end = new byte[headerLength + bodyLength + 1];
        for (int i = 0; i < end.length - 1; ++i) {
            end[i] = -1;
        }
        BytesUtil.writeShort((short)0, (byte[])end, (int)0, (int)2);
        System.arraycopy(Bytes.toBytes((long)3L), 0, end, 2, 8);
        List fuzzyKeys = Collections.emptyList();
        return new RawScan(start, end, (List)selectedColumns, fuzzyKeys, kylinConfig.getHBaseScanCacheRows(), kylinConfig.getHBaseScanMaxResultSize());
    }

    private static GridTable newTable(GTInfo info) throws IOException {
        GTSimpleMemStore store = new GTSimpleMemStore(info);
        GridTable table = new GridTable(info, (IGTStore)store);
        GTRecord record = new GTRecord(info);
        Random rand = new Random();
        GTBuilder builder = table.rebuild();
        expUserRet.clear();
        HashMap contents = Maps.newHashMap();
        for (String date : dateList) {
            for (String user : userList) {
                List innerList = (List)contents.get(user);
                if (innerList == null) {
                    innerList = Lists.newArrayList();
                    contents.put(user, innerList);
                }
                BigDecimal value = priceList.get(rand.nextInt(priceList.size()));
                innerList.add(value);
                builder.write(record.setValues(new Object[]{date, user, value, new BigDecimal(0)}));
            }
        }
        for (String user : contents.keySet()) {
            BigDecimal sum = new BigDecimal(0);
            for (BigDecimal innerValue : (List)contents.get(user)) {
                sum = sum.add(innerValue);
            }
            expUserRet.put(user, sum);
        }
        builder.close();
        return table;
    }

    private static GTInfo newInfo() {
        GTInfo.Builder builder = GTInfo.builder();
        builder.setColumns(new DataType[]{DataType.getType((String)"date"), DataType.getType((String)"string"), DataType.getType((String)"decimal"), DataType.getType((String)"decimal")});
        return CubeVisitServiceTest.newInfo(builder);
    }

    private static GTInfo newInfo(GTInfo.Builder builder) {
        ImmutableBitSet dimensionColumns = CubeVisitServiceTest.setOf(0, 1);
        DimensionEncoding[] dimEncs = new DimensionEncoding[]{new DateDimEnc(), new DictionaryDimEnc(CubeVisitServiceTest.strsToDict(userList))};
        builder.setCodeSystem((IGTCodeSystem)new CubeCodeSystem(dimEncs));
        builder.setPrimaryKey(dimensionColumns);
        ImmutableBitSet measureColumns = CubeVisitServiceTest.setOf(2, 3);
        builder.enableColumnBlock(new ImmutableBitSet[]{dimensionColumns, measureColumns});
        GTInfo info = builder.build();
        return info;
    }

    private static Dictionary strsToDict(Collection<String> strs) {
        TrieDictionaryBuilder builder = new TrieDictionaryBuilder((BytesConverter)new StringBytesConverter());
        for (String str : strs) {
            builder.addValue((Object)str);
        }
        return builder.build(0);
    }

    public static ImmutableBitSet setOf(int ... values) {
        BitSet set = new BitSet();
        for (int i : values) {
            set.set(i);
        }
        return new ImmutableBitSet(set);
    }
}

