/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.DisabledRegionSplitPolicy;
import org.apache.hadoop.hbase.security.User;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinVersion;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnFamilyDesc;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.DeployCoprocessorCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeHTableUtil {
    private static final Logger logger = LoggerFactory.getLogger(CubeHTableUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHTable(CubeSegment cubeSegment, byte[][] splitKeys) throws IOException {
        String commitInfo;
        String tableName = cubeSegment.getStorageLocationIdentifier();
        CubeInstance cubeInstance = cubeSegment.getCubeInstance();
        CubeDesc cubeDesc = cubeInstance.getDescriptor();
        KylinConfig kylinConfig = cubeDesc.getConfig();
        HTableDescriptor tableDesc = new HTableDescriptor(TableName.valueOf((String)cubeSegment.getStorageLocationIdentifier()));
        tableDesc.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
        tableDesc.setValue("KYLIN_HOST", kylinConfig.getMetadataUrlPrefix());
        tableDesc.setValue("CREATION_TIME", String.valueOf(System.currentTimeMillis()));
        if (!StringUtils.isEmpty((String)kylinConfig.getKylinOwner())) {
            tableDesc.setValue("OWNER", kylinConfig.getKylinOwner());
        }
        if (!StringUtils.isEmpty((String)(commitInfo = KylinVersion.getGitCommitInfo()))) {
            tableDesc.setValue("GIT_COMMIT", commitInfo);
        }
        tableDesc.setValue("USER", cubeInstance.getOwner());
        tableDesc.setValue("SEGMENT", cubeSegment.toString());
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        Connection conn = HBaseConnection.get(kylinConfig.getStorageUrl());
        Admin admin = conn.getAdmin();
        try {
            if (User.isHBaseSecurityEnabled((Configuration)conf)) {
                tableDesc.addCoprocessor("org.apache.hadoop.hbase.security.access.SecureBulkLoadEndpoint");
            }
            for (HBaseColumnFamilyDesc cfDesc : cubeDesc.getHbaseMapping().getColumnFamily()) {
                HColumnDescriptor cf = CubeHTableUtil.createColumnFamily(kylinConfig, cfDesc.getName(), cfDesc.isMemoryHungry());
                tableDesc.addFamily(cf);
            }
            if (admin.tableExists(TableName.valueOf((String)tableName))) {
                throw new RuntimeException("HBase table " + tableName + " exists!");
            }
            DeployCoprocessorCLI.deployCoprocessor(tableDesc);
            admin.createTable(tableDesc, splitKeys);
            Preconditions.checkArgument((boolean)admin.isTableAvailable(TableName.valueOf((String)tableName)), (Object)("table " + tableName + " created, but is not available due to some reasons"));
            logger.info("create hbase table " + tableName + " done.");
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    public static void deleteHTable(TableName tableName) throws IOException {
        Admin admin = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl()).getAdmin();
        try {
            if (admin.tableExists(tableName)) {
                logger.info("disabling hbase table " + tableName);
                admin.disableTable(tableName);
                logger.info("deleting hbase table " + tableName);
                admin.deleteTable(tableName);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createBenchmarkHTable(TableName tableName, String cfName) throws IOException {
        Admin admin = HBaseConnection.get(KylinConfig.getInstanceFromEnv().getStorageUrl()).getAdmin();
        try {
            if (admin.tableExists(tableName)) {
                logger.info("disabling hbase table " + tableName);
                admin.disableTable(tableName);
                logger.info("deleting hbase table " + tableName);
                admin.deleteTable(tableName);
            }
            HTableDescriptor tableDesc = new HTableDescriptor(tableName);
            tableDesc.setValue("SPLIT_POLICY", DisabledRegionSplitPolicy.class.getName());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            tableDesc.addFamily(CubeHTableUtil.createColumnFamily(kylinConfig, cfName, false));
            logger.info("creating hbase table " + tableName);
            admin.createTable(tableDesc, (byte[][])null);
            Preconditions.checkArgument((boolean)admin.isTableAvailable(tableName), (Object)("table " + tableName + " created, but is not available due to some reasons"));
            logger.info("create hbase table " + tableName + " done.");
        }
        finally {
            IOUtils.closeQuietly((Closeable)admin);
        }
    }

    public static HColumnDescriptor createColumnFamily(KylinConfig kylinConfig, String cfName, boolean isMemoryHungry) {
        String hbaseDefaultCC;
        HColumnDescriptor cf = new HColumnDescriptor(cfName);
        cf.setMaxVersions(1);
        if (isMemoryHungry) {
            cf.setBlocksize(kylinConfig.getHbaseDefaultBlockSize());
        } else {
            cf.setBlocksize(kylinConfig.getHbaseSmallFamilyBlockSize());
        }
        switch (hbaseDefaultCC = kylinConfig.getHbaseDefaultCompressionCodec().toLowerCase(Locale.ROOT)) {
            case "snappy": {
                logger.info("hbase will use snappy to compress data");
                cf.setCompressionType(Compression.Algorithm.SNAPPY);
                break;
            }
            case "lzo": {
                logger.info("hbase will use lzo to compress data");
                cf.setCompressionType(Compression.Algorithm.LZO);
                break;
            }
            case "gz": 
            case "gzip": {
                logger.info("hbase will use gzip to compress data");
                cf.setCompressionType(Compression.Algorithm.GZ);
                break;
            }
            case "lz4": {
                logger.info("hbase will use lz4 to compress data");
                cf.setCompressionType(Compression.Algorithm.LZ4);
                break;
            }
            default: {
                logger.info("hbase will not use any compression algorithm to compress data");
                cf.setCompressionType(Compression.Algorithm.NONE);
            }
        }
        try {
            String encodingStr = kylinConfig.getHbaseDefaultEncoding();
            DataBlockEncoding encoding = DataBlockEncoding.valueOf((String)encodingStr);
            cf.setDataBlockEncoding(encoding);
        }
        catch (Exception e) {
            logger.info("hbase will not use any encoding", (Throwable)e);
            cf.setDataBlockEncoding(DataBlockEncoding.NONE);
        }
        cf.setInMemory(false);
        cf.setBloomFilterType(BloomType.NONE);
        cf.setScope(kylinConfig.getHBaseReplicationScope());
        return cf;
    }
}

