/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source.datagen;

import java.io.IOException;
import java.util.Map;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.datagen.ModelDataGenerator;
import org.apache.kylin.source.datagen.Util;

public class TableGenConfig {
    boolean needGen;
    double rows;

    public TableGenConfig(TableDesc table, ModelDataGenerator modelGen) throws IOException {
        String dataGen = table.getDataGen();
        if (dataGen == null && !modelGen.existsInStore(table)) {
            dataGen = "";
        }
        if (dataGen == null || "no".equals(dataGen) || "false".equals(dataGen) || "skip".equals(dataGen)) {
            return;
        }
        if (table.isView()) {
            return;
        }
        this.needGen = true;
        Map<String, String> config = Util.parseEqualCommaPairs(dataGen, "rows");
        this.rows = Util.parseDouble(config, "rows", modelGen.getModle().isFactTable(table.getIdentity()) ? 1.0 : 20.0);
    }
}

