/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.realization;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class CapabilityResult {
    public boolean capable;
    public int cost;
    public IncapableCause incapableCause;
    public List<CapabilityInfluence> influences = Lists.newArrayListWithCapacity((int)1);

    public static class IncapableCause {
        private IncapableType incapableType;
        private Collection<TblColRef> unmatchedDimensions;
        private Collection<FunctionDesc> unmatchedAggregations;

        public static IncapableCause unmatchedDimensions(Collection<TblColRef> unmatchedDimensions) {
            IncapableCause incapableCause = new IncapableCause();
            incapableCause.setIncapableType(IncapableType.UNMATCHED_DIMENSION);
            incapableCause.setUnmatchedDimensions(unmatchedDimensions);
            return incapableCause;
        }

        public static IncapableCause unmatchedAggregations(Collection<FunctionDesc> unmatchedAggregations) {
            IncapableCause incapableCause = new IncapableCause();
            incapableCause.setIncapableType(IncapableType.UNMATCHED_AGGREGATION);
            incapableCause.setUnmatchedAggregations(unmatchedAggregations);
            return incapableCause;
        }

        public static IncapableCause create(IncapableType incapableType) {
            IncapableCause incapableCause = new IncapableCause();
            incapableCause.setIncapableType(incapableType);
            return incapableCause;
        }

        public IncapableType getIncapableType() {
            return this.incapableType;
        }

        public void setIncapableType(IncapableType incapableType) {
            this.incapableType = incapableType;
        }

        public Collection<TblColRef> getUnmatchedDimensions() {
            return this.unmatchedDimensions;
        }

        public void setUnmatchedDimensions(Collection<TblColRef> unmatchedDimensions) {
            this.unmatchedDimensions = unmatchedDimensions;
        }

        public Collection<FunctionDesc> getUnmatchedAggregations() {
            return this.unmatchedAggregations;
        }

        public void setUnmatchedAggregations(Collection<FunctionDesc> unmatchedAggregations) {
            this.unmatchedAggregations = unmatchedAggregations;
        }
    }

    public static enum IncapableType {
        UNMATCHED_DIMENSION,
        UNMATCHED_AGGREGATION,
        UNSUPPORT_MASSIN,
        UNSUPPORT_RAWQUERY,
        LIMIT_PRECEDE_AGGR,
        II_UNMATCHED_FACT_TABLE,
        II_MISSING_COLS;

    }

    public static class DimensionAsMeasure
    implements CapabilityInfluence {
        final FunctionDesc function;

        public DimensionAsMeasure(FunctionDesc function) {
            this.function = function;
        }

        @Override
        public double suggestCostMultiplier() {
            return 1.0;
        }

        @Override
        public MeasureDesc getInvolvedMeasure() {
            return null;
        }

        public FunctionDesc getMeasureFunction() {
            return this.function;
        }
    }

    public static interface CapabilityInfluence {
        public double suggestCostMultiplier();

        public MeasureDesc getInvolvedMeasure();
    }
}

