/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;

public class TimeConditionLiteralsReplacer
implements TupleFilterSerializer.Decorator {
    private IdentityHashMap<TupleFilter, DataType> dateCompareTupleChildren = Maps.newIdentityHashMap();

    public TimeConditionLiteralsReplacer(TupleFilter root) {
    }

    @Override
    public TupleFilter onSerialize(TupleFilter filter) {
        if (filter instanceof CompareTupleFilter) {
            CompareTupleFilter cfilter = (CompareTupleFilter)filter;
            List<? extends TupleFilter> children = cfilter.getChildren();
            if (children == null || children.size() < 1) {
                throw new IllegalArgumentException("Illegal compare filter: " + cfilter);
            }
            TblColRef col = cfilter.getColumn();
            if (col == null || !col.getType().isDateTimeFamily()) {
                return cfilter;
            }
            for (TupleFilter tupleFilter : filter.getChildren()) {
                this.dateCompareTupleChildren.put(tupleFilter, col.getType());
            }
        }
        if (filter instanceof ConstantTupleFilter && this.dateCompareTupleChildren.containsKey(filter)) {
            ConstantTupleFilter constantTupleFilter = (ConstantTupleFilter)filter;
            HashSet newValues = Sets.newHashSet();
            DataType columnType = this.dateCompareTupleChildren.get(filter);
            for (String string : constantTupleFilter.getValues()) {
                newValues.add(this.formatTime(string, columnType));
            }
            return new ConstantTupleFilter(newValues);
        }
        return filter;
    }

    private String formatTime(String dateStr, DataType dataType) {
        if (dataType.isDatetime() || dataType.isTime()) {
            throw new RuntimeException("Datetime and time type are not supported yet");
        }
        if (DateFormat.isSupportedDateFormat(dateStr)) {
            return dateStr;
        }
        long millis = Long.parseLong(dateStr);
        if (dataType.isTimestamp()) {
            return DateFormat.formatToTimeStr(millis);
        }
        if (dataType.isDate()) {
            return DateFormat.formatToDateStr(millis);
        }
        throw new RuntimeException("Unknown type " + dataType + " to formatTime");
    }
}

