/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.bitmap;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.apache.kylin.measure.bitmap.BitmapAggregator;
import org.apache.kylin.measure.bitmap.BitmapCounter;
import org.apache.kylin.measure.bitmap.BitmapCounterFactory;
import org.apache.kylin.measure.bitmap.BitmapDistinctCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapIntersectDistinctCountAggFunc;
import org.apache.kylin.measure.bitmap.BitmapSerializer;
import org.apache.kylin.measure.bitmap.RoaringBitmapCounterFactory;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;

public class BitmapMeasureType
extends MeasureType<BitmapCounter> {
    public static final String FUNC_COUNT_DISTINCT = "COUNT_DISTINCT";
    public static final String FUNC_INTERSECT_COUNT_DISTINCT = "INTERSECT_COUNT";
    public static final String DATATYPE_BITMAP = "bitmap";
    static final Map<String, Class<?>> UDAF_MAP = ImmutableMap.of((Object)"COUNT_DISTINCT", BitmapDistinctCountAggFunc.class, (Object)"INTERSECT_COUNT", BitmapIntersectDistinctCountAggFunc.class);

    @Override
    public void validate(FunctionDesc functionDesc) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)FUNC_COUNT_DISTINCT.equals(functionDesc.getExpression()), (String)"BitmapMeasureType only support function %s, got %s", (Object[])new Object[]{FUNC_COUNT_DISTINCT, functionDesc.getExpression()});
        Preconditions.checkArgument((functionDesc.getParameterCount() == 1 ? 1 : 0) != 0, (String)"BitmapMeasureType only support 1 parameter, got %d", (Object[])new Object[]{functionDesc.getParameterCount()});
        String returnType = functionDesc.getReturnDataType().getName();
        Preconditions.checkArgument((boolean)DATATYPE_BITMAP.equals(returnType), (String)"BitmapMeasureType's return type must be %s, got %s", (Object[])new Object[]{DATATYPE_BITMAP, returnType});
    }

    @Override
    public boolean isMemoryHungry() {
        return true;
    }

    @Override
    public MeasureIngester<BitmapCounter> newIngester() {
        final BitmapCounterFactory factory = RoaringBitmapCounterFactory.INSTANCE;
        return new MeasureIngester<BitmapCounter>(){
            BitmapCounter current;
            {
                this.current = factory.newBitmap();
            }

            @Override
            public BitmapCounter valueOf(String[] values, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> dictionaryMap) {
                int id;
                Preconditions.checkArgument((values.length == 1 ? 1 : 0) != 0, (String)"expect 1 value, got %s", (Object[])new Object[]{Arrays.toString(values)});
                this.current.clear();
                if (values[0] == null) {
                    return this.current;
                }
                if (BitmapMeasureType.this.needDictionaryColumn(measureDesc.getFunction())) {
                    TblColRef literalCol = measureDesc.getFunction().getParameter().getColRefs().get(0);
                    Dictionary<String> dictionary = dictionaryMap.get(literalCol);
                    id = dictionary.getIdFromValue(values[0]);
                } else {
                    id = Integer.parseInt(values[0]);
                }
                this.current.add(id);
                return this.current;
            }

            @Override
            public BitmapCounter reEncodeDictionary(BitmapCounter value, MeasureDesc measureDesc, Map<TblColRef, Dictionary<String>> oldDicts, Map<TblColRef, Dictionary<String>> newDicts) {
                return value;
            }

            @Override
            public void reset() {
                this.current = factory.newBitmap();
            }
        };
    }

    @Override
    public MeasureAggregator<BitmapCounter> newAggregator() {
        return new BitmapAggregator();
    }

    @Override
    public List<TblColRef> getColumnsNeedDictionary(FunctionDesc functionDesc) {
        if (this.needDictionaryColumn(functionDesc)) {
            return Collections.singletonList(functionDesc.getParameter().getColRefs().get(0));
        }
        return Collections.emptyList();
    }

    private boolean needDictionaryColumn(FunctionDesc functionDesc) {
        DataType dataType = functionDesc.getParameter().getColRefs().get(0).getType();
        return !dataType.isIntegerFamily() || dataType.isBigInt();
    }

    @Override
    public boolean needRewrite() {
        return true;
    }

    @Override
    public Map<String, Class<?>> getRewriteCalciteAggrFunctions() {
        return UDAF_MAP;
    }

    @Override
    public void adjustSqlDigest(List<MeasureDesc> measureDescs, SQLDigest sqlDigest) {
        for (SQLDigest.SQLCall call : sqlDigest.aggrSqlCalls) {
            TblColRef col;
            if (!FUNC_INTERSECT_COUNT_DISTINCT.equals(call.function) || sqlDigest.groupbyColumns.contains(col = (TblColRef)call.args.get(1))) continue;
            sqlDigest.groupbyColumns.add(col);
        }
    }

    public static class Factory
    extends MeasureTypeFactory<BitmapCounter> {
        @Override
        public MeasureType<BitmapCounter> createMeasureType(String funcName, DataType dataType) {
            return new BitmapMeasureType();
        }

        @Override
        public String getAggrFunctionName() {
            return BitmapMeasureType.FUNC_COUNT_DISTINCT;
        }

        @Override
        public String getAggrDataTypeName() {
            return BitmapMeasureType.DATATYPE_BITMAP;
        }

        @Override
        public Class<? extends DataTypeSerializer<BitmapCounter>> getAggrDataTypeSerializer() {
            return BitmapSerializer.class;
        }
    }
}

