/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.global;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.dict.AppendTrieDictionary;
import org.apache.kylin.dict.BytesConverter;
import org.apache.kylin.dict.StringBytesConverter;
import org.apache.kylin.dict.global.AppendDictNode;
import org.apache.kylin.dict.global.AppendDictSlice;
import org.apache.kylin.dict.global.AppendDictSliceKey;
import org.apache.kylin.dict.global.GlobalDictHDFSStore;
import org.apache.kylin.dict.global.GlobalDictMetadata;
import org.apache.kylin.dict.global.GlobalDictStore;

public class AppendTrieDictionaryBuilder {
    private final String baseDir;
    private final String workingDir;
    private final int maxEntriesPerSlice;
    private final boolean isAppendDictGlobal;
    private GlobalDictStore store;
    private int maxId;
    private int maxValueLength;
    private int nValues;
    private BytesConverter bytesConverter;
    private TreeMap<AppendDictSliceKey, String> sliceFileMap = new TreeMap();
    private AppendDictSliceKey curKey;
    private AppendDictNode curNode;

    public AppendTrieDictionaryBuilder(String baseDir, int maxEntriesPerSlice, boolean isAppendDictGlobal) throws IOException {
        this.baseDir = baseDir;
        this.workingDir = baseDir + "working";
        this.maxEntriesPerSlice = maxEntriesPerSlice;
        this.isAppendDictGlobal = isAppendDictGlobal;
        this.init();
    }

    public synchronized void init() throws IOException {
        this.store = new GlobalDictHDFSStore(this.baseDir);
        this.store.prepareForWrite(this.workingDir, this.isAppendDictGlobal);
        Long[] versions = this.store.listAllVersions();
        if (versions.length == 0 || !this.isAppendDictGlobal) {
            this.maxId = 0;
            this.maxValueLength = 0;
            this.nValues = 0;
            this.bytesConverter = new StringBytesConverter();
        } else {
            GlobalDictMetadata metadata = this.store.getMetadata(versions[versions.length - 1]);
            this.maxId = metadata.maxId;
            this.maxValueLength = metadata.maxValueLength;
            this.nValues = metadata.nValues;
            this.bytesConverter = metadata.bytesConverter;
            this.sliceFileMap = new TreeMap<AppendDictSliceKey, String>((SortedMap<AppendDictSliceKey, String>)metadata.sliceFileMap);
        }
    }

    public void addValue(String value) throws IOException {
        byte[] valueBytes = this.bytesConverter.convertToBytes(value);
        if (this.sliceFileMap.isEmpty()) {
            this.curNode = new AppendDictNode(new byte[0], false);
            this.sliceFileMap.put(AppendDictSliceKey.START_KEY, null);
        }
        Preconditions.checkState((boolean)this.sliceFileMap.firstKey().equals(AppendDictSliceKey.START_KEY), (String)"first key should be \"\", but got \"%s\"", (Object[])new Object[]{this.sliceFileMap.firstKey()});
        AppendDictSliceKey nextKey = this.sliceFileMap.floorKey(AppendDictSliceKey.wrap(valueBytes));
        if (this.curKey != null && !nextKey.equals(this.curKey)) {
            this.flushCurrentNode();
            this.curNode = null;
        }
        if (this.curNode == null) {
            AppendDictSlice slice = this.store.readSlice(this.workingDir, this.sliceFileMap.get(nextKey));
            this.curNode = slice.rebuildTrieTree();
        }
        this.curKey = nextKey;
        this.addValueR(this.curNode, valueBytes, 0);
        if (this.curNode.childrenCount > this.maxEntriesPerSlice) {
            AppendDictNode newRoot = this.splitNodeTree(this.curNode);
            this.flushCurrentNode();
            this.curNode = newRoot;
            this.curKey = AppendDictSliceKey.wrap(newRoot.firstValue());
            this.sliceFileMap.put(this.curKey, null);
        }
        this.maxValueLength = Math.max(this.maxValueLength, valueBytes.length);
    }

    public AppendTrieDictionary build(int baseId) throws IOException {
        if (this.curNode != null) {
            this.flushCurrentNode();
        }
        GlobalDictMetadata metadata = new GlobalDictMetadata(baseId, this.maxId, this.maxValueLength, this.nValues, this.bytesConverter, this.sliceFileMap);
        this.store.commit(this.workingDir, metadata, this.isAppendDictGlobal);
        AppendTrieDictionary dict = new AppendTrieDictionary();
        dict.init(this.baseDir);
        return dict;
    }

    private void flushCurrentNode() throws IOException {
        String newSliceFile = this.store.writeSlice(this.workingDir, this.curKey, this.curNode);
        String oldSliceFile = this.sliceFileMap.put(this.curKey, newSliceFile);
        if (oldSliceFile != null) {
            this.store.deleteSlice(this.workingDir, oldSliceFile);
        }
    }

    private void addValueR(AppendDictNode node, byte[] value, int start) {
        AppendDictNode c;
        int j;
        int i = 0;
        int n = node.part.length;
        int nn = value.length;
        int comp = 0;
        for (j = start; i < n && j < nn && (comp = BytesUtil.compareByteUnsigned(node.part[i], value[j])) == 0; ++i, ++j) {
        }
        if (j == nn) {
            if (i == n) {
                if (!node.isEndOfValue) {
                    node.id = this.createNextId();
                    node.isEndOfValue = true;
                }
            } else {
                AppendDictNode c2 = new AppendDictNode(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
                c2.id = node.id;
                node.reset(BytesUtil.subarray(node.part, 0, i), true);
                node.addChild(c2);
                node.id = this.createNextId();
            }
            return;
        }
        if (i < n) {
            AppendDictNode c1 = new AppendDictNode(BytesUtil.subarray(node.part, i, n), node.isEndOfValue, node.children);
            c1.id = node.id;
            AppendDictNode c2 = this.addNodeMaybeOverflow(value, j, nn);
            node.reset(BytesUtil.subarray(node.part, 0, i), false);
            if (comp < 0) {
                node.addChild(c1);
                node.addChild(c2);
            } else {
                node.addChild(c2);
                node.addChild(c1);
            }
            return;
        }
        byte lookfor = value[j];
        int lo = 0;
        int hi = node.children.size() - 1;
        int mid = 0;
        boolean found = false;
        comp = 0;
        while (!found && lo <= hi) {
            mid = lo + (hi - lo) / 2;
            c = node.children.get(mid);
            comp = BytesUtil.compareByteUnsigned(lookfor, c.part[0]);
            if (comp < 0) {
                hi = mid - 1;
                continue;
            }
            if (comp > 0) {
                lo = mid + 1;
                continue;
            }
            found = true;
        }
        if (found) {
            this.addValueR(node.children.get(mid), value, j);
        } else {
            c = this.addNodeMaybeOverflow(value, j, nn);
            node.addChild(comp <= 0 ? mid : mid + 1, c);
        }
    }

    private int createNextId() {
        int id = ++this.maxId;
        this.checkValidId(id);
        ++this.nValues;
        return id;
    }

    private void checkValidId(int id) {
        if (id == 0 || id == -1) {
            throw new IllegalArgumentException("AppendTrieDictionary Id Overflow Unsigned Integer Size 4294967294");
        }
    }

    private AppendDictNode addNodeMaybeOverflow(byte[] value, int start, int end) {
        AppendDictNode head = null;
        AppendDictNode current = null;
        while (start + 255 < end) {
            AppendDictNode c = new AppendDictNode(BytesUtil.subarray(value, start, start + 255), false);
            if (head == null) {
                head = c;
                current = c;
            } else {
                current.addChild(c);
                current = c;
            }
            start += 255;
        }
        AppendDictNode last = new AppendDictNode(BytesUtil.subarray(value, start, end), true);
        last.id = this.createNextId();
        if (head == null) {
            head = last;
        } else {
            current.addChild(last);
        }
        return head;
    }

    private AppendDictNode splitNodeTree(AppendDictNode root) {
        ArrayList<AppendDictNode> children;
        AppendDictNode parent = root;
        int childCountToSplit = (int)((double)this.maxEntriesPerSlice * 1.0 / 2.0);
        block0: while ((children = parent.children).size() != 0) {
            if (children.size() == 1) {
                parent = (AppendDictNode)children.get(0);
                continue;
            }
            for (int i = children.size() - 1; i >= 0; --i) {
                parent = (AppendDictNode)children.get(i);
                if (childCountToSplit > ((AppendDictNode)children.get((int)i)).childrenCount) {
                    childCountToSplit -= ((AppendDictNode)children.get((int)i)).childrenCount;
                    continue;
                }
                --childCountToSplit;
                continue block0;
            }
        }
        return AppendDictNode.splitNodeTree(parent);
    }

    public void setMaxId(int id) {
        this.maxId = id;
    }
}

