/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.metadata.model.ISegmentAdvisor;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeSegment
implements IBuildable,
ISegment,
Serializable {
    @JsonBackReference
    private CubeInstance cubeInstance;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="storage_location_identifier")
    private String storageLocationIdentifier;
    @JsonProperty(value="date_range_start")
    private long dateRangeStart;
    @JsonProperty(value="date_range_end")
    private long dateRangeEnd;
    @JsonProperty(value="source_offset_start")
    private long sourceOffsetStart;
    @JsonProperty(value="source_offset_end")
    private long sourceOffsetEnd;
    @JsonProperty(value="status")
    private SegmentStatusEnum status;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records")
    private long inputRecords;
    @JsonProperty(value="input_records_size")
    private long inputRecordsSize;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="last_build_job_id")
    private String lastBuildJobID;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="cuboid_shard_nums")
    private Map<Long, Short> cuboidShardNums = Maps.newHashMap();
    @JsonProperty(value="total_shards")
    private int totalShards = 0;
    @JsonProperty(value="blackout_cuboids")
    private List<Long> blackoutCuboids = Lists.newArrayList();
    @JsonProperty(value="binary_signature")
    private String binarySignature;
    @JsonProperty(value="dictionaries")
    private ConcurrentHashMap<String, String> dictionaries;
    @JsonProperty(value="snapshots")
    private ConcurrentHashMap<String, String> snapshots;
    @JsonProperty(value="rowkey_stats")
    private List<Object[]> rowkeyStats = Lists.newArrayList();
    @JsonProperty(value="source_partition_offset_start")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, Long> sourcePartitionOffsetStart = Maps.newHashMap();
    @JsonProperty(value="source_partition_offset_end")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<Integer, Long> sourcePartitionOffsetEnd = Maps.newHashMap();
    @JsonProperty(value="additionalInfo")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, String> additionalInfo = new LinkedHashMap<String, String>();
    @JsonProperty(value="dimension_range_info_map")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private Map<String, DimensionRangeInfo> dimensionRangeInfoMap = Maps.newHashMap();
    private Map<Long, Short> cuboidBaseShards = Maps.newConcurrentMap();
    volatile transient ISegmentAdvisor advisor = null;

    public CubeDesc getCubeDesc() {
        return this.getCubeInstance().getDescriptor();
    }

    public CuboidScheduler getCuboidScheduler() {
        return this.getCubeInstance().getCuboidScheduler();
    }

    public static String makeSegmentName(SegmentRange.TSRange tsRange, SegmentRange segRange, DataModelDesc modelDesc) {
        if (tsRange == null && segRange == null) {
            return "FULL_BUILD";
        }
        if (segRange != null) {
            return segRange.start.v + "_" + segRange.end.v;
        }
        if (!modelDesc.isStandardPartitionedDateColumn()) {
            return tsRange.start.v + "_" + tsRange.end.v;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ROOT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(tsRange.start.v) + "_" + dateFormat.format(tsRange.end.v);
    }

    @Override
    public KylinConfig getConfig() {
        return this.cubeInstance.getConfig();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SegmentStatusEnum getStatus() {
        return this.status;
    }

    @Override
    public DataModelDesc getModel() {
        return this.getCubeDesc().getModel();
    }

    public void setStatus(SegmentStatusEnum status) {
        this.status = status;
    }

    public long getSizeKB() {
        return this.sizeKB;
    }

    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getInputRecordsSize() {
        return this.inputRecordsSize;
    }

    public void setInputRecordsSize(long inputRecordsSize) {
        this.inputRecordsSize = inputRecordsSize;
    }

    @Override
    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public String getLastBuildJobID() {
        return this.lastBuildJobID;
    }

    public void setLastBuildJobID(String lastBuildJobID) {
        this.lastBuildJobID = lastBuildJobID;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    public String getBinarySignature() {
        return this.binarySignature;
    }

    public void setBinarySignature(String binarySignature) {
        this.binarySignature = binarySignature;
    }

    public CubeInstance getCubeInstance() {
        return this.cubeInstance;
    }

    public void setCubeInstance(CubeInstance cubeInstance) {
        this.cubeInstance = cubeInstance;
    }

    public String getStorageLocationIdentifier() {
        return this.storageLocationIdentifier;
    }

    public List<Object[]> getRowkeyStats() {
        return this.rowkeyStats;
    }

    public Map<String, String> getDictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = new ConcurrentHashMap();
        }
        return this.dictionaries;
    }

    public Map<String, String> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ConcurrentHashMap();
        }
        return this.snapshots;
    }

    public String getSnapshotResPath(String table) {
        return this.getSnapshots().get(table);
    }

    public void putSnapshotResPath(String table, String snapshotResPath) {
        this.getSnapshots().put(table, snapshotResPath);
    }

    public Collection<String> getDictionaryPaths() {
        return this.getDictionaries().values();
    }

    public Collection<String> getSnapshotPaths() {
        return this.getSnapshots().values();
    }

    public String getDictResPath(TblColRef col) {
        String dictKey = col.getIdentity();
        String r = this.getDictionaries().get(dictKey);
        if (r == null) {
            String v1DictKey = col.getTable() + "/" + col.getName();
            r = this.getDictionaries().get(v1DictKey);
        }
        return r;
    }

    public void putDictResPath(TblColRef col, String dictResPath) {
        String dictKey = col.getIdentity();
        this.getDictionaries().put(dictKey, dictResPath);
    }

    public void setStorageLocationIdentifier(String storageLocationIdentifier) {
        this.storageLocationIdentifier = storageLocationIdentifier;
    }

    public Map<TblColRef, Dictionary<String>> buildDictionaryMap() {
        HashMap result = Maps.newHashMap();
        for (TblColRef col : this.getCubeDesc().getAllColumnsHaveDictionary()) {
            result.put(col, this.getDictionary(col));
        }
        return result;
    }

    public Dictionary<String> getDictionary(TblColRef col) {
        TblColRef reuseCol = this.getCubeDesc().getDictionaryReuseColumn(col);
        CubeManager cubeMgr = CubeManager.getInstance(this.getCubeInstance().getConfig());
        return cubeMgr.getDictionary(this, reuseCol);
    }

    public CubeDimEncMap getDimensionEncodingMap() {
        return new CubeDimEncMap(this);
    }

    long _getDateRangeStart() {
        return this.dateRangeStart;
    }

    void _setDateRangeStart(long dateRangeStart) {
        this.dateRangeStart = dateRangeStart;
    }

    long _getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    void _setDateRangeEnd(long dateRangeEnd) {
        this.dateRangeEnd = dateRangeEnd;
    }

    long _getSourceOffsetStart() {
        return this.sourceOffsetStart;
    }

    void _setSourceOffsetStart(long sourceOffsetStart) {
        this.sourceOffsetStart = sourceOffsetStart;
    }

    long _getSourceOffsetEnd() {
        return this.sourceOffsetEnd;
    }

    void _setSourceOffsetEnd(long sourceOffsetEnd) {
        this.sourceOffsetEnd = sourceOffsetEnd;
    }

    @Override
    public SegmentRange getSegRange() {
        return this.getAdvisor().getSegRange();
    }

    public void setSegRange(SegmentRange range) {
        this.getAdvisor().setSegRange(range);
    }

    @Override
    public SegmentRange.TSRange getTSRange() {
        return this.getAdvisor().getTSRange();
    }

    public void setTSRange(SegmentRange.TSRange range) {
        this.getAdvisor().setTSRange(range);
    }

    @Override
    public boolean isOffsetCube() {
        return this.getAdvisor().isOffsetCube();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISegmentAdvisor getAdvisor() {
        if (this.advisor != null) {
            return this.advisor;
        }
        CubeSegment cubeSegment = this;
        synchronized (cubeSegment) {
            if (this.advisor == null) {
                this.advisor = Segments.newSegmentAdvisor(this);
            }
            return this.advisor;
        }
    }

    @Override
    public void validate() throws IllegalStateException {
        if (this.cubeInstance.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            if (!this.isOffsetCube() && this.dateRangeStart >= this.dateRangeEnd) {
                throw new IllegalStateException("Invalid segment, dateRangeStart(" + this.dateRangeStart + ") must be smaller than dateRangeEnd(" + this.dateRangeEnd + ") in segment " + this);
            }
            if (this.isOffsetCube() && this.sourceOffsetStart >= this.sourceOffsetEnd) {
                throw new IllegalStateException("Invalid segment, sourceOffsetStart(" + this.sourceOffsetStart + ") must be smaller than sourceOffsetEnd(" + this.sourceOffsetEnd + ") in segment " + this);
            }
        }
    }

    public String getProject() {
        return this.getCubeDesc().getProject();
    }

    @Override
    public int compareTo(ISegment other) {
        int comp = this.getSegRange().start.compareTo(other.getSegRange().start);
        if (comp != 0) {
            return comp;
        }
        return this.getSegRange().end.compareTo(other.getSegRange().end);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cubeInstance == null ? 0 : this.cubeInstance.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CubeSegment other = (CubeSegment)obj;
        if (this.cubeInstance == null ? other.cubeInstance != null : !this.cubeInstance.equals(other.cubeInstance)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return this.cubeInstance.getName() + "[" + this.name + "]";
    }

    public void setDictionaries(ConcurrentHashMap<String, String> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public void setSnapshots(ConcurrentHashMap<String, String> snapshots) {
        this.snapshots = snapshots;
    }

    public String getStatisticsResourcePath() {
        return CubeSegment.getStatisticsResourcePath(this.getCubeInstance().getName(), this.getUuid());
    }

    public static String getStatisticsResourcePath(String cubeName, String cubeSegmentId) {
        return "/cube_statistics/" + cubeName + "/" + cubeSegmentId + ".seq";
    }

    @Override
    public int getSourceType() {
        return this.cubeInstance.getSourceType();
    }

    @Override
    public int getEngineType() {
        return this.cubeInstance.getEngineType();
    }

    @Override
    public int getStorageType() {
        return this.cubeInstance.getStorageType();
    }

    public boolean isEnableSharding() {
        return this.getCubeDesc().isEnableSharding();
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getCubeDesc().getShardByColumns();
    }

    public int getRowKeyPreambleSize() {
        return this.isEnableSharding() ? 10 : 8;
    }

    public Short getCuboidShardNum(Long cuboidId) {
        Short ret = this.cuboidShardNums.get(cuboidId);
        if (ret == null) {
            return (short)1;
        }
        return ret;
    }

    public void setCuboidShardNums(Map<Long, Short> newCuboidShards) {
        this.cuboidShardNums = newCuboidShards;
    }

    public int getTotalShards(long cuboidId) {
        if (this.totalShards > 0) {
            return this.totalShards;
        }
        short ret = this.getCuboidShardNum(cuboidId);
        return ret;
    }

    public void setTotalShards(int totalShards) {
        this.totalShards = totalShards;
    }

    public short getCuboidBaseShard(Long cuboidId) {
        if (this.totalShards == 0) {
            return 0;
        }
        Short ret = this.cuboidBaseShards.get(cuboidId);
        if (ret == null) {
            ret = ShardingHash.getShard(cuboidId, this.totalShards);
            this.cuboidBaseShards.put(cuboidId, ret);
        }
        return ret;
    }

    public List<Long> getBlackoutCuboids() {
        return this.blackoutCuboids;
    }

    public IRealization getRealization() {
        return this.cubeInstance;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    public Map<Integer, Long> getSourcePartitionOffsetEnd() {
        return this.sourcePartitionOffsetEnd;
    }

    public void setSourcePartitionOffsetEnd(Map<Integer, Long> sourcePartitionOffsetEnd) {
        this.sourcePartitionOffsetEnd = sourcePartitionOffsetEnd;
    }

    public Map<Integer, Long> getSourcePartitionOffsetStart() {
        return this.sourcePartitionOffsetStart;
    }

    public void setSourcePartitionOffsetStart(Map<Integer, Long> sourcePartitionOffsetStart) {
        this.sourcePartitionOffsetStart = sourcePartitionOffsetStart;
    }

    public Map<String, DimensionRangeInfo> getDimensionRangeInfoMap() {
        return this.dimensionRangeInfoMap;
    }

    public void setDimensionRangeInfoMap(Map<String, DimensionRangeInfo> dimensionRangeInfoMap) {
        this.dimensionRangeInfoMap = dimensionRangeInfoMap;
    }
}

