/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.lock;

import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import org.apache.kylin.common.lock.DistributedLock;

public abstract class DistributedLockFactory {
    public abstract DistributedLock lockForClient(String var1);

    public DistributedLock lockForCurrentThread() {
        return this.lockForClient(DistributedLockFactory.threadProcessAndHost());
    }

    public DistributedLock lockForCurrentProcess() {
        return this.lockForClient(DistributedLockFactory.processAndHost());
    }

    private static String threadProcessAndHost() {
        return Thread.currentThread().getId() + "-" + DistributedLockFactory.processAndHost();
    }

    private static String processAndHost() {
        byte[] bytes = ManagementFactory.getRuntimeMXBean().getName().getBytes(StandardCharsets.UTF_8);
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

