/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.lookup;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.dict.lookup.IExtLookupTableCache;
import org.apache.kylin.engine.mr.steps.lookup.LookupExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSnapshotCacheForQueryServersStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(UpdateSnapshotCacheForQueryServersStep.class);

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        String tableName = LookupExecutableUtil.getLookupTableName((Map)this.getParams());
        String snapshotID = LookupExecutableUtil.getLookupSnapshotID((Map)this.getParams());
        String projectName = LookupExecutableUtil.getProjectName((Map)this.getParams());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        int checkInterval = 10000;
        int maxCheckTime = 600000;
        StringWriter outputWriter = new StringWriter();
        PrintWriter pw = new PrintWriter(outputWriter);
        String[] restServers = config.getRestServers();
        ArrayList serversNeedCheck = Lists.newArrayList();
        for (String restServer : restServers) {
            logger.info("send build lookup table cache request to server: " + (String)restServer);
            try {
                RestClient restClient = new RestClient(restServer);
                restClient.buildLookupSnapshotCache(projectName, tableName, snapshotID);
                serversNeedCheck.add(restServer);
            }
            catch (IOException e) {
                logger.error("error when send build cache request to rest server:" + (String)restServer, (Throwable)e);
                pw.println("cache build fail for rest server:" + (String)restServer);
            }
        }
        if (serversNeedCheck.isEmpty()) {
            return new ExecuteResult(ExecuteResult.State.SUCCEED, outputWriter.toString());
        }
        ArrayList completeServers = Lists.newArrayList();
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)maxCheckTime) {
            serversNeedCheck.removeAll(completeServers);
            if (serversNeedCheck.isEmpty()) break;
            for (String restServer : serversNeedCheck) {
                logger.info("check lookup table cache build status for server: " + restServer);
                try {
                    RestClient restClient = new RestClient(restServer);
                    String stateName = restClient.getLookupSnapshotCacheState(tableName, snapshotID);
                    if (stateName.equals(IExtLookupTableCache.CacheState.IN_BUILDING.name())) continue;
                    completeServers.add(restServer);
                    pw.println("cache build complete for rest server:" + restServer + " cache state:" + stateName);
                }
                catch (IOException e) {
                    logger.error("error when send build cache request to rest server:" + restServer, (Throwable)e);
                }
            }
            try {
                Thread.sleep(checkInterval);
            }
            catch (InterruptedException e) {
                logger.error("interrupted", (Throwable)e);
            }
        }
        serversNeedCheck.removeAll(completeServers);
        if (!serversNeedCheck.isEmpty()) {
            pw.println();
            pw.println("check timeout!");
            pw.println("servers not complete:" + serversNeedCheck);
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, outputWriter.toString());
    }
}

