/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.source;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.ProjectManager;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceManager {
    private static final Logger logger = LoggerFactory.getLogger(SourceManager.class);
    private final KylinConfig systemConfig;
    private final Cache<String, ISource> sourceMap;

    public static SourceManager getInstance(KylinConfig config) {
        return config.getManager(SourceManager.class);
    }

    static SourceManager newInstance(KylinConfig config) throws IOException {
        return new SourceManager(config);
    }

    private SourceManager(KylinConfig config) {
        this.systemConfig = config;
        this.sourceMap = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).removalListener((RemovalListener)new RemovalListener<String, ISource>(){

            public void onRemoval(RemovalNotification<String, ISource> entry) {
                ISource s = (ISource)entry.getValue();
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (Throwable e) {
                        logger.error("Failed to close ISource: {}", (Object)s.getClass().getName(), (Object)e);
                    }
                }
            }
        }).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISource getCachedSource(ISourceAware aware) {
        String key = this.createSourceCacheKey(aware);
        ISource source = (ISource)this.sourceMap.getIfPresent((Object)key);
        if (source != null) {
            return source;
        }
        SourceManager sourceManager = this;
        synchronized (sourceManager) {
            source = (ISource)this.sourceMap.getIfPresent((Object)key);
            if (source != null) {
                return source;
            }
            source = this.createSource(aware);
            this.sourceMap.put((Object)key, (Object)source);
            return source;
        }
    }

    public ISource getProjectSource(String projectName) {
        ProjectInstance projectInstance = ProjectManager.getInstance(this.systemConfig).getProject(projectName);
        if (projectInstance != null) {
            return this.getCachedSource(projectInstance);
        }
        return SourceManager.getDefaultSource();
    }

    private String createSourceCacheKey(ISourceAware aware) {
        StringBuilder builder = new StringBuilder();
        builder.append(aware.getSourceType()).append('|');
        KylinConfig config = aware.getConfig();
        builder.append(config.getJdbcSourceConnectionUrl()).append('|');
        builder.append(config.getJdbcSourceDriver()).append('|');
        builder.append(config.getJdbcSourceUser()).append('|');
        builder.append(config.getJdbcSourceFieldDelimiter()).append('|');
        builder.append(config.getJdbcSourceDialect()).append('|');
        return builder.toString();
    }

    private ISource createSource(ISourceAware aware) {
        String sourceClazz = this.systemConfig.getSourceEngines().get(aware.getSourceType());
        try {
            return ClassUtil.forName(sourceClazz, ISource.class).getDeclaredConstructor(KylinConfig.class).newInstance(aware.getConfig());
        }
        catch (Throwable e) {
            logger.error("Failed to create source: SourceType={}", (Object)aware.getSourceType(), (Object)e);
            return null;
        }
    }

    public static ISource getSource(ISourceAware aware) {
        return SourceManager.getInstance(aware.getConfig()).getCachedSource(aware);
    }

    public static ISource getDefaultSource() {
        final KylinConfig sysConfig = KylinConfig.getInstanceFromEnv();
        return SourceManager.getSource(new ISourceAware(){

            @Override
            public int getSourceType() {
                return sysConfig.getDefaultSource();
            }

            @Override
            public KylinConfig getConfig() {
                return sysConfig;
            }
        });
    }

    public static IReadableTable createReadableTable(TableDesc table) {
        return SourceManager.getSource(table).createReadableTable(table);
    }

    public static <T> T createEngineAdapter(ISourceAware table, Class<T> engineInterface) {
        return SourceManager.getSource(table).adaptToBuildEngine(engineInterface);
    }

    public static List<String> getMRDependentResources(TableDesc table) {
        return SourceManager.getSource(table).getSourceMetadataExplorer().getRelatedKylinResources(table);
    }
}

