/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.IOptimizeableTupleFilter;
import org.apache.kylin.metadata.filter.ITupleFilterTransformer;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterOptimizeTransformer
implements ITupleFilterTransformer {
    public static final Logger logger = LoggerFactory.getLogger(FilterOptimizeTransformer.class);

    @Override
    public TupleFilter transform(TupleFilter tupleFilter) {
        if (tupleFilter == null || !(tupleFilter instanceof IOptimizeableTupleFilter)) {
            return tupleFilter;
        }
        return ((IOptimizeableTupleFilter)((Object)tupleFilter)).acceptOptimizeTransformer(this);
    }

    public TupleFilter visit(CompareTupleFilter compareTupleFilter) {
        if (compareTupleFilter != null) {
            CompareTupleFilter.CompareResultType compareResultType = compareTupleFilter.getCompareResultType();
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysTrue) {
                logger.debug("Optimize CompareTupleFilter {{}} to ConstantTupleFilter.TRUE", (Object)compareTupleFilter);
                return ConstantTupleFilter.TRUE;
            }
            if (compareResultType == CompareTupleFilter.CompareResultType.AlwaysFalse) {
                logger.debug("Optimize CompareTupleFilter {{}} to ConstantTupleFilter.FALSE", (Object)compareTupleFilter);
                return ConstantTupleFilter.FALSE;
            }
        }
        return compareTupleFilter;
    }

    public TupleFilter visit(LogicalTupleFilter logicalTupleFilter) {
        if (logicalTupleFilter == null) {
            return null;
        }
        if (logicalTupleFilter.getOperator() == TupleFilter.FilterOperatorEnum.OR) {
            ListIterator<? extends TupleFilter> childIterator = logicalTupleFilter.getChildren().listIterator();
            while (childIterator.hasNext()) {
                TupleFilter next = childIterator.next();
                if (ConstantTupleFilter.TRUE.equals(next)) {
                    logger.debug("Optimized {{}} to ConstantTupleFilter.TRUE", (Object)logicalTupleFilter);
                    return ConstantTupleFilter.TRUE;
                }
                if (!ConstantTupleFilter.FALSE.equals(next)) continue;
                childIterator.remove();
            }
            if (logicalTupleFilter.getChildren().size() == 0) {
                return ConstantTupleFilter.FALSE;
            }
        } else if (logicalTupleFilter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            ListIterator<? extends TupleFilter> childIterator = logicalTupleFilter.getChildren().listIterator();
            while (childIterator.hasNext()) {
                TupleFilter next = childIterator.next();
                if (ConstantTupleFilter.FALSE.equals(next)) {
                    logger.debug("Optimized {{}} to ConstantTupleFilter.FALSE", (Object)logicalTupleFilter);
                    return ConstantTupleFilter.FALSE;
                }
                if (!ConstantTupleFilter.TRUE.equals(next)) continue;
                childIterator.remove();
            }
            if (logicalTupleFilter.getChildren().size() == 0) {
                return ConstantTupleFilter.TRUE;
            }
        }
        return logicalTupleFilter;
    }

    public TupleFilter visit(CaseTupleFilter caseTupleFilter) {
        List<TupleFilter> whenFilters = caseTupleFilter.getWhenFilters();
        List<TupleFilter> thenFilters = caseTupleFilter.getThenFilters();
        ArrayList newFilters = Lists.newArrayList();
        boolean changed = false;
        for (int i = 0; i < whenFilters.size(); ++i) {
            if (whenFilters.get(i) == ConstantTupleFilter.TRUE) {
                return thenFilters.get(i);
            }
            if (whenFilters.get(i) == ConstantTupleFilter.FALSE) {
                changed = true;
                continue;
            }
            newFilters.add(whenFilters.get(i));
            newFilters.add(thenFilters.get(i));
        }
        newFilters.add(caseTupleFilter.getElseFilter());
        if (!changed) {
            return caseTupleFilter;
        }
        if (newFilters.size() == 1) {
            return (TupleFilter)newFilters.get(0);
        }
        CaseTupleFilter newCaseTupleFilter = new CaseTupleFilter();
        newCaseTupleFilter.addChildren(newFilters);
        return newCaseTupleFilter;
    }
}

