/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.filter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class ExtractTupleFilter
extends TupleFilter {
    private int date;
    private List<Object> values;

    public ExtractTupleFilter(TupleFilter.FilterOperatorEnum op) {
        super(new ArrayList<TupleFilter>(3), op);
        assert (op == TupleFilter.FilterOperatorEnum.EXTRACT);
        this.values = new ArrayList<Object>(1);
        this.values.add(null);
        this.date = 0;
    }

    public String toString() {
        return "ExtractTupleFilter=[children=" + this.children + "]";
    }

    @Override
    public boolean isEvaluable() {
        return false;
    }

    @Override
    public boolean evaluate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        String extractType = null;
        String tupleValue = null;
        for (TupleFilter filter : this.children) {
            filter.evaluate(tuple, cs);
            if (filter instanceof ConstantTupleFilter) {
                tupleValue = filter.getValues().iterator().next().toString();
                continue;
            }
            if (!(filter instanceof CompareTupleFilter)) continue;
            extractType = filter.getValues().iterator().next().toString();
        }
        this.date = this.extractDate(extractType, Integer.valueOf(tupleValue));
        return true;
    }

    private int extractDate(String type, int inDate) {
        int j = inDate + 32044;
        int g = j / 146097;
        int dg = j % 146097;
        int c = (dg / 36524 + 1) * 3 / 4;
        int dc = dg - c * 36524;
        int b = dc / 1461;
        int db = dc % 1461;
        int a = (db / 365 + 1) * 3 / 4;
        int da = db - a * 365;
        int y = g * 400 + c * 100 + b * 4 + a;
        int m = (da * 5 + 308) / 153 - 2;
        int d = da - (m + 4) * 153 / 5 + 122;
        int year = y - 4800 + (m + 2) / 12;
        int month = (m + 2) % 12 + 1;
        int day = d + 1;
        if ("YEAR".equalsIgnoreCase(type)) {
            return year;
        }
        if ("MONTH".equalsIgnoreCase(type)) {
            return month;
        }
        if ("DAY".equalsIgnoreCase(type)) {
            return day;
        }
        return -1;
    }

    @Override
    public Collection<?> getValues() {
        this.values.set(0, String.valueOf(this.date));
        return this.values;
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }
}

