/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.expression;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kylin.common.util.DecimalUtil;
import org.apache.kylin.metadata.expression.ExpressionColCollector;
import org.apache.kylin.metadata.expression.ExpressionVisitor;
import org.apache.kylin.metadata.expression.TupleExpression;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;

public class BinaryTupleExpression
extends TupleExpression {
    public BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum op) {
        this(op, Lists.newArrayListWithExpectedSize((int)2));
    }

    public BinaryTupleExpression(TupleExpression.ExpressionOperatorEnum op, List<TupleExpression> exprs) {
        super(op, exprs);
        boolean opGood;
        boolean bl = opGood = op == TupleExpression.ExpressionOperatorEnum.PLUS || op == TupleExpression.ExpressionOperatorEnum.MINUS || op == TupleExpression.ExpressionOperatorEnum.MULTIPLE || op == TupleExpression.ExpressionOperatorEnum.DIVIDE;
        if (!opGood) {
            throw new IllegalArgumentException("Unsupported operator " + (Object)((Object)op));
        }
    }

    @Override
    public boolean ifForDynamicColumn() {
        return this.ifAbleToPushDown();
    }

    @Override
    public void verify() {
        switch (this.operator) {
            case MULTIPLE: {
                this.verifyMultiply();
                break;
            }
            case DIVIDE: {
                this.verifyDivide();
                break;
            }
        }
    }

    private void verifyMultiply() {
        if (ExpressionColCollector.collectMeasureColumns(this.getLeft()).size() > 0 && ExpressionColCollector.collectMeasureColumns(this.getRight()).size() > 0) {
            throw new IllegalArgumentException("That both of the two sides of the BinaryTupleExpression own columns is not supported for " + this.operator.toString());
        }
    }

    private void verifyDivide() {
        if (ExpressionColCollector.collectMeasureColumns(this.getRight()).size() > 0) {
            throw new IllegalArgumentException("That the right side of the BinaryTupleExpression owns columns is not supported for " + this.operator.toString());
        }
    }

    @Override
    public BigDecimal calculate(IEvaluatableTuple tuple, IFilterCodeSystem<?> cs) {
        assert (this.children.size() == 2);
        BigDecimal left = DecimalUtil.toBigDecimal(this.getLeft().calculate(tuple, cs));
        if (left == null) {
            return null;
        }
        BigDecimal right = DecimalUtil.toBigDecimal(this.getRight().calculate(tuple, cs));
        if (right == null) {
            return null;
        }
        switch (this.operator) {
            case PLUS: {
                return left.add(right);
            }
            case MINUS: {
                return left.subtract(right);
            }
            case MULTIPLE: {
                return left.multiply(right);
            }
            case DIVIDE: {
                return left.divide(right);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public TupleExpression accept(ExpressionVisitor visitor) {
        return visitor.visitBinary(this);
    }

    @Override
    public void serialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    @Override
    public void deserialize(IFilterCodeSystem<?> cs, ByteBuffer buffer) {
    }

    public TupleExpression getLeft() {
        return (TupleExpression)this.children.get(0);
    }

    public TupleExpression getRight() {
        return (TupleExpression)this.children.get(1);
    }

    public String toString() {
        return this.operator.toString() + "(" + this.getLeft().toString() + "," + this.getRight().toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryTupleExpression that = (BinaryTupleExpression)o;
        if (this.operator != that.operator) {
            return false;
        }
        return this.children.equals(that.children);
    }

    public int hashCode() {
        int result = this.operator != null ? this.operator.hashCode() : 0;
        result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
        return result;
    }
}

