/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.raw;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.measure.MeasureAggregator;

public class RawAggregator
extends MeasureAggregator<List<ByteArray>> {
    List<ByteArray> list = null;

    @Override
    public void reset() {
        this.list = null;
    }

    @Override
    public void aggregate(List<ByteArray> value) {
        if (value != null) {
            if (this.list == null) {
                this.list = new ArrayList<ByteArray>(value.size());
            }
            this.list.addAll(value);
        }
    }

    @Override
    public List<ByteArray> aggregate(List<ByteArray> value1, List<ByteArray> value2) {
        if (value1 == null) {
            return value2;
        }
        if (value2 == null) {
            return value1;
        }
        value1.addAll(value2);
        return value1;
    }

    @Override
    public List<ByteArray> getState() {
        return this.list;
    }

    @Override
    public int getMemBytesEstimate() {
        int bytes = 0;
        if (this.list != null) {
            for (ByteArray array : this.list) {
                bytes += array.length() + 1;
            }
        }
        return bytes;
    }
}

