/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.hllc;

import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.hllc.HLLCounter;

public class HLLCAggregator
extends MeasureAggregator<HLLCounter> {
    final int precision;
    HLLCounter sum = null;

    public HLLCAggregator(int precision) {
        this.precision = precision;
    }

    @Override
    public void reset() {
        this.sum = null;
    }

    @Override
    public void aggregate(HLLCounter value) {
        if (this.sum == null) {
            this.sum = new HLLCounter(value);
        } else {
            this.sum.merge(value);
        }
    }

    @Override
    public HLLCounter aggregate(HLLCounter value1, HLLCounter value2) {
        value1.merge(value2);
        return value1;
    }

    @Override
    public HLLCounter getState() {
        return this.sum;
    }

    @Override
    public int getMemBytesEstimate() {
        return 60 + (1 << this.precision);
    }
}

