/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dimension;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryDimEnc
extends DimensionEncoding
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(DictionaryDimEnc.class);
    public static final String ENCODING_NAME = "dict";
    public static final int MAX_ENCODING_LENGTH = 4;
    private Dictionary<String> dict;
    private int fixedLen;
    private int roundingFlag;
    private byte defaultByte;

    public DictionaryDimEnc() {
    }

    public DictionaryDimEnc(Dictionary<String> dict) {
        this(dict, 0, -1);
    }

    public DictionaryDimEnc(Dictionary<String> dict, int roundingFlag, byte defaultByte) {
        this.dict = dict;
        this.fixedLen = dict.getSizeOfId();
        this.roundingFlag = roundingFlag;
        this.defaultByte = defaultByte;
    }

    public int getRoundingFlag() {
        return this.roundingFlag;
    }

    public DictionaryDimEnc copy(int roundingFlag) {
        if (this.roundingFlag == roundingFlag) {
            return this;
        }
        return new DictionaryDimEnc(this.dict, roundingFlag, this.defaultByte);
    }

    public DictionaryDimEnc copy(int roundingFlag, byte defaultByte) {
        if (this.roundingFlag == roundingFlag && this.defaultByte == defaultByte) {
            return this;
        }
        return new DictionaryDimEnc(this.dict, roundingFlag, defaultByte);
    }

    public Dictionary<String> getDictionary() {
        return this.dict;
    }

    @Override
    public int getLengthOfEncoding() {
        return this.fixedLen;
    }

    @Override
    public void encode(String valueStr, byte[] output, int outputOffset) {
        try {
            int id = this.dict.getIdFromValue(valueStr, this.roundingFlag);
            BytesUtil.writeUnsigned(id, output, outputOffset, this.fixedLen);
        }
        catch (IllegalArgumentException ex) {
            for (int i = outputOffset; i < outputOffset + this.fixedLen; ++i) {
                output[i] = this.defaultByte;
            }
            logger.error("Can't translate value " + valueStr + " to dictionary ID, roundingFlag " + this.roundingFlag + ". Using default value " + String.format("\\x%02X", this.defaultByte));
        }
    }

    @Override
    public String decode(byte[] bytes, int offset, int len) {
        int id = BytesUtil.readUnsigned(bytes, offset, len);
        try {
            String value = this.dict.getValueFromId(id);
            return value;
        }
        catch (IllegalArgumentException e) {
            logger.error("Can't get dictionary value from " + this.dict + " (id = " + id + ")");
            return "";
        }
    }

    @Override
    public DataTypeSerializer<Object> asDataTypeSerializer() {
        return new DictionarySerializer();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fixedLen);
        out.writeInt(this.roundingFlag);
        out.write(this.defaultByte);
        out.writeObject(this.dict);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fixedLen = in.readInt();
        this.roundingFlag = in.readInt();
        this.defaultByte = in.readByte();
        this.dict = (Dictionary)in.readObject();
    }

    public class DictionarySerializer
    extends DataTypeSerializer<Object> {
        @Override
        public void serialize(Object value, ByteBuffer buf) {
            int id = DictionaryDimEnc.this.dict.getIdFromValue(value == null ? null : value.toString(), DictionaryDimEnc.this.roundingFlag);
            BytesUtil.writeUnsigned(id, DictionaryDimEnc.this.dict.getSizeOfId(), buf);
        }

        @Override
        public Object deserialize(ByteBuffer in) {
            int id = BytesUtil.readUnsigned(in, DictionaryDimEnc.this.dict.getSizeOfId());
            return DictionaryDimEnc.this.dict.getValueFromId(id);
        }

        @Override
        public int peekLength(ByteBuffer in) {
            return DictionaryDimEnc.this.dict.getSizeOfId();
        }

        @Override
        public int maxLength() {
            return DictionaryDimEnc.this.dict.getSizeOfId();
        }

        @Override
        public int getStorageBytesEstimate() {
            return DictionaryDimEnc.this.dict.getSizeOfId();
        }
    }
}

