/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtTableSnapshotInfoManager {
    private static final Logger logger = LoggerFactory.getLogger(ExtTableSnapshotInfoManager.class);
    public static Serializer<ExtTableSnapshotInfo> SNAPSHOT_SERIALIZER = new JsonSerializer<ExtTableSnapshotInfo>(ExtTableSnapshotInfo.class);
    private static final ConcurrentMap<KylinConfig, ExtTableSnapshotInfoManager> SERVICE_CACHE = new ConcurrentHashMap<KylinConfig, ExtTableSnapshotInfoManager>();
    private KylinConfig config;
    private LoadingCache<String, ExtTableSnapshotInfo> snapshotCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtTableSnapshotInfoManager getInstance(KylinConfig config) {
        ExtTableSnapshotInfoManager r = (ExtTableSnapshotInfoManager)SERVICE_CACHE.get(config);
        if (r != null) return r;
        Class<ExtTableSnapshotInfoManager> clazz = ExtTableSnapshotInfoManager.class;
        synchronized (ExtTableSnapshotInfoManager.class) {
            r = (ExtTableSnapshotInfoManager)SERVICE_CACHE.get(config);
            if (r != null) return r;
            r = new ExtTableSnapshotInfoManager(config);
            SERVICE_CACHE.put(config, r);
            if (SERVICE_CACHE.size() <= 1) return r;
            logger.warn("More than one singleton exist");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        ConcurrentMap<KylinConfig, ExtTableSnapshotInfoManager> concurrentMap = SERVICE_CACHE;
        synchronized (concurrentMap) {
            SERVICE_CACHE.clear();
        }
    }

    private ExtTableSnapshotInfoManager(KylinConfig config) {
        this.config = config;
        this.snapshotCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, ExtTableSnapshotInfo>(){

            public void onRemoval(RemovalNotification<String, ExtTableSnapshotInfo> notification) {
                logger.info("Snapshot with resource path " + (String)notification.getKey() + " is removed due to " + notification.getCause());
            }
        }).maximumSize(1000L).expireAfterWrite(1L, TimeUnit.DAYS).build((CacheLoader)new CacheLoader<String, ExtTableSnapshotInfo>(){

            public ExtTableSnapshotInfo load(String key) throws Exception {
                ExtTableSnapshotInfo snapshot = ExtTableSnapshotInfoManager.this.load(key);
                return snapshot;
            }
        });
    }

    public ExtTableSnapshotInfo getLatestSnapshot(IReadableTable.TableSignature signature, String tableName) throws IOException {
        ExtTableSnapshotInfo snapshot = new ExtTableSnapshotInfo(signature, tableName);
        snapshot.updateRandomUuid();
        ExtTableSnapshotInfo dupSnapshot = this.checkDupByInfo(snapshot);
        return dupSnapshot;
    }

    public ExtTableSnapshotInfo getSnapshot(String snapshotResPath) {
        try {
            return (ExtTableSnapshotInfo)this.snapshotCache.get((Object)snapshotResPath);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public ExtTableSnapshotInfo getSnapshot(String tableName, String snapshotID) {
        return this.getSnapshot(ExtTableSnapshotInfo.getResourcePath(tableName, snapshotID));
    }

    public List<ExtTableSnapshotInfo> getSnapshots(String tableName) throws IOException {
        String tableSnapshotsPath = ExtTableSnapshotInfo.getResourceDir(tableName);
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        return store.getAllResources(tableSnapshotsPath, ExtTableSnapshotInfo.class, SNAPSHOT_SERIALIZER);
    }

    public Set<String> getAllExtSnapshotResPaths() throws IOException {
        HashSet result = Sets.newHashSet();
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        NavigableSet<String> snapshotTablePaths = store.listResources("/ext_table_snapshot");
        if (snapshotTablePaths == null) {
            return result;
        }
        for (String snapshotTablePath : snapshotTablePaths) {
            NavigableSet<String> snapshotPaths = store.listResources(snapshotTablePath);
            if (snapshotPaths == null) continue;
            result.addAll(snapshotPaths);
        }
        return result;
    }

    public void removeSnapshot(String tableName, String snapshotID) throws IOException {
        String snapshotResPath = ExtTableSnapshotInfo.getResourcePath(tableName, snapshotID);
        this.snapshotCache.invalidate((Object)snapshotResPath);
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        store.deleteResource(snapshotResPath);
    }

    public ExtTableSnapshotInfo createSnapshot(IReadableTable.TableSignature signature, String tableName, String snapshotID, String[] keyColumns, int shardNum, String storageType, String storageLocation) throws IOException {
        ExtTableSnapshotInfo snapshot = new ExtTableSnapshotInfo();
        snapshot.setUuid(snapshotID);
        snapshot.setSignature(signature);
        snapshot.setTableName(tableName);
        snapshot.setKeyColumns(keyColumns);
        snapshot.setStorageType(storageType);
        snapshot.setStorageLocationIdentifier(storageLocation);
        snapshot.setShardNum(shardNum);
        this.save(snapshot);
        return snapshot;
    }

    public void updateSnapshot(ExtTableSnapshotInfo extTableSnapshot) throws IOException {
        this.save(extTableSnapshot);
        this.snapshotCache.invalidate((Object)extTableSnapshot.getResourcePath());
    }

    private ExtTableSnapshotInfo checkDupByInfo(ExtTableSnapshotInfo snapshot) throws IOException {
        String resourceDir;
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        NavigableSet<String> existings = store.listResources(resourceDir = snapshot.getResourceDir());
        if (existings == null) {
            return null;
        }
        IReadableTable.TableSignature sig = snapshot.getSignature();
        for (String existing : existings) {
            ExtTableSnapshotInfo existingSnapshot = this.load(existing);
            if (existingSnapshot == null || !sig.equals(existingSnapshot.getSignature())) continue;
            return existingSnapshot;
        }
        return null;
    }

    private ExtTableSnapshotInfo load(String resourcePath) throws IOException {
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        ExtTableSnapshotInfo snapshot = store.getResource(resourcePath, ExtTableSnapshotInfo.class, SNAPSHOT_SERIALIZER);
        return snapshot;
    }

    public void save(ExtTableSnapshotInfo snapshot) throws IOException {
        ResourceStore store = TableMetadataManager.getInstance(this.config).getStore();
        String path = snapshot.getResourcePath();
        store.putResource(path, snapshot, SNAPSHOT_SERIALIZER);
    }
}

