/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.kv;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.AbstractRowKeyEncoder;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeyEncoder
extends AbstractRowKeyEncoder
implements Serializable {
    private int bodyLength = 0;
    private RowKeyColumnIO colIO;
    protected boolean enableSharding;
    private int uhcOffset = -1;
    private int uhcLength = -1;
    private int headerLength;

    public RowKeyEncoder(CubeSegment cubeSeg, Cuboid cuboid) {
        super(cubeSeg, cuboid);
        this.enableSharding = cubeSeg.isEnableSharding();
        this.headerLength = cubeSeg.getRowKeyPreambleSize();
        Set<TblColRef> shardByColumns = cubeSeg.getCubeDesc().getShardByColumns();
        if (shardByColumns.size() > 1) {
            throw new IllegalStateException("Does not support multiple UHC now");
        }
        this.colIO = new RowKeyColumnIO(cubeSeg.getDimensionEncodingMap());
        for (TblColRef column : cuboid.getColumns()) {
            if (shardByColumns.contains(column)) {
                this.uhcOffset = this.bodyLength;
                this.uhcLength = this.colIO.getColumnLength(column);
            }
            this.bodyLength += this.colIO.getColumnLength(column);
        }
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    public int getBytesLength() {
        return this.getHeaderLength() + this.bodyLength;
    }

    protected short calculateShard(byte[] key) {
        if (this.enableSharding) {
            int shardSeedOffset = this.uhcOffset == -1 ? 0 : this.uhcOffset;
            int shardSeedLength = this.uhcLength == -1 ? this.bodyLength : this.uhcLength;
            short cuboidShardNum = this.cubeSeg.getCuboidShardNum(this.cuboid.getId());
            short shardOffset = ShardingHash.getShard(key, 10 + shardSeedOffset, shardSeedLength, cuboidShardNum);
            return ShardingHash.normalize(this.cubeSeg.getCuboidBaseShard(this.cuboid.getId()), shardOffset, this.cubeSeg.getTotalShards(this.cuboid.getId()));
        }
        throw new RuntimeException("If enableSharding false, you should never calculate shard");
    }

    public int getColumnLength(TblColRef col) {
        return this.colIO.getColumnLength(col);
    }

    @Override
    public byte[] createBuf() {
        return new byte[this.getBytesLength()];
    }

    @Override
    public void encode(GTRecord record, ImmutableBitSet keyColumns, byte[] buf) {
        ByteArray byteArray = new ByteArray(buf, this.getHeaderLength(), 0);
        this.encodeDims(record, keyColumns, byteArray, this.defaultValue());
        this.fillHeader(buf);
    }

    private void encodeDims(GTRecord record, ImmutableBitSet selectedCols, ByteArray buf, byte defaultValue) {
        int pos = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            ByteArray columnC = record.get(c);
            if (columnC.array() != null) {
                System.arraycopy(record.get(c).array(), columnC.offset(), buf.array(), buf.offset() + pos, columnC.length());
                pos += columnC.length();
                continue;
            }
            int maxLength = record.getInfo().getCodeSystem().maxCodeLength(c);
            Arrays.fill(buf.array(), buf.offset() + pos, buf.offset() + pos + maxLength, defaultValue);
            pos += maxLength;
        }
        buf.setLength(pos);
    }

    @Override
    public void encode(ByteArray bodyBytes, ByteArray outputBuf) {
        Preconditions.checkState((bodyBytes.length() == this.bodyLength ? 1 : 0) != 0);
        Preconditions.checkState((bodyBytes.length() + this.getHeaderLength() == outputBuf.length() ? 1 : 0) != 0, (Object)("bodybytes length: " + bodyBytes.length() + " outputBuf length: " + outputBuf.length() + " header length: " + this.getHeaderLength()));
        System.arraycopy(bodyBytes.array(), bodyBytes.offset(), outputBuf.array(), this.getHeaderLength(), this.bodyLength);
        this.fillHeader(outputBuf.array());
    }

    @Override
    public byte[] encode(Map<TblColRef, String> valueMap) {
        List<TblColRef> columns = this.cuboid.getColumns();
        String[] values = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            values[i] = valueMap.get(columns.get(i));
        }
        return this.encode(values);
    }

    @Override
    public byte[] encode(String[] values) {
        byte[] bytes = new byte[this.getBytesLength()];
        int offset = this.getHeaderLength();
        for (int i = 0; i < this.cuboid.getColumns().size(); ++i) {
            TblColRef column = this.cuboid.getColumns().get(i);
            int colLength = this.colIO.getColumnLength(column);
            this.fillColumnValue(column, colLength, values[i], bytes, offset);
            offset += colLength;
        }
        this.fillHeader(bytes);
        return bytes;
    }

    public void fillHeader(byte[] bytes) {
        int offset = 0;
        if (this.enableSharding) {
            short shard = this.calculateShard(bytes);
            BytesUtil.writeShort(shard, bytes, offset, 2);
            offset += 2;
        }
        System.arraycopy(this.cuboid.getBytes(), 0, bytes, offset, 8);
    }

    protected void fillColumnValue(TblColRef column, int columnLen, String valueStr, byte[] outputValue, int outputValueOffset) {
        if (valueStr == null) {
            Arrays.fill(outputValue, outputValueOffset, outputValueOffset + columnLen, this.defaultValue());
            return;
        }
        this.colIO.writeColumn(column, valueStr, 0, this.blankByte, outputValue, outputValueOffset);
    }

    protected byte defaultValue() {
        return this.blankByte;
    }
}

