/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.generic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.commons.math3.genetics.CrossoverPolicy;
import org.apache.commons.math3.genetics.ElitisticListPopulation;
import org.apache.commons.math3.genetics.FixedGenerationCount;
import org.apache.commons.math3.genetics.MutationPolicy;
import org.apache.commons.math3.genetics.Population;
import org.apache.commons.math3.genetics.SelectionPolicy;
import org.apache.commons.math3.genetics.StoppingCondition;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosome;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsChromosomeHelper;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsMutation;
import org.apache.kylin.cube.cuboid.algorithm.generic.BitsOnePointCrossover;
import org.apache.kylin.cube.cuboid.algorithm.generic.CombinedStoppingCondition;
import org.apache.kylin.cube.cuboid.algorithm.generic.RouletteWheelSelection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneticAlgorithm
extends AbstractRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    private final org.apache.commons.math3.genetics.GeneticAlgorithm geneticAlgorithm = new org.apache.commons.math3.genetics.GeneticAlgorithm((CrossoverPolicy)new BitsOnePointCrossover(), 0.9, (MutationPolicy)new BitsMutation(), 0.001, (SelectionPolicy)new RouletteWheelSelection());
    private final double crossoverRate = 0.9;
    private final double mutationRate = 0.001;
    private final int populationSize = 500;
    private final int maxPopulationSize = 510;

    public GeneticAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        super(timeout, benefitPolicy, cuboidStats);
    }

    @Override
    public List<Long> start(double maxSpaceLimit) {
        logger.debug("Genetic Algorithm started.");
        double remainingSpace = maxSpaceLimit;
        for (Long mandatoryOne : this.cuboidStats.getAllCuboidsForMandatory()) {
            if (this.cuboidStats.getCuboidSize(mandatoryOne) == null) continue;
            remainingSpace -= this.cuboidStats.getCuboidSize(mandatoryOne).doubleValue();
        }
        BitsChromosomeHelper helper = new BitsChromosomeHelper(remainingSpace, this.cuboidStats);
        Population initial = this.initRandomPopulation(helper);
        ArrayList conditions = Lists.newArrayList();
        conditions.add(new FixedGenerationCount(550));
        CombinedStoppingCondition stopCondition = new CombinedStoppingCondition(conditions);
        Population current = this.geneticAlgorithm.evolve(initial, (StoppingCondition)stopCondition);
        BitsChromosome chromosome = (BitsChromosome)current.getFittestChromosome();
        logger.debug("Genetic Algorithm finished.");
        ArrayList finalList = Lists.newArrayList();
        finalList.addAll(helper.getMandatoryCuboids());
        finalList.addAll(chromosome.getCuboids());
        double totalSpace = 0.0;
        if (logger.isTraceEnabled()) {
            for (Long cuboid : finalList) {
                Double unitSpace = this.cuboidStats.getCuboidSize(cuboid);
                if (unitSpace != null) {
                    logger.trace(String.format("cuboidId %d and Space: %f", cuboid, unitSpace));
                    totalSpace += unitSpace.doubleValue();
                    continue;
                }
                logger.trace(String.format("mandatory cuboidId %d", cuboid));
            }
            logger.trace("Total Space:" + totalSpace);
            logger.trace("Space Expansion Rate:" + totalSpace / this.cuboidStats.getBaseCuboidSize());
        }
        return finalList;
    }

    protected Population initRandomPopulation(BitsChromosomeHelper helper) {
        ArrayList chromosomeList = Lists.newArrayListWithCapacity((int)500);
        while (chromosomeList.size() < 500) {
            BitSet bitSetForSelection = new BitSet(helper.getLength());
            double totalSpace = 0.0;
            while (totalSpace < helper.spaceLimit) {
                int j = org.apache.commons.math3.genetics.GeneticAlgorithm.getRandomGenerator().nextInt(helper.getLength());
                if (bitSetForSelection.get(j)) continue;
                totalSpace += helper.getCuboidSizeByBitIndex(j);
                bitSetForSelection.set(j);
            }
            BitsChromosome chromosome = new BitsChromosome(bitSetForSelection, this.benefitPolicy.getInstance(), helper);
            chromosomeList.add(chromosome);
        }
        return new ElitisticListPopulation((List)chromosomeList, 510, 0.8);
    }
}

