/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CuboidStatsUtil {
    public static Set<Long> generateMandatoryCuboidSet(Map<Long, Long> statistics, Map<Long, Long> hitFrequencyMap, Map<Long, Map<Long, Long>> rollingUpCountSourceMap, long rollUpThresholdForMandatory) {
        HashSet mandatoryCuboidSet = Sets.newHashSet();
        if (hitFrequencyMap == null || hitFrequencyMap.isEmpty() || rollingUpCountSourceMap == null || rollingUpCountSourceMap.isEmpty()) {
            return mandatoryCuboidSet;
        }
        long totalHitFrequency = 0L;
        Iterator<Object> iterator = hitFrequencyMap.values().iterator();
        while (iterator.hasNext()) {
            long hitFrequency = iterator.next();
            totalHitFrequency += hitFrequency;
        }
        if (totalHitFrequency == 0L) {
            return mandatoryCuboidSet;
        }
        for (Map.Entry entry : hitFrequencyMap.entrySet()) {
            long cuboid = (Long)entry.getKey();
            if (statistics.get(cuboid) != null || rollingUpCountSourceMap.get(cuboid) == null || rollingUpCountSourceMap.get(cuboid).isEmpty()) continue;
            long totalEstScanCount = 0L;
            for (long estScanCount : rollingUpCountSourceMap.get(cuboid).values()) {
                totalEstScanCount += estScanCount;
            }
            totalEstScanCount /= (long)rollingUpCountSourceMap.get(cuboid).size();
            if (!((double)((Long)entry.getValue()).longValue() * 1.0 / (double)totalHitFrequency * (double)totalEstScanCount >= (double)rollUpThresholdForMandatory)) continue;
            mandatoryCuboidSet.add(cuboid);
        }
        return mandatoryCuboidSet;
    }

    public static void complementRowCountForMandatoryCuboids(Map<Long, Long> statistics, long baseCuboid, Set<Long> mandatoryCuboidSet) {
        TreeSet<Map.Entry<Long, Long>> sortedStatsSet = new TreeSet<Map.Entry<Long, Long>>(new Comparator<Map.Entry<Long, Long>>(){

            @Override
            public int compare(Map.Entry<Long, Long> o1, Map.Entry<Long, Long> o2) {
                return o1.getValue().compareTo(o2.getValue());
            }
        });
        sortedStatsSet.addAll(statistics.entrySet());
        for (Long cuboid : mandatoryCuboidSet) {
            if (statistics.get(cuboid) != null) continue;
            long tmpRowCount = -1L;
            for (Map.Entry entry : sortedStatsSet) {
                if (!CuboidStatsUtil.isDescendant(cuboid, (Long)entry.getKey())) continue;
                tmpRowCount = (Long)entry.getValue();
            }
            statistics.put(cuboid, tmpRowCount < 0L ? statistics.get(baseCuboid) : tmpRowCount);
        }
    }

    public static Map<Long, List<Long>> createDirectChildrenCache(Set<Long> cuboidSet) {
        final ArrayList cuboidList = Lists.newArrayList(cuboidSet);
        Collections.sort(cuboidList);
        ArrayList layerIdxList = Lists.newArrayListWithExpectedSize((int)cuboidList.size());
        for (int i = 0; i < cuboidList.size(); ++i) {
            layerIdxList.add(i);
        }
        Collections.sort(layerIdxList, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                Long o1 = (Long)cuboidList.get(i1);
                Long o2 = (Long)cuboidList.get(i2);
                int nBitDiff = Long.bitCount(o1) - Long.bitCount(o2);
                if (nBitDiff != 0) {
                    return nBitDiff;
                }
                return Long.compare(o1, o2);
            }
        });
        int[] toLayerIdxArray = new int[layerIdxList.size()];
        ArrayList layerCuboidList = Lists.newArrayListWithExpectedSize((int)cuboidList.size());
        int i = 0;
        while (i < layerIdxList.size()) {
            int cuboidIdx = (Integer)layerIdxList.get(i);
            toLayerIdxArray[cuboidIdx] = i++;
            layerCuboidList.add(cuboidList.get(cuboidIdx));
        }
        int[] previousLayerLastIdxArray = new int[layerIdxList.size()];
        int currentBitCount = 0;
        int previousLayerLastIdx = -1;
        for (int i2 = 0; i2 < layerIdxList.size(); ++i2) {
            int cuboidIdx = (Integer)layerIdxList.get(i2);
            int nBits = Long.bitCount((Long)cuboidList.get(cuboidIdx));
            if (nBits > currentBitCount) {
                currentBitCount = nBits;
                previousLayerLastIdx = i2 - 1;
            }
            previousLayerLastIdxArray[i2] = previousLayerLastIdx;
        }
        HashMap directChildrenCache = Maps.newHashMap();
        for (int i3 = 0; i3 < cuboidList.size(); ++i3) {
            int j;
            Long currentCuboid = (Long)cuboidList.get(i3);
            LinkedList directChildren = Lists.newLinkedList();
            int lastLayerIdx = previousLayerLastIdxArray[toLayerIdxArray[i3]];
            if (i3 - 1 <= lastLayerIdx) {
                for (j = i3 - 1; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (Long)cuboidList.get(j));
                }
            } else {
                for (j = lastLayerIdx; j >= 0; --j) {
                    CuboidStatsUtil.checkAndAddDirectChild(directChildren, currentCuboid, (Long)layerCuboidList.get(j));
                }
            }
            directChildrenCache.put(currentCuboid, directChildren);
        }
        return directChildrenCache;
    }

    private static void checkAndAddDirectChild(List<Long> directChildren, Long currentCuboid, Long checkedCuboid) {
        if (CuboidStatsUtil.isDescendant(checkedCuboid, currentCuboid)) {
            boolean ifDirectChild = true;
            for (long directChild : directChildren) {
                if (!CuboidStatsUtil.isDescendant(checkedCuboid, directChild)) continue;
                ifDirectChild = false;
                break;
            }
            if (ifDirectChild) {
                directChildren.add(checkedCuboid);
            }
        }
    }

    public static boolean isDescendant(long cuboidToCheck, long parentCuboid) {
        return (cuboidToCheck & parentCuboid) == cuboidToCheck;
    }
}

