/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BPUSCalculator
implements BenefitPolicy {
    private static Logger logger = LoggerFactory.getLogger(BPUSCalculator.class);
    protected final CuboidStats cuboidStats;
    protected final ImmutableMap<Long, Long> initCuboidAggCostMap;
    protected final Map<Long, Long> processCuboidAggCostMap;

    public BPUSCalculator(CuboidStats cuboidStats) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = ImmutableMap.copyOf(this.initCuboidAggCostMap());
        this.processCuboidAggCostMap = Maps.newHashMap(this.initCuboidAggCostMap);
    }

    protected BPUSCalculator(CuboidStats cuboidStats, ImmutableMap<Long, Long> initCuboidAggCostMap) {
        this.cuboidStats = cuboidStats;
        this.initCuboidAggCostMap = initCuboidAggCostMap;
        this.processCuboidAggCostMap = Maps.newHashMap(initCuboidAggCostMap);
    }

    private Map<Long, Long> initCuboidAggCostMap() {
        HashMap cuboidAggCostMap = Maps.newHashMap();
        for (Long cuboid : this.cuboidStats.getAllCuboidsForMandatory()) {
            if (this.getCuboidCost(cuboid) == null) continue;
            cuboidAggCostMap.put(cuboid, this.getCuboidCost(cuboid));
        }
        Set mandatoryCuboidSetWithStats = cuboidAggCostMap.keySet();
        long baseCuboidCost = this.getCuboidCost(this.cuboidStats.getBaseCuboid());
        for (Long cuboid : this.cuboidStats.getAllCuboidsForSelection()) {
            long leastCost = baseCuboidCost;
            for (Long cuboidTarget : mandatoryCuboidSetWithStats) {
                if ((cuboid | cuboidTarget) != cuboidTarget || leastCost <= (Long)cuboidAggCostMap.get(cuboidTarget)) continue;
                leastCost = (Long)cuboidAggCostMap.get(cuboidTarget);
            }
            cuboidAggCostMap.put(cuboid, leastCost);
        }
        return cuboidAggCostMap;
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefit(long cuboid, Set<Long> selected) {
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Long descendant : this.cuboidStats.getAllDescendants(cuboid)) {
            double costSaving;
            if (selected.contains(descendant) || !((costSaving = this.getCostSaving(descendant, cuboid)) > 0.0)) continue;
            totalCostSaving += costSaving;
            ++benefitCount;
        }
        double spaceCost = this.calculateSpaceCost(cuboid);
        double benefitPerUnitSpace = totalCostSaving / spaceCost;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    @Override
    public CuboidBenefitModel.BenefitModel calculateBenefitTotal(Set<Long> cuboidsToAdd, Set<Long> selected) {
        HashSet selectedInner = Sets.newHashSet(selected);
        HashMap cuboidAggCostMapCopy = Maps.newHashMap(this.processCuboidAggCostMap);
        for (Long cuboid : cuboidsToAdd) {
            selectedInner.add(cuboid);
            this.propagateAggregationCost(cuboid, selectedInner, cuboidAggCostMapCopy);
        }
        double totalCostSaving = 0.0;
        int benefitCount = 0;
        for (Long cuboid : cuboidAggCostMapCopy.keySet()) {
            if ((Long)cuboidAggCostMapCopy.get(cuboid) >= this.processCuboidAggCostMap.get(cuboid)) continue;
            totalCostSaving += (double)(this.processCuboidAggCostMap.get(cuboid) - (Long)cuboidAggCostMapCopy.get(cuboid));
            ++benefitCount;
        }
        double benefitPerUnitSpace = totalCostSaving;
        return new CuboidBenefitModel.BenefitModel(benefitPerUnitSpace, benefitCount);
    }

    protected double getCostSaving(long descendant, long cuboid) {
        long cuboidCost = this.getCuboidCost(cuboid);
        long descendantAggCost = this.getCuboidAggregationCost(descendant);
        return descendantAggCost - cuboidCost;
    }

    protected Long getCuboidCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid);
    }

    private long getCuboidAggregationCost(long cuboid) {
        return this.processCuboidAggCostMap.get(cuboid);
    }

    @Override
    public boolean ifEfficient(CuboidBenefitModel best) {
        if (best.getBenefit() < this.getMinBenefitRatio()) {
            logger.info(String.format("The recommended cuboid %s doesn't meet minimum benifit ratio %f", best, this.getMinBenefitRatio()));
            return false;
        }
        return true;
    }

    public double getMinBenefitRatio() {
        return 0.01;
    }

    @Override
    public void propagateAggregationCost(long cuboid, Set<Long> selected) {
        this.propagateAggregationCost(cuboid, selected, this.processCuboidAggCostMap);
    }

    public void propagateAggregationCost(long cuboid, Set<Long> selected, Map<Long, Long> processCuboidAggCostMap) {
        long aggregationCost = this.getCuboidCost(cuboid);
        Set<Long> childrenCuboids = this.cuboidStats.getAllDescendants(cuboid);
        for (Long child : childrenCuboids) {
            if (selected.contains(child) || aggregationCost >= this.getCuboidAggregationCost(child)) continue;
            processCuboidAggCostMap.put(child, aggregationCost);
        }
    }

    public double calculateSpaceCost(long cuboid) {
        return this.cuboidStats.getCuboidCount(cuboid).longValue();
    }

    @Override
    public BenefitPolicy getInstance() {
        return new BPUSCalculator(this.cuboidStats, this.initCuboidAggCostMap);
    }
}

