/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.DimensionRangeInfo;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeOrder;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPruner {
    private static final Logger logger = LoggerFactory.getLogger(SegmentPruner.class);
    private final Set<CompareTupleFilter> mustTrueCompares;

    public SegmentPruner(TupleFilter filter) {
        this.mustTrueCompares = filter == null ? Collections.emptySet() : filter.findMustTrueCompareFilters();
    }

    public List<CubeSegment> listSegmentsForQuery(CubeInstance cube) {
        ArrayList<CubeSegment> r = new ArrayList<CubeSegment>();
        for (CubeSegment seg : cube.getSegments(SegmentStatusEnum.READY)) {
            if (!this.check(seg)) continue;
            r.add(seg);
        }
        return r;
    }

    public boolean check(CubeSegment seg) {
        if (seg.getInputRecords() == 0L) {
            if (seg.getConfig().isSkippingEmptySegments()) {
                logger.debug("Prune segment {} due to 0 input record", (Object)seg);
                return false;
            }
            logger.debug("Insist scan of segment {} having 0 input record", (Object)seg);
        }
        Map<String, DimensionRangeInfo> segDimRangInfoMap = seg.getDimensionRangeInfoMap();
        for (CompareTupleFilter comp : this.mustTrueCompares) {
            String maxVal;
            String minVal;
            TblColRef col = comp.getColumn();
            DimensionRangeInfo dimRangeInfo = segDimRangInfoMap.get(col.getIdentity());
            if (dimRangeInfo == null) {
                dimRangeInfo = this.tryDeduceRangeFromPartitionCol(seg, col);
            }
            if (dimRangeInfo == null || this.satisfy(comp, minVal = dimRangeInfo.getMin(), maxVal = dimRangeInfo.getMax())) continue;
            logger.debug("Prune segment {} due to given filter", (Object)seg);
            return false;
        }
        logger.debug("Pruner passed on segment {}", (Object)seg);
        return true;
    }

    private DimensionRangeInfo tryDeduceRangeFromPartitionCol(CubeSegment seg, TblColRef col) {
        DataModelDesc model = seg.getModel();
        PartitionDesc part = model.getPartitionDesc();
        if (!part.isPartitioned()) {
            return null;
        }
        if (!col.equals(part.getPartitionDateColumnRef())) {
            return null;
        }
        SegmentRange.TSRange tsRange = seg.getTSRange();
        if (tsRange.start.isMin || tsRange.end.isMax) {
            return null;
        }
        String min = this.tsRangeToStr((Long)tsRange.start.v, part);
        String max = this.tsRangeToStr((Long)tsRange.end.v - 1L, part);
        return new DimensionRangeInfo(min, max);
    }

    private String tsRangeToStr(long ts, PartitionDesc part) {
        String value;
        DataType partitionColType = part.getPartitionDateColumnRef().getType();
        if (partitionColType.isDate()) {
            value = DateFormat.formatToDateStr(ts);
        } else if (partitionColType.isTimeFamily()) {
            value = DateFormat.formatToTimeWithoutMilliStr(ts);
        } else if (partitionColType.isStringFamily() || partitionColType.isIntegerFamily()) {
            String partitionDateFormat = part.getPartitionDateFormat();
            value = StringUtils.isEmpty((String)partitionDateFormat) ? "" + ts : DateFormat.formatToDateStr(ts, partitionDateFormat);
        } else {
            throw new RuntimeException("Type " + partitionColType + " is not valid partition column type");
        }
        return value;
    }

    private boolean satisfy(CompareTupleFilter comp, String minVal, String maxVal) {
        if (minVal == null && maxVal == null) {
            return true;
        }
        if (comp.getChildren().size() > 1 && !(comp.getChildren().get(1) instanceof ConstantTupleFilter)) {
            return true;
        }
        TblColRef col = comp.getColumn();
        DataTypeOrder order = col.getType().getOrder();
        String filterVal = this.toString(comp.getFirstValue());
        switch (comp.getOperator()) {
            case EQ: 
            case IN: {
                String filterMin = order.min(comp.getValues());
                String filterMax = order.max(comp.getValues());
                return order.compare(filterMin, maxVal) <= 0 && order.compare(minVal, filterMax) <= 0;
            }
            case LT: {
                return order.compare(minVal, filterVal) < 0;
            }
            case LTE: {
                return order.compare(minVal, filterVal) <= 0;
            }
            case GT: {
                return order.compare(maxVal, filterVal) > 0;
            }
            case GTE: {
                return order.compare(maxVal, filterVal) >= 0;
            }
        }
        return true;
    }

    private String toString(Object v) {
        return v == null ? null : v.toString();
    }
}

