/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cli;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.model.DimensionDesc;
import org.apache.kylin.dict.DictionaryProvider;
import org.apache.kylin.dict.DistinctColumnValuesProvider;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.source.IReadableTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryGeneratorCLI {
    private static final Logger logger = LoggerFactory.getLogger(DictionaryGeneratorCLI.class);

    public static void processSegment(KylinConfig config, String cubeName, String segmentID, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        CubeInstance cube = CubeManager.getInstance(config).getCube(cubeName);
        CubeSegment segment = cube.getSegmentById(segmentID);
        DictionaryGeneratorCLI.processSegment(config, segment, factTableValueProvider, dictProvider);
    }

    private static void processSegment(KylinConfig config, CubeSegment cubeSeg, DistinctColumnValuesProvider factTableValueProvider, DictionaryProvider dictProvider) throws IOException {
        CubeManager cubeMgr = CubeManager.getInstance(config);
        for (TblColRef col : cubeSeg.getCubeDesc().getAllColumnsNeedDictionaryBuilt()) {
            logger.info("Building dictionary for " + col);
            IReadableTable inpTable = factTableValueProvider.getDistinctValuesFor(col);
            Dictionary<String> preBuiltDict = null;
            if (dictProvider != null) {
                preBuiltDict = dictProvider.getDictionary(col);
            }
            if (preBuiltDict != null) {
                logger.debug("Dict for '" + col.getName() + "' has already been built, save it");
                cubeMgr.saveDictionary(cubeSeg, col, inpTable, preBuiltDict);
                continue;
            }
            logger.debug("Dict for '" + col.getName() + "' not pre-built, build it from " + inpTable.toString());
            cubeMgr.buildDictionary(cubeSeg, col, inpTable);
        }
        HashSet toSnapshot = Sets.newHashSet();
        HashSet toCheckLookup = Sets.newHashSet();
        for (DimensionDesc dim : cubeSeg.getCubeDesc().getDimensions()) {
            TableRef table = dim.getTableRef();
            if (!cubeSeg.getModel().isLookupTable(table) || cubeSeg.getCubeDesc().isExtSnapshotTable(table.getTableIdentity())) continue;
            toSnapshot.add(table.getTableIdentity());
            toCheckLookup.add(table);
        }
        for (String tableIdentity : toSnapshot) {
            logger.info("Building snapshot of " + tableIdentity);
            cubeMgr.buildSnapshotTable(cubeSeg, tableIdentity);
        }
        CubeInstance updatedCube = cubeMgr.getCube(cubeSeg.getCubeInstance().getName());
        cubeSeg = updatedCube.getSegmentById(cubeSeg.getUuid());
        for (TableRef lookup : toCheckLookup) {
            logger.info("Checking snapshot of " + lookup);
            try {
                JoinDesc join = cubeSeg.getModel().getJoinsTree().getJoinByPKSide(lookup);
                cubeMgr.getLookupTable(cubeSeg, join);
            }
            catch (Throwable th) {
                throw new RuntimeException("Checking snapshot of " + lookup + " failed.", th);
            }
        }
    }
}

