/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.examples.Archiver;
import org.apache.commons.compress.archivers.examples.Expander;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipFileUtils {
    private static final Logger logger = LoggerFactory.getLogger(ZipFileUtils.class);

    public static void compressZipFile(String sourceDir, String zipFileName) throws IOException, ArchiveException {
        if (!ZipFileUtils.validateZipFilename(zipFileName)) {
            throw new RuntimeException("Zip file must end with .zip");
        }
        Archiver archiver = new Archiver();
        archiver.create("zip", new File(zipFileName), new File(sourceDir));
    }

    public static void decompressZipfileToDirectory(String zipFileName, File outputFolder) throws IOException, ArchiveException {
        if (!ZipFileUtils.validateZipFilename(zipFileName)) {
            throw new RuntimeException("Zip file must end with .zip");
        }
        Expander expander = new Expander();
        ZipFile zipFile = new ZipFile(zipFileName);
        expander.expand(zipFile, outputFolder);
    }

    private static boolean validateZipFilename(String filename) {
        return !StringUtils.isEmpty((String)filename) && filename.trim().toLowerCase().endsWith(".zip");
    }
}

