/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassUtil {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtil.class);
    private static final Map<String, String> classRenameMap = new HashMap<String, String>();

    public static void addClasspath(String path) {
        logger.info("Adding path " + path + " to class path");
        File file = new File(path);
        try {
            if (file.exists()) {
                URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
                Class<URLClassLoader> urlClass = URLClassLoader.class;
                Method method = urlClass.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)urlClassLoader, file.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<? extends T> forName(String name, Class<T> clz) throws ClassNotFoundException {
        name = ClassUtil.forRenamedClass(name);
        return Class.forName(name);
    }

    private static String forRenamedClass(String name) {
        String rename;
        if (name.startsWith("com.kylinolap")) {
            name = "org.apache.kylin" + name.substring("com.kylinolap".length());
        }
        return (rename = classRenameMap.get(name)) == null ? name : rename;
    }

    public static Object newInstance(String clz) {
        try {
            return ClassUtil.forName(clz, Object.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String findContainingJar(Class<?> clazz) {
        return ClassUtil.findContainingJar(clazz, null);
    }

    public static String findContainingJar(Class<?> clazz, String preferJarKeyWord) {
        ClassLoader loader = clazz.getClassLoader();
        String classFile = clazz.getName().replaceAll("\\.", "/") + ".class";
        try {
            String toReturn;
            Enumeration<URL> e = loader.getResources(classFile);
            URL url = null;
            do {
                if (e.hasMoreElements()) continue;
                if (url != null) break;
                return null;
            } while ("jar".equals((url = e.nextElement()).getProtocol()) && (preferJarKeyWord == null || url.getPath().indexOf(preferJarKeyWord) == -1) && preferJarKeyWord != null);
            if ((toReturn = url.getPath()).startsWith("file:")) {
                toReturn = toReturn.substring("file:".length());
            }
            toReturn = URLDecoder.decode(toReturn, "UTF-8");
            return toReturn.replaceAll("!.*$", "");
        }
        catch (IOException var6) {
            throw new RuntimeException(var6);
        }
    }

    public static String findContainingJar(String className, String perferLibraryName) {
        try {
            return ClassUtil.findContainingJar(Class.forName(className), perferLibraryName);
        }
        catch (ClassNotFoundException e) {
            logger.warn("failed to locate jar for class " + className + ", ignore it");
            return "";
        }
    }

    static {
        classRenameMap.put("org.apache.kylin.job.common.HadoopShellExecutable", "org.apache.kylin.engine.mr.common.HadoopShellExecutable");
        classRenameMap.put("org.apache.kylin.job.common.MapReduceExecutable", "org.apache.kylin.engine.mr.common.MapReduceExecutable");
        classRenameMap.put("org.apache.kylin.job.cube.CubingJob", "org.apache.kylin.engine.mr.CubingJob");
        classRenameMap.put("org.apache.kylin.job.cube.GarbageCollectionStep", "org.apache.kylin.storage.hbase.steps.DeprecatedGCStep");
        classRenameMap.put("org.apache.kylin.job.cube.MergeDictionaryStep", "org.apache.kylin.engine.mr.steps.MergeDictionaryStep");
        classRenameMap.put("org.apache.kylin.job.cube.UpdateCubeInfoAfterBuildStep", "org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterBuildStep");
        classRenameMap.put("org.apache.kylin.job.cube.UpdateCubeInfoAfterMergeStep", "org.apache.kylin.engine.mr.steps.UpdateCubeInfoAfterMergeStep");
        classRenameMap.put("org.apache.kylin.rest.util.KeywordDefaultDirtyHack", "org.apache.kylin.query.util.KeywordDefaultDirtyHack");
    }
}

