/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JDBCResource;
import org.apache.kylin.common.persistence.JDBCResourceDAO;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.WriteConflictException;

public class JDBCResourceStore
extends ResourceStore {
    private static final String JDBC_SCHEME = "jdbc";
    private String metadataIdentifier;
    private JDBCResourceDAO resourceDAO;

    public JDBCResourceStore(KylinConfig kylinConfig) throws SQLException {
        super(kylinConfig);
        StorageURL metadataUrl = kylinConfig.getMetadataUrl();
        JDBCResourceStore.checkScheme(metadataUrl);
        this.metadataIdentifier = metadataUrl.getIdentifier();
        this.resourceDAO = new JDBCResourceDAO(kylinConfig, metadataUrl.getIdentifier());
    }

    @Override
    protected boolean existsImpl(String resPath) throws IOException {
        try {
            return this.resourceDAO.existResource(resPath);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected RawResource getResourceImpl(String resPath) throws IOException {
        return this.getResourceImpl(resPath, false);
    }

    protected RawResource getResourceImpl(String resPath, boolean isAllowBroken) throws IOException {
        try {
            JDBCResource resource = this.resourceDAO.getResource(resPath, true, true, isAllowBroken);
            if (resource != null) {
                return new RawResource(resource.getContent(), resource.getTimestamp());
            }
            return null;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected long getResourceTimestampImpl(String resPath) throws IOException {
        try {
            JDBCResource resource = this.resourceDAO.getResource(resPath, false, true);
            if (resource != null) {
                return resource.getTimestamp();
            }
            return 0L;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected NavigableSet<String> listResourcesImpl(String folderPath, boolean recursive) throws IOException {
        try {
            TreeSet<String> result = this.resourceDAO.listAllResource(this.makeFolderPath(folderPath), recursive);
            return result.isEmpty() ? null : result;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected List<RawResource> getAllResourcesImpl(String folderPath, long timeStart, long timeEndExclusive) throws IOException {
        return this.getAllResourcesImpl(folderPath, timeStart, timeEndExclusive, false);
    }

    @Override
    protected List<RawResource> getAllResourcesImpl(String folderPath, long timeStart, long timeEndExclusive, boolean isAllowBroken) throws IOException {
        ArrayList result = Lists.newArrayList();
        try {
            List<JDBCResource> allResource = this.resourceDAO.getAllResource(this.makeFolderPath(folderPath), timeStart, timeEndExclusive, isAllowBroken);
            for (JDBCResource resource : allResource) {
                result.add(new RawResource(resource.getContent(), resource.getTimestamp()));
            }
            return result;
        }
        catch (SQLException e) {
            for (RawResource rawResource : result) {
                IOUtils.closeQuietly((InputStream)rawResource.inputStream);
            }
            throw new IOException(e);
        }
    }

    @Override
    protected void putResourceImpl(String resPath, InputStream content, long ts) throws IOException {
        try {
            JDBCResource resource = new JDBCResource(resPath, ts, content);
            this.resourceDAO.putResource(resource);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected long checkAndPutResourceImpl(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        try {
            this.resourceDAO.checkAndPutResource(resPath, content, oldTS, newTS);
            return newTS;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void deleteResourceImpl(String resPath) throws IOException {
        try {
            this.resourceDAO.deleteResource(resPath);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected String getReadableResourcePathImpl(String resPath) {
        return this.metadataIdentifier + "(key='" + resPath + "')@" + this.kylinConfig.getMetadataUrl();
    }

    private String makeFolderPath(String folderPath) {
        Preconditions.checkState((boolean)folderPath.startsWith("/"));
        String lookForPrefix = folderPath.endsWith("/") ? folderPath : folderPath + "/";
        return lookForPrefix;
    }

    protected JDBCResourceDAO getResourceDAO() {
        return this.resourceDAO;
    }

    public long getQueriedSqlNum() {
        return this.resourceDAO.getQueriedSqlNum();
    }

    public static void checkScheme(StorageURL url) {
        Preconditions.checkState((boolean)JDBC_SCHEME.equals(url.getScheme()));
    }
}

