/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.BasicDataSourceFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.JDBCResourceStore;
import org.apache.kylin.common.util.EncryptUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(JDBCConnectionManager.class);
    private static JDBCConnectionManager INSTANCE = null;
    private static Object lock = new Object();
    private final Map<String, String> dbcpProps;
    private final DataSource dataSource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JDBCConnectionManager getConnectionManager() {
        if (INSTANCE == null) {
            Object object = lock;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new JDBCConnectionManager(KylinConfig.getInstanceFromEnv());
                }
            }
        }
        return INSTANCE;
    }

    private JDBCConnectionManager(KylinConfig config) {
        try {
            this.dbcpProps = this.initDbcpProps(config);
            this.dataSource = BasicDataSourceFactory.createDataSource((Properties)this.getDbcpProperties());
            Connection conn = this.getConn();
            DatabaseMetaData mdm = conn.getMetaData();
            logger.info("Connected to " + mdm.getDatabaseProductName() + " " + mdm.getDatabaseProductVersion());
            JDBCConnectionManager.closeQuietly(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> initDbcpProps(KylinConfig config) {
        StorageURL metadataUrl = config.getMetadataUrl();
        JDBCResourceStore.checkScheme(metadataUrl);
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(metadataUrl.getAllParameters());
        List<String> mandatoryItems = Arrays.asList("url", "username", "password");
        for (String item : mandatoryItems) {
            Preconditions.checkNotNull((Object)ret.get(item), (Object)("Setting item \"" + item + "\" is mandatory for Jdbc connections."));
        }
        if ("true".equals(ret.get("passwordEncrypted"))) {
            String password = ret.get("password");
            ret.put("password", EncryptUtil.decrypt(password));
            ret.remove("passwordEncrypted");
        }
        logger.info("Connecting to Jdbc with url:" + ret.get("url") + " by user " + ret.get("username"));
        this.putIfMissing(ret, "driverClassName", "com.mysql.jdbc.Driver");
        this.putIfMissing(ret, "maxActive", "5");
        this.putIfMissing(ret, "maxIdle", "5");
        this.putIfMissing(ret, "maxWait", "1000");
        this.putIfMissing(ret, "removeAbandoned", "true");
        this.putIfMissing(ret, "removeAbandonedTimeout", "180");
        this.putIfMissing(ret, "testOnBorrow", "true");
        this.putIfMissing(ret, "testWhileIdle", "true");
        this.putIfMissing(ret, "validationQuery", "select 1");
        return ret;
    }

    private void putIfMissing(LinkedHashMap<String, String> map, String key, String value) {
        if (!map.containsKey(key)) {
            map.put(key, value);
        }
    }

    public final Connection getConn() throws SQLException {
        return this.dataSource.getConnection();
    }

    public Properties getDbcpProperties() {
        Properties ret = new Properties();
        ret.putAll(this.dbcpProps);
        return ret;
    }

    public static void closeQuietly(AutoCloseable obj) {
        if (obj != null) {
            try {
                obj.close();
            }
            catch (Exception e) {
                logger.warn("Error closing " + obj, (Throwable)e);
            }
        }
    }

    public void close() {
        try {
            ((BasicDataSource)this.dataSource).close();
        }
        catch (SQLException e) {
            logger.error("error closing data source", (Throwable)e);
        }
    }
}

