/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.persistence.BrokenEntity;
import org.apache.kylin.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokenInputStream
extends InputStream {
    private static Logger logger = LoggerFactory.getLogger(BrokenInputStream.class);
    private final ByteArrayInputStream in;

    public BrokenInputStream(BrokenEntity brokenEntity) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            IOUtils.write((byte[])BrokenEntity.MAGIC, (OutputStream)out);
            IOUtils.write((byte[])JsonUtil.writeValueAsBytes(brokenEntity), (OutputStream)out);
        }
        catch (IOException e) {
            logger.error("There is something error when we serialize BrokenEntity: ", (Throwable)e);
            throw new RuntimeException("There is something error when we serialize BrokenEntity.");
        }
        this.in = new ByteArrayInputStream(out.toByteArray());
    }

    @Override
    public int read() {
        return this.in.read();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        super.close();
    }
}

