/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class HiveJDBCClientTest {
    private static String driverName = "org.apache.hive.jdbc.HiveDriver";
    private static String tempFileName = "/tmp/a.txt";

    public void setup() {
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
        }
        File testFile = new File(tempFileName);
        if (!testFile.exists()) {
            try {
                FileWriter writer = new FileWriter(testFile);
                writer.write("1 a\n");
                writer.write("2 b\n");
                writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void tearDown() {
    }

    protected Connection getHiveConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:hive2://localhost:10000/default", "hive", "");
    }

    public void testConnectToHive() throws SQLException {
        Connection con = this.getHiveConnection();
        Statement stmt = con.createStatement();
        String tableName = "testHiveDriverTable";
        stmt.execute("drop table if exists " + tableName);
        stmt.execute("create table " + tableName + " (key int, value string) row format delimited fields terminated by ' '");
        String sql = "show tables '" + tableName + "'";
        System.out.println("Running: " + sql);
        ResultSet res = stmt.executeQuery(sql);
        if (res.next()) {
            System.out.println(res.getString(1));
        }
        res.close();
        sql = "describe " + tableName;
        System.out.println("Running: " + sql);
        res = stmt.executeQuery(sql);
        while (res.next()) {
            System.out.println(res.getString(1) + "\t" + res.getString(2));
        }
        res.close();
        String filepath = tempFileName;
        sql = "load data local inpath '" + filepath + "' into table " + tableName;
        System.out.println("Running: " + sql);
        stmt.execute(sql);
        sql = "select * from " + tableName;
        System.out.println("Running: " + sql);
        res = stmt.executeQuery(sql);
        while (res.next()) {
            System.out.println(String.valueOf(res.getInt(1)) + "\t" + res.getString(2));
        }
        res.close();
        sql = "select count(1) from " + tableName;
        System.out.println("Running: " + sql);
        res = stmt.executeQuery(sql);
        while (res.next()) {
            System.out.println(res.getInt(1));
        }
        res.close();
        stmt.close();
        con.close();
    }

    public void testShowExtendedTable() throws SQLException {
        Connection con = this.getHiveConnection();
        String tableName = "testHiveDriverTable";
        String sql = "show table extended like " + tableName + "";
        ResultSet res = this.executeSQL(con, sql);
        while (res.next()) {
            System.out.println("--- " + res.getString("tab_name"));
        }
        sql = "describe extended " + tableName + "";
        res = this.executeSQL(con, sql);
        while (res.next()) {
            System.out.println("---" + res.getString(1) + " | " + res.getString(2));
        }
        res.close();
        con.close();
    }

    protected ResultSet executeSQL(Connection con, String sql) throws SQLException {
        Statement stmt = con.createStatement();
        System.out.println("Running: " + sql);
        stmt.execute(sql);
        return stmt.getResultSet();
    }

    public void runTests() throws SQLException {
        try {
            this.setup();
            this.testConnectToHive();
            this.testShowExtendedTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            this.tearDown();
        }
    }

    public static void main(String[] args) throws SQLException {
        HiveJDBCClientTest test = new HiveJDBCClientTest();
        test.runTests();
    }
}

