/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class RowKeyWritable
implements WritableComparable<RowKeyWritable> {
    private byte[] data;
    private int offset;
    private int length;
    private KeyValue.KVComparator kvComparator = new KeyValue.KVComparator();

    public RowKeyWritable() {
    }

    public RowKeyWritable(byte[] bytes) {
        this.data = bytes;
        this.offset = 0;
        this.length = bytes.length;
    }

    public void set(byte[] array) {
        this.set(array, 0, array.length);
    }

    public void set(byte[] array, int offset, int length) {
        this.data = array;
        this.offset = offset;
        this.length = length;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.length);
        out.write(this.data, this.offset, this.length);
    }

    public void readFields(DataInput in) throws IOException {
        this.length = in.readInt();
        this.data = new byte[this.length];
        in.readFully(this.data, 0, this.length);
        this.offset = 0;
    }

    public int compareTo(RowKeyWritable other) {
        return this.kvComparator.compare(this.data, this.offset, this.length, other.data, other.offset, other.length);
    }

    static {
        WritableComparator.define(RowKeyWritable.class, (WritableComparator)new RowKeyComparator());
    }

    public static class RowKeyComparator
    extends WritableComparator {
        private KeyValue.KVComparator kvComparator = new KeyValue.KVComparator();
        private static final int LENGTH_BYTES = 4;

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return this.kvComparator.compare(b1, s1 + 4, l1 - 4, b2, s2 + 4, l2 - 4);
        }
    }
}

