/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.StringUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.BulkLoadJob;
import org.apache.kylin.storage.hbase.steps.CreateHTableJob;
import org.apache.kylin.storage.hbase.steps.CubeHFileJob;
import org.apache.kylin.storage.hbase.steps.HDFSPathGarbageCollectionStep;
import org.apache.kylin.storage.hbase.steps.MergeGCStep;

public class HBaseMRSteps
extends JobBuilderSupport {
    public HBaseMRSteps(CubeSegment seg) {
        super(seg, null);
    }

    public HadoopShellExecutable createCreateHTableStep(String jobId) {
        return this.createCreateHTableStep(jobId, CuboidModeEnum.CURRENT);
    }

    public HadoopShellExecutable createCreateHTableStep(String jobId, CuboidModeEnum cuboidMode) {
        HadoopShellExecutable createHtableStep = new HadoopShellExecutable();
        createHtableStep.setName("Create HTable");
        StringBuilder cmd = new StringBuilder();
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"segmentid", (String)this.seg.getUuid());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"partitions", (String)(this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000"));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cuboidMode", (String)cuboidMode.toString());
        createHtableStep.setJobParams(cmd.toString());
        createHtableStep.setJobClass(CreateHTableJob.class);
        return createHtableStep;
    }

    public MapReduceExecutable createMergeCuboidDataStep(CubeSegment seg, List<CubeSegment> mergingSegments, String jobID, Class<? extends AbstractHadoopJob> clazz) {
        ArrayList mergingCuboidPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingCuboidPaths.add(this.getCuboidRootPath(merging) + "*");
        }
        String formattedPath = StringUtil.join(mergingCuboidPaths, ",");
        String outputPath = this.getCuboidRootPath(jobID);
        MapReduceExecutable mergeCuboidDataStep = new MapReduceExecutable();
        mergeCuboidDataStep.setName("Merge Cuboid Data");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)seg.getCubeInstance().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"segmentid", (String)seg.getUuid());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)formattedPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)outputPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_Merge_Cuboid_" + seg.getCubeInstance().getName() + "_Step"));
        mergeCuboidDataStep.setMapReduceParams(cmd.toString());
        mergeCuboidDataStep.setMapReduceJobClass(clazz);
        return mergeCuboidDataStep;
    }

    public MapReduceExecutable createConvertCuboidToHfileStep(String jobId) {
        String cuboidRootPath = this.getCuboidRootPath(jobId);
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/") + "*";
        MapReduceExecutable createHFilesStep = new MapReduceExecutable();
        createHFilesStep.setName("Convert Cuboid Data to HFile");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"partitions", (String)(this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000_hfile"));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)inputPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)this.getHFilePath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"htablename", (String)this.seg.getStorageLocationIdentifier());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_HFile_Generator_" + this.seg.getRealization().getName() + "_Step"));
        createHFilesStep.setMapReduceParams(cmd.toString());
        createHFilesStep.setMapReduceJobClass(CubeHFileJob.class);
        createHFilesStep.setCounterSaveAs(",,byteSizeBytes");
        return createHFilesStep;
    }

    public HadoopShellExecutable createBulkLoadStep(String jobId) {
        HadoopShellExecutable bulkLoadStep = new HadoopShellExecutable();
        bulkLoadStep.setName("Load HFile to HBase Table");
        StringBuilder cmd = new StringBuilder();
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)this.getHFilePath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"htablename", (String)this.seg.getStorageLocationIdentifier());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        bulkLoadStep.setJobParams(cmd.toString());
        bulkLoadStep.setJobClass(BulkLoadJob.class);
        return bulkLoadStep;
    }

    public MergeGCStep createMergeGCStep() {
        MergeGCStep result = new MergeGCStep();
        result.setName("Garbage Collection on HBase");
        result.setOldHTables(this.getMergingHTables());
        return result;
    }

    public MergeGCStep createOptimizeGCStep() {
        MergeGCStep result = new MergeGCStep();
        result.setName("Garbage Collection");
        result.setOldHTables(this.getOptimizeHTables());
        return result;
    }

    public List<CubeSegment> getOptimizeSegments() {
        CubeInstance cube = (CubeInstance)this.seg.getRealization();
        ArrayList newSegments = Lists.newArrayList(cube.getSegments(SegmentStatusEnum.READY_PENDING));
        ArrayList oldSegments = Lists.newArrayListWithExpectedSize((int)newSegments.size());
        for (CubeSegment segment : newSegments) {
            oldSegments.add(cube.getOriginalSegmentToOptimize(segment));
        }
        return oldSegments;
    }

    public List<String> getOptimizeHTables() {
        return this.getOldHTables(this.getOptimizeSegments());
    }

    public List<String> getOldHTables(List<CubeSegment> oldSegments) {
        ArrayList oldHTables = Lists.newArrayListWithExpectedSize((int)oldSegments.size());
        for (CubeSegment segment : oldSegments) {
            oldHTables.add(segment.getStorageLocationIdentifier());
        }
        return oldHTables;
    }

    public List<String> getMergingHTables() {
        Segments<CubeSegment> mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments(this.seg);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)("there should be more than 2 segments to merge, target segment " + this.seg));
        ArrayList mergingHTables = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingHTables.add(merging.getStorageLocationIdentifier());
        }
        return mergingHTables;
    }

    public List<String> getMergingHDFSPaths() {
        Segments<CubeSegment> mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments(this.seg);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)("there should be more than 2 segments to merge, target segment " + this.seg));
        ArrayList mergingHDFSPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingHDFSPaths.add(this.getJobWorkingDir(merging.getLastBuildJobID()));
        }
        return mergingHDFSPaths;
    }

    public List<String> getOptimizeHDFSPaths() {
        return this.getOldHDFSPaths(this.getOptimizeSegments());
    }

    public List<String> getOldHDFSPaths(List<CubeSegment> oldSegments) {
        ArrayList oldHDFSPaths = Lists.newArrayListWithExpectedSize((int)oldSegments.size());
        for (CubeSegment oldSegment : oldSegments) {
            oldHDFSPaths.add(this.getJobWorkingDir(oldSegment.getLastBuildJobID()));
        }
        return oldHDFSPaths;
    }

    public String getHFilePath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/hfile/");
    }

    public String getRowkeyDistributionOutputPath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/rowkey_stats");
    }

    public void addOptimizeGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.add(this.getOptimizationRootPath(jobId));
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection on HDFS");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }

    public void addCheckpointGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        jobFlow.addTask((AbstractExecutable)this.createOptimizeGCStep());
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.addAll(this.getOptimizeHDFSPaths());
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection on HDFS");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }

    public void addMergingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        jobFlow.addTask((AbstractExecutable)this.createMergeGCStep());
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.addAll(this.getMergingHDFSPaths());
        toDeletePaths.add(this.getHFilePath(jobId));
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection on HDFS");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }

    public void addCubingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.add(this.getFactDistinctColumnsPath(jobId));
        toDeletePaths.add(this.getHFilePath(jobId));
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection on HBase");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }
}

