/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase;

import com.google.common.base.Preconditions;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.DataModelManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.storage.IStorage;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.hbase.steps.HBaseMROutput2Transition;

public class HBaseStorage
implements IStorage {
    public static final String v2CubeStorageQuery = "org.apache.kylin.storage.hbase.cube.v2.CubeStorageQuery";

    public IStorageQuery createQuery(IRealization realization) {
        if (realization.getType() == RealizationType.CUBE) {
            IStorageQuery ret;
            CubeInstance cubeInstance = (CubeInstance)realization;
            if (cubeInstance.getStorageType() == 0) {
                throw new IllegalStateException("Storage Engine (id=0) is not supported any more");
            }
            String cubeStorageQuery = v2CubeStorageQuery;
            try {
                ret = (IStorageQuery)Class.forName(cubeStorageQuery).getConstructor(CubeInstance.class).newInstance((CubeInstance)realization);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to initialize storage query for " + cubeStorageQuery, e);
            }
            return ret;
        }
        throw new IllegalArgumentException("Unknown realization type " + (Object)((Object)realization.getType()));
    }

    private static TblColRef getPartitionCol(IRealization realization) {
        String modelName = realization.getModel().getName();
        DataModelDesc dataModelDesc = DataModelManager.getInstance(KylinConfig.getInstanceFromEnv()).getDataModelDesc(modelName);
        PartitionDesc partitionDesc = dataModelDesc.getPartitionDesc();
        Preconditions.checkArgument((partitionDesc != null ? 1 : 0) != 0, (Object)("PartitionDesc for " + realization + " is null!"));
        TblColRef partitionColRef = partitionDesc.getPartitionDateColumnRef();
        Preconditions.checkArgument((partitionColRef != null ? 1 : 0) != 0, (Object)("getPartitionDateColumnRef for " + realization + " is null"));
        return partitionColRef;
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == IMROutput2.class) {
            return (I)new HBaseMROutput2Transition();
        }
        throw new RuntimeException("Cannot adapt to " + engineInterface);
    }
}

