/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.gridtable;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.ImmutableBitSet;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.IGTComparator;

public class GTRecord
implements Comparable<GTRecord> {
    final transient GTInfo info;
    final ByteArray[] cols;

    public GTRecord(GTInfo info, ByteArray[] cols) {
        this.info = info;
        this.cols = cols;
    }

    public GTRecord(GTInfo info) {
        this.cols = new ByteArray[info.getColumnCount()];
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i] = new ByteArray();
        }
        this.info = info;
    }

    public void shallowCopyFrom(GTRecord source) {
        assert (this.info == source.info);
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].reset(source.cols[i].array(), source.cols[i].offset(), source.cols[i].length());
        }
    }

    public GTInfo getInfo() {
        return this.info;
    }

    public ByteArray get(int i) {
        return this.cols[i];
    }

    public Object getValue(int i) {
        return this.info.codeSystem.decodeColumnValue(i, this.cols[i].asBuffer());
    }

    public ByteArray[] getInternal() {
        return this.cols;
    }

    public void set(int i, ByteArray data) {
        this.cols[i].reset(data.array(), data.offset(), data.length());
    }

    public void setValue(int i, Object value) {
        ByteArray space = new ByteArray(this.info.codeSystem.maxCodeLength(i));
        ByteBuffer buf = space.asBuffer();
        this.info.codeSystem.encodeColumnValue(i, value, buf);
        this.set(i, space);
        this.cols[i].reset(buf.array(), buf.arrayOffset(), buf.position());
    }

    public GTRecord setValues(Object ... values) {
        this.setValues(this.info.colAll, new ByteArray(this.info.getMaxRecordLength()), values);
        return this;
    }

    public GTRecord setValues(ImmutableBitSet selectedCols, ByteArray space, Object ... values) {
        assert (selectedCols.cardinality() == values.length);
        ByteBuffer buf = space.asBuffer();
        int pos = buf.position();
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            this.info.codeSystem.encodeColumnValue(c, values[i], buf);
            int newPos = buf.position();
            this.cols[c].reset(buf.array(), buf.arrayOffset() + pos, newPos - pos);
            pos = newPos;
        }
        return this;
    }

    public Object[] getValues() {
        return this.getValues(this.info.colAll, new Object[this.info.getColumnCount()]);
    }

    public Object[] getValues(ImmutableBitSet selectedCols, Object[] result) {
        assert (selectedCols.cardinality() == result.length);
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            result[i] = this.decodeValue(selectedCols.trueBitAt(i));
        }
        return result;
    }

    public Object[] getValues(int[] selectedColumns, Object[] result) {
        assert (selectedColumns.length <= result.length);
        for (int i = 0; i < selectedColumns.length; ++i) {
            result[i] = this.decodeValue(selectedColumns[i]);
        }
        return result;
    }

    public Object decodeValue(int c) {
        ByteArray col = this.cols[c];
        if (col != null && col.array() != null) {
            return this.info.codeSystem.decodeColumnValue(c, col.asBuffer());
        }
        return null;
    }

    public int sizeOf(ImmutableBitSet selectedCols) {
        int size = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            size += this.cols[c].length();
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GTRecord o = (GTRecord)obj;
        if (this.info != o.info) {
            return false;
        }
        for (int i = 0; i < this.info.colAll.trueBitCount(); ++i) {
            int c = this.info.colAll.trueBitAt(i);
            if (this.cols[c].equals(o.cols[c])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 1;
        for (int i = 0; i < this.info.colAll.trueBitCount(); ++i) {
            int c = this.info.colAll.trueBitAt(i);
            hash = 31 * hash + this.cols[c].hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(GTRecord o) {
        return this.compareToInternal(o, this.info.colAll);
    }

    public static Comparator<GTRecord> getComparator(final ImmutableBitSet participateCols) {
        return new Comparator<GTRecord>(){

            @Override
            public int compare(GTRecord o1, GTRecord o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalStateException("Cannot handle null");
                }
                return o1.compareToInternal(o2, participateCols);
            }
        };
    }

    private int compareToInternal(GTRecord o, ImmutableBitSet participateCols) {
        assert (this.info == o.info);
        IGTComparator comparator = this.info.codeSystem.getComparator();
        int comp = 0;
        for (int i = 0; i < participateCols.trueBitCount(); ++i) {
            int c = participateCols.trueBitAt(i);
            comp = comparator.compare(this.cols[c], o.cols[c]);
            if (comp == 0) continue;
            return comp;
        }
        return comp;
    }

    public String toString() {
        return this.toString(this.info.colAll);
    }

    public String toString(ImmutableBitSet selectedColumns) {
        Object[] values = new Object[selectedColumns.cardinality()];
        this.getValues(selectedColumns, values);
        return Arrays.toString(values);
    }

    public ByteArray exportColumns(ImmutableBitSet selectedCols) {
        int len = this.sizeOf(selectedCols);
        ByteArray buf = ByteArray.allocate(len);
        this.exportColumns(selectedCols, buf);
        return buf;
    }

    public void exportColumns(ImmutableBitSet selectedCols, ByteArray buf) {
        int pos = 0;
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            Preconditions.checkNotNull((Object)this.cols[c].array());
            System.arraycopy(this.cols[c].array(), this.cols[c].offset(), buf.array(), buf.offset() + pos, this.cols[c].length());
            pos += this.cols[c].length();
        }
        buf.setLength(pos);
    }

    public void exportColumns(ImmutableBitSet selectedCols, ByteBuffer buf) {
        for (int i = 0; i < selectedCols.trueBitCount(); ++i) {
            int c = selectedCols.trueBitAt(i);
            buf.put(this.cols[c].array(), this.cols[c].offset(), this.cols[c].length());
        }
    }

    public void exportColumns(int[] fieldIndex, ByteBuffer buf) {
        for (int i : fieldIndex) {
            buf.put(this.cols[i].array(), this.cols[i].offset(), this.cols[i].length());
        }
    }

    public void exportColumnBlock(int c, ByteBuffer buf) {
        this.exportColumns(this.info.colBlocks[c], buf);
    }

    public void loadCellBlock(int c, ByteBuffer buf) {
        this.loadColumns(this.info.colBlocks[c], buf);
    }

    public void loadColumns(ByteBuffer buf) {
        this.loadColumns(this.info.colAll, buf);
    }

    public void loadColumns(Iterable<Integer> selectedCols, ByteBuffer buf) {
        int pos = buf.position();
        for (int c : selectedCols) {
            int len = this.info.codeSystem.codeLength(c, buf);
            this.cols[c].reset(buf.array(), buf.arrayOffset() + pos, len);
            buf.position(pos += len);
        }
    }

    public void loadColumns(int selectedCol, ByteBuffer buf) {
        int pos = buf.position();
        int len = this.info.codeSystem.codeLength(selectedCol, buf);
        this.cols[selectedCol].reset(buf.array(), buf.arrayOffset() + pos, len);
    }

    public void loadColumnsFromColumnBlocks(ImmutableBitSet[] selectedColumnBlocks, ImmutableBitSet selectedCols, ByteBuffer buf) {
        int pos = buf.position();
        for (ImmutableBitSet selectedColBlock : selectedColumnBlocks) {
            for (int i = 0; i < selectedColBlock.trueBitCount(); ++i) {
                int c = selectedColBlock.trueBitAt(i);
                int len = this.info.codeSystem.codeLength(c, buf);
                if (selectedCols.get(c)) {
                    this.cols[c].reset(buf.array(), buf.arrayOffset() + pos, len);
                }
                buf.position(pos += len);
            }
        }
    }
}

