/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict.lookup.cache;

import com.google.common.base.Charsets;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfo;
import org.apache.kylin.dict.lookup.ExtTableSnapshotInfoManager;
import org.apache.kylin.dict.lookup.IExtLookupTableCache;
import org.apache.kylin.dict.lookup.ILookupTable;
import org.apache.kylin.dict.lookup.LookupProviderFactory;
import org.apache.kylin.dict.lookup.cache.RocksDBLookupBuilder;
import org.apache.kylin.dict.lookup.cache.RocksDBLookupTable;
import org.apache.kylin.metadata.model.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBLookupTableCache
implements IExtLookupTableCache {
    private static final Logger logger = LoggerFactory.getLogger(RocksDBLookupTableCache.class);
    private static final String CACHE_TYPE_ROCKSDB = "rocksdb";
    private static final String STATE_FILE = "STATE";
    private static final String DB_FILE = "db";
    private String basePath;
    private long maxCacheSizeInKB;
    private Cache<String, CachedTableInfo> tablesCache;
    private ConcurrentMap<String, Boolean> inBuildingTables = Maps.newConcurrentMap();
    private ExecutorService cacheBuildExecutor;
    private ScheduledExecutorService cacheStateCheckExecutor;
    private CacheStateChecker cacheStateChecker;
    private static final ConcurrentMap<KylinConfig, RocksDBLookupTableCache> SERVICE_CACHE = new ConcurrentHashMap<KylinConfig, RocksDBLookupTableCache>();
    private KylinConfig config;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RocksDBLookupTableCache getInstance(KylinConfig config) {
        RocksDBLookupTableCache r = (RocksDBLookupTableCache)SERVICE_CACHE.get(config);
        if (r != null) return r;
        Class<RocksDBLookupTableCache> clazz = RocksDBLookupTableCache.class;
        synchronized (RocksDBLookupTableCache.class) {
            r = (RocksDBLookupTableCache)SERVICE_CACHE.get(config);
            if (r != null) return r;
            r = new RocksDBLookupTableCache(config);
            SERVICE_CACHE.put(config, r);
            if (SERVICE_CACHE.size() <= 1) return r;
            logger.warn("More than one singleton exist");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        ConcurrentMap<KylinConfig, RocksDBLookupTableCache> concurrentMap = SERVICE_CACHE;
        synchronized (concurrentMap) {
            SERVICE_CACHE.clear();
        }
    }

    private RocksDBLookupTableCache(KylinConfig config) {
        this.config = config;
        this.init();
    }

    private void init() {
        this.basePath = RocksDBLookupTableCache.getCacheBasePath(this.config);
        this.maxCacheSizeInKB = (long)(this.config.getExtTableSnapshotLocalCacheMaxSizeGB() * 1024.0 * 1024.0);
        this.tablesCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, CachedTableInfo>(){

            public void onRemoval(RemovalNotification<String, CachedTableInfo> notification) {
                logger.warn(notification.getValue() + " is removed " + "because of " + notification.getCause());
                ((CachedTableInfo)notification.getValue()).cleanStorage();
            }
        }).maximumWeight(this.maxCacheSizeInKB).weigher((Weigher)new Weigher<String, CachedTableInfo>(){

            public int weigh(String key, CachedTableInfo value) {
                return value.getSizeInKB();
            }
        }).build();
        this.restoreCacheState();
        this.cacheStateChecker = new CacheStateChecker();
        this.initExecutors();
    }

    protected static String getCacheBasePath(KylinConfig config) {
        String basePath = config.getExtTableSnapshotLocalCachePath();
        if (!basePath.startsWith("/") && KylinConfig.getKylinHome() != null) {
            basePath = KylinConfig.getKylinHome() + File.separator + basePath;
        }
        return basePath + File.separator + CACHE_TYPE_ROCKSDB;
    }

    private void restoreCacheState() {
        File dbBaseFolder = new File(this.basePath);
        if (!dbBaseFolder.exists()) {
            dbBaseFolder.mkdirs();
        }
        Map<String, File[]> tableSnapshotsFileMap = this.getCachedTableSnapshotsFolders(dbBaseFolder);
        for (Map.Entry<String, File[]> tableSnapshotsEntry : tableSnapshotsFileMap.entrySet()) {
            for (File snapshotFolder : tableSnapshotsEntry.getValue()) {
                this.initSnapshotState(tableSnapshotsEntry.getKey(), snapshotFolder);
            }
        }
    }

    private Map<String, File[]> getCachedTableSnapshotsFolders(File dbBaseFolder) {
        HashMap result = Maps.newHashMap();
        File[] tableFolders = dbBaseFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (tableFolders == null) {
            return result;
        }
        for (File tableFolder : tableFolders) {
            String tableName = tableFolder.getName();
            File[] snapshotFolders = tableFolder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File snapshotFile) {
                    return snapshotFile.isDirectory();
                }
            });
            result.put(tableName, snapshotFolders);
        }
        return result;
    }

    private void initSnapshotState(String tableName, File snapshotCacheFolder) {
        String snapshotID = snapshotCacheFolder.getName();
        File stateFile = this.getCacheStateFile(snapshotCacheFolder.getAbsolutePath());
        if (stateFile.exists()) {
            try {
                String stateStr = Files.toString((File)stateFile, (Charset)Charsets.UTF_8);
                String resourcePath = ExtTableSnapshotInfo.getResourcePath(tableName, snapshotID);
                if (IExtLookupTableCache.CacheState.AVAILABLE.name().equals(stateStr)) {
                    this.tablesCache.put((Object)resourcePath, (Object)new CachedTableInfo(snapshotCacheFolder.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                logger.error("error to read state file:" + stateFile.getAbsolutePath());
            }
        }
    }

    private void initExecutors() {
        this.cacheBuildExecutor = new ThreadPoolExecutor(0, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory("lookup-cache-build-thread"));
        this.cacheStateCheckExecutor = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("lookup-cache-state-checker"));
        this.cacheStateCheckExecutor.scheduleAtFixedRate(this.cacheStateChecker, 10L, 600L, TimeUnit.SECONDS);
    }

    @Override
    public ILookupTable getCachedLookupTable(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshotInfo, boolean buildIfNotExist) {
        String resourcePath = extTableSnapshotInfo.getResourcePath();
        if (this.inBuildingTables.containsKey(resourcePath)) {
            logger.info("cache is in building for snapshot:" + resourcePath);
            return null;
        }
        CachedTableInfo cachedTableInfo = (CachedTableInfo)this.tablesCache.getIfPresent((Object)resourcePath);
        if (cachedTableInfo == null) {
            if (buildIfNotExist) {
                this.buildSnapshotCache(tableDesc, extTableSnapshotInfo, this.getSourceLookupTable(tableDesc, extTableSnapshotInfo));
            }
            logger.info("no available cache ready for the table snapshot:" + extTableSnapshotInfo.getResourcePath());
            return null;
        }
        String[] keyColumns = extTableSnapshotInfo.getKeyColumns();
        String dbPath = this.getSnapshotStorePath(extTableSnapshotInfo.getTableName(), extTableSnapshotInfo.getId());
        return new RocksDBLookupTable(tableDesc, keyColumns, dbPath);
    }

    private ILookupTable getSourceLookupTable(TableDesc tableDesc, ExtTableSnapshotInfo extTableSnapshotInfo) {
        return LookupProviderFactory.getExtLookupTableWithoutCache(tableDesc, extTableSnapshotInfo);
    }

    @Override
    public void buildSnapshotCache(final TableDesc tableDesc, final ExtTableSnapshotInfo extTableSnapshotInfo, final ILookupTable sourceTable) {
        if (extTableSnapshotInfo.getSignature().getSize() / 1024L > this.maxCacheSizeInKB * 2L / 3L) {
            logger.warn("the size is to large to build to cache for snapshot:{}, size:{}, skip cache building", (Object)extTableSnapshotInfo.getResourcePath(), (Object)extTableSnapshotInfo.getSignature().getSize());
            return;
        }
        final String[] keyColumns = extTableSnapshotInfo.getKeyColumns();
        final String cachePath = this.getSnapshotCachePath(extTableSnapshotInfo.getTableName(), extTableSnapshotInfo.getId());
        final String dbPath = this.getSnapshotStorePath(extTableSnapshotInfo.getTableName(), extTableSnapshotInfo.getId());
        final String snapshotResPath = extTableSnapshotInfo.getResourcePath();
        if (this.inBuildingTables.containsKey(snapshotResPath)) {
            logger.info("there is already snapshot cache in building for snapshot:{}, skip it", (Object)snapshotResPath);
            return;
        }
        if (this.inBuildingTables.putIfAbsent(snapshotResPath, true) == null) {
            this.cacheBuildExecutor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        RocksDBLookupBuilder builder = new RocksDBLookupBuilder(tableDesc, keyColumns, dbPath);
                        builder.build(sourceTable);
                        RocksDBLookupTableCache.this.saveSnapshotCacheState(extTableSnapshotInfo, cachePath);
                    }
                    catch (Exception e) {
                        logger.error("error when build snapshot cache", (Throwable)e);
                    }
                    finally {
                        RocksDBLookupTableCache.this.inBuildingTables.remove(snapshotResPath);
                    }
                }
            });
        } else {
            logger.info("there is already snapshot cache in building for snapshot:{}, skip it", (Object)snapshotResPath);
        }
    }

    @Override
    public void removeSnapshotCache(ExtTableSnapshotInfo extTableSnapshotInfo) {
        this.tablesCache.invalidate((Object)extTableSnapshotInfo.getResourcePath());
    }

    @Override
    public IExtLookupTableCache.CacheState getCacheState(ExtTableSnapshotInfo extTableSnapshotInfo) {
        String resourcePath = extTableSnapshotInfo.getResourcePath();
        if (this.inBuildingTables.containsKey(resourcePath)) {
            return IExtLookupTableCache.CacheState.IN_BUILDING;
        }
        File stateFile = this.getCacheStateFile(this.getSnapshotCachePath(extTableSnapshotInfo.getTableName(), extTableSnapshotInfo.getId()));
        if (!stateFile.exists()) {
            return IExtLookupTableCache.CacheState.NONE;
        }
        try {
            String stateString = Files.toString((File)stateFile, (Charset)Charsets.UTF_8);
            return IExtLookupTableCache.CacheState.valueOf(stateString);
        }
        catch (IOException e) {
            logger.error("error when read state file", (Throwable)e);
            return IExtLookupTableCache.CacheState.NONE;
        }
    }

    public long getTotalCacheSize() {
        return FileUtils.sizeOfDirectory((File)new File(RocksDBLookupTableCache.getCacheBasePath(this.config)));
    }

    public void checkCacheState() {
        this.cacheStateChecker.run();
    }

    private void saveSnapshotCacheState(ExtTableSnapshotInfo extTableSnapshotInfo, String cachePath) {
        File stateFile = this.getCacheStateFile(this.getSnapshotCachePath(extTableSnapshotInfo.getTableName(), extTableSnapshotInfo.getId()));
        try {
            Files.write((CharSequence)IExtLookupTableCache.CacheState.AVAILABLE.name(), (File)stateFile, (Charset)Charsets.UTF_8);
            this.tablesCache.put((Object)extTableSnapshotInfo.getResourcePath(), (Object)new CachedTableInfo(cachePath));
        }
        catch (IOException e) {
            throw new RuntimeException("error when write cache state for snapshot:" + extTableSnapshotInfo.getResourcePath());
        }
    }

    private File getCacheStateFile(String snapshotCacheFolder) {
        String stateFilePath = snapshotCacheFolder + File.separator + STATE_FILE;
        return new File(stateFilePath);
    }

    protected String getSnapshotStorePath(String tableName, String snapshotID) {
        return this.getSnapshotCachePath(tableName, snapshotID) + File.separator + DB_FILE;
    }

    protected String getSnapshotCachePath(String tableName, String snapshotID) {
        return this.basePath + File.separator + tableName + File.separator + snapshotID;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public NamedThreadFactory(String threadPrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = threadPrefix + "-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            return t;
        }
    }

    private static class CachedTableInfo {
        private String cachePath;
        private long dbSize;

        public CachedTableInfo(String cachePath) {
            this.cachePath = cachePath;
            this.dbSize = FileUtils.sizeOfDirectory((File)new File(cachePath));
        }

        public int getSizeInKB() {
            return (int)(this.dbSize / 1024L);
        }

        public void cleanStorage() {
            logger.info("clean cache storage for path:" + this.cachePath);
            try {
                FileUtils.deleteDirectory((File)new File(this.cachePath));
            }
            catch (IOException e) {
                logger.error("file delete fail:" + this.cachePath, (Throwable)e);
            }
        }
    }

    private class CacheStateChecker
    implements Runnable {
        private CacheStateChecker() {
        }

        @Override
        public void run() {
            try {
                String cacheBasePath = RocksDBLookupTableCache.getCacheBasePath(RocksDBLookupTableCache.this.config);
                logger.info("check snapshot local cache state, local path:{}", (Object)cacheBasePath);
                File baseFolder = new File(cacheBasePath);
                if (!baseFolder.exists()) {
                    return;
                }
                Map tableSnapshotsFileMap = RocksDBLookupTableCache.this.getCachedTableSnapshotsFolders(baseFolder);
                ArrayList allCachedSnapshots = Lists.newArrayList();
                for (Map.Entry tableSnapshotsEntry : tableSnapshotsFileMap.entrySet()) {
                    String tableName = (String)tableSnapshotsEntry.getKey();
                    for (File file : (File[])tableSnapshotsEntry.getValue()) {
                        String snapshotID = file.getName();
                        allCachedSnapshots.add(new Pair<String, File>(ExtTableSnapshotInfo.getResourcePath(tableName, snapshotID), file));
                    }
                }
                final Set<String> activeSnapshotSet = ExtTableSnapshotInfoManager.getInstance(RocksDBLookupTableCache.this.config).getAllExtSnapshotResPaths();
                ArrayList toRemovedCachedSnapshots = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)allCachedSnapshots).filter((Predicate)new Predicate<Pair<String, File>>(){

                    public boolean apply(@Nullable Pair<String, File> input) {
                        return !activeSnapshotSet.contains(input.getFirst());
                    }
                }));
                for (Pair toRemovedCachedSnapshot : toRemovedCachedSnapshots) {
                    File snapshotCacheFolder = (File)toRemovedCachedSnapshot.getSecond();
                    logger.info("removed cache file:{}, it is not referred by any cube", (Object)snapshotCacheFolder.getAbsolutePath());
                    try {
                        FileUtils.deleteDirectory((File)snapshotCacheFolder);
                    }
                    catch (IOException e) {
                        logger.error("fail to remove folder:" + snapshotCacheFolder.getAbsolutePath(), (Throwable)e);
                    }
                    RocksDBLookupTableCache.this.tablesCache.invalidate(toRemovedCachedSnapshot.getFirst());
                }
            }
            catch (Exception e) {
                logger.error("error happens when check cache state", (Throwable)e);
            }
        }
    }
}

