/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.dict;

import java.io.IOException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.lock.DistributedLock;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.dict.AppendTrieDictionary;
import org.apache.kylin.dict.DictionaryInfo;
import org.apache.kylin.dict.IDictionaryBuilder;
import org.apache.kylin.dict.global.AppendTrieDictionaryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalDictionaryBuilder
implements IDictionaryBuilder {
    private AppendTrieDictionaryBuilder builder;
    private int baseId;
    private DistributedLock lock;
    private String sourceColumn;
    private int counter;
    private static Logger logger = LoggerFactory.getLogger(GlobalDictionaryBuilder.class);

    @Override
    public void init(DictionaryInfo dictInfo, int baseId, String hdfsDir) throws IOException {
        this.sourceColumn = dictInfo.getSourceTable() + "_" + dictInfo.getSourceColumn();
        this.lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().lockForCurrentThread();
        this.lock.lock(this.getLockPath(this.sourceColumn), Long.MAX_VALUE);
        int maxEntriesPerSlice = KylinConfig.getInstanceFromEnv().getAppendDictEntrySize();
        if (hdfsDir == null) {
            hdfsDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        }
        String baseDir = hdfsDir + "resources/GlobalDict" + dictInfo.getResourceDir() + "/";
        try {
            this.builder = new AppendTrieDictionaryBuilder(baseDir, maxEntriesPerSlice, true);
        }
        catch (Throwable e) {
            this.lock.unlock(this.getLockPath(this.sourceColumn));
            throw new RuntimeException(String.format("Failed to create global dictionary on %s ", this.sourceColumn), e);
        }
        this.baseId = baseId;
    }

    @Override
    public boolean addValue(String value) {
        if (++this.counter % 1000000 == 0) {
            if (this.lock.lock(this.getLockPath(this.sourceColumn))) {
                logger.info("processed {} values for {}", (Object)this.counter, (Object)this.sourceColumn);
            } else {
                throw new RuntimeException("Failed to create global dictionary on " + this.sourceColumn + " This client doesn't keep the lock");
            }
        }
        if (value == null) {
            return false;
        }
        try {
            this.builder.addValue(value);
        }
        catch (Throwable e) {
            this.lock.unlock(this.getLockPath(this.sourceColumn));
            throw new RuntimeException(String.format("Failed to create global dictionary on %s ", this.sourceColumn), e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dictionary<String> build() throws IOException {
        try {
            if (this.lock.lock(this.getLockPath(this.sourceColumn))) {
                AppendTrieDictionary appendTrieDictionary = this.builder.build(this.baseId);
                return appendTrieDictionary;
            }
        }
        finally {
            this.lock.unlock(this.getLockPath(this.sourceColumn));
        }
        return new AppendTrieDictionary<String>();
    }

    private String getLockPath(String pathName) {
        return "/dict/" + pathName + "/lock";
    }
}

