/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.model.validation.rule;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.IValidatorRule;
import org.apache.kylin.cube.model.validation.ResultLevel;
import org.apache.kylin.cube.model.validation.ValidateContext;

public class AggregationGroupRule
implements IValidatorRule<CubeDesc> {
    @Override
    public void validate(CubeDesc cube, ValidateContext context) {
        this.inner(cube, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inner(CubeDesc cube, ValidateContext context) {
        if (cube.getAggregationGroups() == null || cube.getAggregationGroups().size() == 0) {
            context.addResult(ResultLevel.ERROR, "Cube should have at least one Aggregation group.");
            return;
        }
        int index = 1;
        for (AggregationGroup agg : cube.getAggregationGroups()) {
            block33: {
                if (agg.getIncludes() == null) {
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'includes' field not set");
                    continue;
                }
                if (agg.getSelectRule() == null) {
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'select rule' field not set");
                    continue;
                }
                TreeSet<String> includeDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (agg.getIncludes() != null) {
                    for (String include : agg.getIncludes()) {
                        includeDims.add(include);
                    }
                }
                TreeSet<String> mandatoryDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (agg.getSelectRule().mandatoryDims != null) {
                    for (String m : agg.getSelectRule().mandatoryDims) {
                        mandatoryDims.add(m);
                    }
                }
                TreeSet<String> hierarchyDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (agg.getSelectRule().hierarchyDims != null) {
                    String[][] arr$ = agg.getSelectRule().hierarchyDims;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String[] ss;
                        for (String s : ss = arr$[i$]) {
                            hierarchyDims.add(s);
                        }
                    }
                }
                TreeSet<String> jointDims = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                if (agg.getSelectRule().jointDims != null) {
                    String[][] arr$ = agg.getSelectRule().jointDims;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String[] ss;
                        for (String s : ss = arr$[i$]) {
                            jointDims.add(s);
                        }
                    }
                }
                if (!(includeDims.containsAll(mandatoryDims) && includeDims.containsAll(hierarchyDims) && includeDims.containsAll(jointDims))) {
                    ArrayList notIncluded = Lists.newArrayList();
                    Iterable all = Iterables.unmodifiableIterable((Iterable)Iterables.concat(mandatoryDims, hierarchyDims, jointDims));
                    for (String dim : all) {
                        if (includeDims.contains(dim)) continue;
                        notIncluded.add(dim);
                    }
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " 'includes' dimensions not include all the dimensions:" + ((Object)notIncluded).toString());
                    continue;
                }
                if (CollectionUtils.containsAny(mandatoryDims, hierarchyDims)) {
                    HashSet intersection = new HashSet(mandatoryDims);
                    intersection.retainAll(hierarchyDims);
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dimension has overlap with hierarchy dimension: " + ((Object)intersection).toString());
                    continue;
                }
                if (CollectionUtils.containsAny(mandatoryDims, jointDims)) {
                    HashSet intersection = new HashSet(mandatoryDims);
                    intersection.retainAll(jointDims);
                    context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " mandatory dimension has overlap with joint dimension: " + ((Object)intersection).toString());
                    continue;
                }
                int jointDimNum = 0;
                if (agg.getSelectRule().jointDims != null) {
                    for (String[] joints : agg.getSelectRule().jointDims) {
                        TreeSet<String> oneJoint = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                        for (String s : joints) {
                            oneJoint.add(s);
                        }
                        if (oneJoint.size() < 2) {
                            context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " require at least 2 dimensions in a joint: " + ((Object)oneJoint).toString());
                            continue;
                        }
                        jointDimNum += oneJoint.size();
                        int overlapHierarchies = 0;
                        if (agg.getSelectRule().hierarchyDims == null) continue;
                        for (String[] oneHierarchy : agg.getSelectRule().hierarchyDims) {
                            TreeSet share = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                            share.addAll(CollectionUtils.intersection(oneJoint, Arrays.asList(oneHierarchy)));
                            if (!share.isEmpty()) {
                                ++overlapHierarchies;
                            }
                            if (share.size() <= 1) continue;
                            context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint dimensions has overlap with more than 1 dimensions in same hierarchy: " + ((Object)share).toString());
                        }
                        if (overlapHierarchies <= true) continue;
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " joint dimensions has overlap with more than 1 hierarchies");
                    }
                    if (jointDimNum != jointDims.size()) {
                        TreeSet existing = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                        TreeSet overlap = new TreeSet(String.CASE_INSENSITIVE_ORDER);
                        for (String[] joints : agg.getSelectRule().jointDims) {
                            TreeSet<String> oneJoint = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                            for (String s : joints) {
                                oneJoint.add(s);
                            }
                            if (CollectionUtils.containsAny(existing, oneJoint)) {
                                overlap.addAll(CollectionUtils.intersection(existing, oneJoint));
                            }
                            existing.addAll(oneJoint);
                        }
                        context.addResult(ResultLevel.ERROR, "Aggregation group " + index + " a dimension exists in more than one joint: " + ((Object)overlap).toString());
                        continue;
                    }
                }
                long combination = 0L;
                try {
                    combination = agg.calculateCuboidCombination();
                }
                catch (Exception ex) {
                    combination = this.getMaxCombinations(cube) + 1L;
                }
                finally {
                    if (combination <= this.getMaxCombinations(cube)) break block33;
                    String msg = "Aggregation group " + index + " has too many combinations, current combination is " + combination + ", max allowed combination is " + this.getMaxCombinations(cube) + "; use 'mandatory'/'hierarchy'/'joint' to optimize; or update 'kylin.cube.aggrgroup.max-combination' to a bigger value.";
                    context.addResult(ResultLevel.ERROR, msg);
                    continue;
                }
            }
            ++index;
        }
    }

    protected long getMaxCombinations(CubeDesc cubeDesc) {
        return cubeDesc.getConfig().getCubeAggrGroupMaxCombination();
    }
}

