/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.greedy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyAlgorithm
extends AbstractRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GreedyAlgorithm.class);
    private static final int THREAD_NUM = 8;
    private ExecutorService executor;
    private Set<Long> selected = Sets.newLinkedHashSet();
    private List<Long> remaining = Lists.newLinkedList();

    public GreedyAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        super(timeout, benefitPolicy, cuboidStats);
    }

    @Override
    public List<Long> start(double spaceLimit) {
        CuboidBenefitModel best;
        logger.info("Greedy Algorithm started.");
        this.executor = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("greedy-algorithm-benefit-calculator-pool-%d").build());
        this.selected.clear();
        double remainingSpace = spaceLimit;
        for (Long mandatoryOne : this.cuboidStats.getAllCuboidsForMandatory()) {
            this.selected.add(mandatoryOne);
            if (this.cuboidStats.getCuboidSize(mandatoryOne) == null) continue;
            remainingSpace -= this.cuboidStats.getCuboidSize(mandatoryOne).doubleValue();
        }
        this.remaining.clear();
        this.remaining.addAll((Collection<Long>)this.cuboidStats.getAllCuboidsForSelection());
        long round = 0L;
        while (!this.shouldCancel() && (best = this.recommendBestOne()) != null && this.benefitPolicy.ifEfficient(best) && !((remainingSpace -= this.cuboidStats.getCuboidSize(best.getCuboidId()).doubleValue()) <= 0.0)) {
            this.selected.add(best.getCuboidId());
            this.remaining.remove(best.getCuboidId());
            this.benefitPolicy.propagateAggregationCost(best.getCuboidId(), this.selected);
            ++round;
            if (!logger.isTraceEnabled()) continue;
            logger.trace(String.format("Recommend in round %d : %s", round, best.toString()));
        }
        this.executor.shutdown();
        ArrayList excluded = Lists.newArrayList(this.remaining);
        this.remaining.retainAll(this.selected);
        Preconditions.checkArgument((this.remaining.size() == 0 ? 1 : 0) != 0, (Object)"There should be no intersection between excluded list and selected list.");
        logger.info("Greedy Algorithm finished.");
        if (logger.isTraceEnabled()) {
            logger.trace("Excluded cuboidId size:" + excluded.size());
            logger.trace("Excluded cuboidId detail:");
            for (Long cuboid : excluded) {
                logger.trace(String.format("cuboidId %d and Cost: %d and Space: %f", cuboid, this.cuboidStats.getCuboidQueryCost(cuboid), this.cuboidStats.getCuboidSize(cuboid)));
            }
            logger.trace("Total Space:" + (spaceLimit - remainingSpace));
            logger.trace("Space Expansion Rate:" + (spaceLimit - remainingSpace) / this.cuboidStats.getBaseCuboidSize());
        }
        return Lists.newArrayList(this.selected);
    }

    private CuboidBenefitModel recommendBestOne() {
        final int selectedSize = this.selected.size();
        final AtomicReference best = new AtomicReference();
        final CountDownLatch counter = new CountDownLatch(this.remaining.size());
        for (final Long cuboid : this.remaining) {
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    CuboidBenefitModel currentBest = (CuboidBenefitModel)best.get();
                    assert (GreedyAlgorithm.this.selected.size() == selectedSize);
                    CuboidBenefitModel.BenefitModel benefitModel = GreedyAlgorithm.this.benefitPolicy.calculateBenefit(cuboid, GreedyAlgorithm.this.selected);
                    if (benefitModel != null && (currentBest == null || currentBest.getBenefit() == null || benefitModel.benefit > currentBest.getBenefit())) {
                        while (!best.compareAndSet(currentBest, new CuboidBenefitModel(GreedyAlgorithm.this.cuboidStats.getCuboidModel(cuboid), benefitModel)) && !(benefitModel.benefit <= (currentBest = (CuboidBenefitModel)best.get()).getBenefit())) {
                        }
                    }
                    counter.countDown();
                }
            });
        }
        try {
            counter.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (CuboidBenefitModel)best.get();
    }
}

