/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStatsUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuboidStats {
    private static final Logger logger = LoggerFactory.getLogger(CuboidStats.class);
    private static final double WEIGHT_FOR_UN_QUERY = 0.2;
    private String key;
    private long baseCuboid;
    private ImmutableSet<Long> mandatoryCuboidSet;
    private ImmutableSet<Long> selectionCuboidSet;
    private ImmutableMap<Long, Long> cuboidCountMap;
    private ImmutableMap<Long, Double> cuboidSizeMap;
    private ImmutableMap<Long, Double> cuboidHitProbabilityMap;
    private ImmutableMap<Long, Long> cuboidScanCountMap;
    private ImmutableMap<Long, List<Long>> directChildrenCache;
    private Map<Long, Set<Long>> allDescendantsCache;

    private CuboidStats(String key, long baseCuboidId, Set<Long> mandatoryCuboids, Map<Long, Long> statistics, Map<Long, Double> size, Map<Long, Long> hitFrequencyMap, Map<Long, Map<Long, Long>> scanCountSourceMap) {
        this.key = key;
        this.baseCuboid = baseCuboidId;
        HashSet cuboidsForMandatory = Sets.newHashSet(mandatoryCuboids);
        if (!cuboidsForMandatory.contains(this.baseCuboid)) {
            cuboidsForMandatory.add(this.baseCuboid);
        }
        logger.info("Mandatory cuboids: " + cuboidsForMandatory);
        HashSet cuboidsForSelection = Sets.newHashSet(statistics.keySet());
        cuboidsForSelection.removeAll(cuboidsForMandatory);
        this.mandatoryCuboidSet = ImmutableSet.builder().addAll((Iterable)cuboidsForMandatory).build();
        this.selectionCuboidSet = ImmutableSet.builder().addAll((Iterable)cuboidsForSelection).build();
        if (this.selectionCuboidSet.isEmpty()) {
            logger.warn("The selection set should not be empty!!!");
        }
        CuboidStatsUtil.complementRowCountForMandatoryCuboids(statistics, this.baseCuboid, this.mandatoryCuboidSet);
        this.cuboidCountMap = ImmutableMap.builder().putAll(statistics).build();
        this.cuboidSizeMap = ImmutableMap.builder().putAll(size).build();
        HashMap tmpCuboidHitProbabilityMap = Maps.newHashMapWithExpectedSize((int)this.selectionCuboidSet.size());
        if (hitFrequencyMap != null) {
            long totalHitFrequency = 0L;
            for (Map.Entry<Long, Long> hitFrequency : hitFrequencyMap.entrySet()) {
                if (!this.selectionCuboidSet.contains((Object)hitFrequency.getKey())) continue;
                totalHitFrequency += hitFrequency.getValue().longValue();
            }
            double unitUncertainProb = 0.2 / (double)this.selectionCuboidSet.size();
            for (Long cuboid : this.selectionCuboidSet) {
                if (hitFrequencyMap.get(cuboid) != null) {
                    tmpCuboidHitProbabilityMap.put(cuboid, unitUncertainProb + 0.8 * (double)hitFrequencyMap.get(cuboid).longValue() / (double)totalHitFrequency);
                    continue;
                }
                tmpCuboidHitProbabilityMap.put(cuboid, unitUncertainProb);
            }
        } else {
            for (Long cuboid : this.selectionCuboidSet) {
                tmpCuboidHitProbabilityMap.put(cuboid, 1.0 / (double)this.selectionCuboidSet.size());
            }
        }
        this.cuboidHitProbabilityMap = ImmutableMap.builder().putAll((Map)tmpCuboidHitProbabilityMap).build();
        HashMap tmpCuboidScanCountMap = Maps.newHashMapWithExpectedSize((int)(1 + this.selectionCuboidSet.size()));
        tmpCuboidScanCountMap.put(this.baseCuboid, this.getExpScanCount(this.baseCuboid, statistics, scanCountSourceMap));
        for (Long cuboid : this.selectionCuboidSet) {
            tmpCuboidScanCountMap.put(cuboid, this.getExpScanCount(cuboid, statistics, scanCountSourceMap));
        }
        this.cuboidScanCountMap = ImmutableMap.builder().putAll((Map)tmpCuboidScanCountMap).build();
        this.directChildrenCache = ImmutableMap.builder().putAll(CuboidStatsUtil.createDirectChildrenCache(statistics.keySet())).build();
        this.allDescendantsCache = Maps.newConcurrentMap();
    }

    private long getExpScanCount(long sourceCuboid, Map<Long, Long> statistics, Map<Long, Map<Long, Long>> scanCountSourceMap) {
        Preconditions.checkNotNull((Object)statistics.get(sourceCuboid), (Object)("The statistics for source cuboid " + sourceCuboid + " does not exist!!!"));
        if (scanCountSourceMap == null || scanCountSourceMap.get(sourceCuboid) == null || scanCountSourceMap.get(sourceCuboid).size() <= 0) {
            return statistics.get(sourceCuboid);
        }
        Map<Long, Long> scanCountTargetMap = scanCountSourceMap.get(sourceCuboid);
        long totalEstScanCount = 0L;
        for (Map.Entry<Long, Long> subEntry : scanCountTargetMap.entrySet()) {
            long targetCuboid = subEntry.getKey();
            Preconditions.checkNotNull((Object)statistics.get(targetCuboid), (Object)("The statistics for target cuboid " + targetCuboid + " does not exist!!!"));
            totalEstScanCount += subEntry.getValue() * statistics.get(sourceCuboid) / statistics.get(targetCuboid);
        }
        return totalEstScanCount / (long)scanCountTargetMap.size();
    }

    public Set<Long> getAllDescendants(long cuboid) {
        LinkedHashSet allDescendants = Sets.newLinkedHashSet();
        if (this.selectionCuboidSet.contains((Object)cuboid)) {
            if (this.allDescendantsCache.get(cuboid) != null) {
                return this.allDescendantsCache.get(cuboid);
            }
            this.getAllDescendants(cuboid, allDescendants);
            this.allDescendantsCache.put(cuboid, allDescendants);
        }
        return allDescendants;
    }

    private void getAllDescendants(long cuboid, Set<Long> allDescendants) {
        if (allDescendants.contains(cuboid)) {
            return;
        }
        allDescendants.add(cuboid);
        for (Long directChild : (List)this.directChildrenCache.get((Object)cuboid)) {
            this.getAllDescendants(directChild, allDescendants);
        }
    }

    public ImmutableSet<Long> getAllCuboidsForSelection() {
        return this.selectionCuboidSet;
    }

    public ImmutableSet<Long> getAllCuboidsForMandatory() {
        return this.mandatoryCuboidSet;
    }

    public Long getCuboidQueryCost(long cuboid) {
        return (Long)this.cuboidScanCountMap.get((Object)cuboid);
    }

    public Long getCuboidCount(long cuboid) {
        return (Long)this.cuboidCountMap.get((Object)cuboid);
    }

    public Double getCuboidSize(long cuboid) {
        return (Double)this.cuboidSizeMap.get((Object)cuboid);
    }

    public double getCuboidHitProbability(long cuboid) {
        if (this.mandatoryCuboidSet.contains((Object)cuboid)) {
            return 1.0;
        }
        return this.cuboidHitProbabilityMap.get((Object)cuboid) == null ? 0.0 : (Double)this.cuboidHitProbabilityMap.get((Object)cuboid);
    }

    public Map<Long, Long> getStatistics() {
        return this.cuboidCountMap;
    }

    public double getBaseCuboidSize() {
        return this.getCuboidSize(this.baseCuboid);
    }

    public long getBaseCuboid() {
        return this.baseCuboid;
    }

    public String getKey() {
        return this.key;
    }

    public CuboidBenefitModel.CuboidModel getCuboidModel(long cuboid) {
        return new CuboidBenefitModel.CuboidModel(cuboid, this.getCuboidCount(cuboid), this.getCuboidSize(cuboid), this.getCuboidHitProbability(cuboid), this.getCuboidQueryCost(cuboid));
    }

    public static class Builder {
        private static final long THRESHOLD_ROLL_UP_FOR_MANDATORY = 1000L;
        private String key;
        private Long baseCuboid;
        private Map<Long, Long> statistics;
        private Map<Long, Double> size;
        private Set<Long> mandatoryCuboids = null;
        private Map<Long, Map<Long, Long>> rollingUpCountSourceMap = null;
        private Long rollUpThresholdForMandatory = null;
        private Map<Long, Long> hitFrequencyMap = null;
        private Map<Long, Map<Long, Long>> scanCountSourceMap = null;

        public Builder(String key, Long baseCuboid, Map<Long, Long> statistics, Map<Long, Double> size) {
            this.key = key;
            this.baseCuboid = baseCuboid;
            this.statistics = statistics;
            this.size = size;
        }

        public Builder setRollingUpCountSourceMap(Map<Long, Map<Long, Long>> rollingUpCountSourceMap) {
            this.rollingUpCountSourceMap = rollingUpCountSourceMap;
            this.rollUpThresholdForMandatory = 1000L;
            return this;
        }

        public Builder setRollingUpCountSourceMap(Map<Long, Map<Long, Long>> rollingUpCountSourceMap, long rollUpThresholdForMandatory) {
            this.rollingUpCountSourceMap = rollingUpCountSourceMap;
            this.rollUpThresholdForMandatory = rollUpThresholdForMandatory;
            return this;
        }

        public Builder setMandatoryCuboids(Set<Long> mandatoryCuboids) {
            this.mandatoryCuboids = mandatoryCuboids;
            return this;
        }

        public Builder setHitFrequencyMap(Map<Long, Long> hitFrequencyMap) {
            this.hitFrequencyMap = hitFrequencyMap;
            return this;
        }

        public Builder setScanCountSourceMap(Map<Long, Map<Long, Long>> scanCountSourceMap) {
            this.scanCountSourceMap = scanCountSourceMap;
            return this;
        }

        public CuboidStats build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"key should not be null");
            Preconditions.checkNotNull((Object)this.baseCuboid, (Object)"baseCuboid should not be null");
            Preconditions.checkNotNull(this.statistics, (Object)"statistics should not be null");
            Preconditions.checkNotNull(this.size, (Object)"size should not be null");
            Preconditions.checkNotNull((Object)this.statistics.get(this.baseCuboid), (Object)("row count should exist for base cuboid " + this.baseCuboid));
            Preconditions.checkState((boolean)this.statistics.keySet().equals(this.size.keySet()), (Object)"statistics & size should own the same key set");
            if (this.mandatoryCuboids == null) {
                this.mandatoryCuboids = Sets.newHashSet();
            }
            if (this.rollingUpCountSourceMap != null) {
                this.mandatoryCuboids.addAll(CuboidStatsUtil.generateMandatoryCuboidSet(this.statistics, this.hitFrequencyMap, this.rollingUpCountSourceMap, this.rollUpThresholdForMandatory));
            }
            return new CuboidStats(this.key, this.baseCuboid, this.mandatoryCuboids, this.statistics, this.size, this.hitFrequencyMap, this.scanCountSourceMap);
        }
    }
}

