/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.CuboidManager;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.gridtable.CuboidToGridTableMapping;
import org.apache.kylin.cube.model.AggregationGroup;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class Cuboid
implements Comparable<Cuboid>,
Serializable {
    public static final Comparator<Long> cuboidSelectComparator = new Comparator<Long>(){

        @Override
        public int compare(Long o1, Long o2) {
            return ComparisonChain.start().compare(Long.bitCount(o1), Long.bitCount(o2)).compare((Comparable)o1, (Comparable)o2).result();
        }
    };
    private CubeDesc cubeDesc;
    private final long inputID;
    private final long id;
    private final byte[] idBytes;
    private final boolean requirePostAggregation;
    private List<TblColRef> dimensionColumns;
    private volatile CuboidToGridTableMapping cuboidToGridTableMapping = null;

    public static Cuboid findForMandatory(CubeDesc cube, long cuboidID) {
        return new Cuboid(cube, cuboidID, cuboidID);
    }

    public static Cuboid findCuboid(CuboidScheduler cuboidScheduler, Set<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        long cuboidID = Cuboid.toCuboidId(cuboidScheduler.getCubeDesc(), dimensions, metrics);
        return Cuboid.findById(cuboidScheduler, cuboidID);
    }

    public static Cuboid findById(CuboidScheduler cuboidScheduler, byte[] cuboidID) {
        return Cuboid.findById(cuboidScheduler, Bytes.toLong(cuboidID));
    }

    @Deprecated
    public static Cuboid findById(CubeSegment cubeSegment, long cuboidID) {
        return Cuboid.findById(cubeSegment.getCuboidScheduler(), cuboidID);
    }

    @VisibleForTesting
    static Cuboid findById(CubeDesc cubeDesc, long cuboidID) {
        return Cuboid.findById(cubeDesc.getInitialCuboidScheduler(), cuboidID);
    }

    public static Cuboid findById(CuboidScheduler cuboidScheduler, long cuboidID) {
        KylinConfig config = cuboidScheduler.getCubeDesc().getConfig();
        return CuboidManager.getInstance(config).findById(cuboidScheduler, cuboidID);
    }

    public static void clearCache(CubeInstance cubeInstance) {
        KylinConfig config = cubeInstance.getConfig();
        CuboidManager.getInstance(config).clearCache(cubeInstance);
    }

    public static long toCuboidId(CubeDesc cubeDesc, Set<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        for (FunctionDesc metric : metrics) {
            if (!metric.getMeasureType().onlyAggrInBaseCuboid()) continue;
            return Cuboid.getBaseCuboidId(cubeDesc);
        }
        long cuboidID = 0L;
        for (TblColRef column : dimensions) {
            int index = cubeDesc.getRowkey().getColumnBitIndex(column);
            cuboidID |= 1L << index;
        }
        return cuboidID;
    }

    public static long getBaseCuboidId(CubeDesc cube) {
        return cube.getRowkey().getFullMask();
    }

    public static Cuboid getBaseCuboid(CubeDesc cube) {
        return Cuboid.findById(cube.getInitialCuboidScheduler(), Cuboid.getBaseCuboidId(cube));
    }

    public Cuboid(CubeDesc cubeDesc, long originalID, long validID) {
        this.cubeDesc = cubeDesc;
        this.inputID = originalID;
        this.id = validID;
        this.idBytes = Bytes.toBytes(this.id);
        this.dimensionColumns = this.translateIdToColumns(this.id);
        this.requirePostAggregation = this.calcExtraAggregation(this.inputID, this.id) != 0L;
    }

    private List<TblColRef> translateIdToColumns(long cuboidID) {
        ArrayList<TblColRef> dimesnions = new ArrayList<TblColRef>();
        RowKeyColDesc[] allColumns = this.cubeDesc.getRowkey().getRowKeyColumns();
        for (int i = 0; i < allColumns.length; ++i) {
            long bitmask = 1L << allColumns[i].getBitIndex();
            if ((cuboidID & bitmask) == 0L) continue;
            TblColRef colRef = allColumns[i].getColRef();
            dimesnions.add(colRef);
        }
        return dimesnions;
    }

    private long calcExtraAggregation(long inputID, long id) {
        long diff = id ^ inputID;
        return this.eliminateHierarchyAggregation(diff);
    }

    private long eliminateHierarchyAggregation(long id) {
        long finalId = id;
        for (AggregationGroup agg : this.cubeDesc.getAggregationGroups()) {
            long temp = id;
            List<AggregationGroup.HierarchyMask> hierarchyMaskList = agg.getHierarchyMasks();
            if (hierarchyMaskList == null || hierarchyMaskList.size() <= 0) continue;
            for (AggregationGroup.HierarchyMask hierMask : hierarchyMaskList) {
                long[] allMasks = hierMask.allMasks;
                for (int i = allMasks.length - 1; i > 0; --i) {
                    long bit = allMasks[i] ^ allMasks[i - 1];
                    if ((this.inputID & bit) == 0L || (temp &= allMasks[i - 1] ^ 0xFFFFFFFFFFFFFFFFL) >= finalId) continue;
                    finalId = temp;
                }
            }
        }
        return finalId;
    }

    public CubeDesc getCubeDesc() {
        return this.cubeDesc;
    }

    public List<TblColRef> getColumns() {
        return this.dimensionColumns;
    }

    public List<TblColRef> getAggregationColumns() {
        long aggrColsID = this.eliminateHierarchyAggregation(this.id);
        return this.translateIdToColumns(aggrColsID);
    }

    public long getId() {
        return this.id;
    }

    public byte[] getBytes() {
        return this.idBytes;
    }

    public long getInputID() {
        return this.inputID;
    }

    public boolean requirePostAggregation() {
        return this.requirePostAggregation;
    }

    public String toString() {
        return "Cuboid [id=" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cuboid other = (Cuboid)obj;
        return this.id == other.id;
    }

    @Override
    public int compareTo(Cuboid o) {
        if (this.id < o.id) {
            return -1;
        }
        if (this.id > o.id) {
            return 1;
        }
        return 0;
    }

    public CuboidToGridTableMapping getCuboidToGridTableMapping() {
        if (this.cuboidToGridTableMapping == null) {
            this.cuboidToGridTableMapping = new CuboidToGridTableMapping(this);
        }
        return this.cuboidToGridTableMapping;
    }

    public static String getDisplayName(long cuboidID, int dimensionCount) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dimensionCount; ++i) {
            if ((cuboidID & 1L << i) == 0L) {
                sb.append('0');
                continue;
            }
            sb.append('1');
        }
        return StringUtils.reverse((String)sb.toString());
    }
}

