/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.common;

import java.io.Serializable;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.SplittedBytes;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.kv.RowKeyColumnIO;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.RowKeyColDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class RowKeySplitter
implements Serializable {
    private CubeSegment cubeSegment;
    private CubeDesc cubeDesc;
    private RowKeyColumnIO colIO;
    private SplittedBytes[] splitBuffers;
    private int[] splitOffsets;
    private int bufferSize;
    private boolean enableSharding;
    private short shardId;

    public SplittedBytes[] getSplitBuffers() {
        return this.splitBuffers;
    }

    public int[] getSplitOffsets() {
        return this.splitOffsets;
    }

    public int getBodySplitOffset() {
        if (this.enableSharding) {
            return 2;
        }
        return 1;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public RowKeySplitter(CubeSegment cubeSeg) {
        this(cubeSeg, cubeSeg.getCubeDesc().getRowkey().getRowKeyColumns().length + 2, cubeSeg.getConfig().getDimensionEncodingMaxLength());
    }

    public RowKeySplitter(CubeSegment cubeSeg, int splitLen, int bytesLen) {
        this.cubeSegment = cubeSeg;
        this.enableSharding = cubeSeg.isEnableSharding();
        this.cubeDesc = cubeSeg.getCubeDesc();
        CubeDimEncMap dimEncoding = new CubeDimEncMap(cubeSeg);
        for (RowKeyColDesc rowKeyColDesc : this.cubeDesc.getRowkey().getRowKeyColumns()) {
            dimEncoding.get(rowKeyColDesc.getColRef());
        }
        this.colIO = new RowKeyColumnIO(dimEncoding);
        this.splitBuffers = new SplittedBytes[splitLen];
        this.splitOffsets = new int[splitLen];
        for (int i = 0; i < splitLen; ++i) {
            this.splitBuffers[i] = new SplittedBytes(bytesLen);
        }
        this.bufferSize = 0;
    }

    public Short getShardId() {
        if (this.enableSharding) {
            return this.shardId;
        }
        return null;
    }

    public long split(byte[] bytes) {
        this.bufferSize = 0;
        int offset = 0;
        if (this.enableSharding) {
            SplittedBytes shardSplit = this.splitBuffers[this.bufferSize++];
            shardSplit.length = 2;
            System.arraycopy(bytes, offset, shardSplit.value, 0, 2);
            offset += 2;
            this.shardId = Bytes.toShort(shardSplit.value);
        }
        SplittedBytes cuboidIdSplit = this.splitBuffers[this.bufferSize++];
        cuboidIdSplit.length = 8;
        System.arraycopy(bytes, offset, cuboidIdSplit.value, 0, 8);
        offset += 8;
        long lastSplittedCuboidId = Bytes.toLong(cuboidIdSplit.value, 0, cuboidIdSplit.length);
        Cuboid cuboid = Cuboid.findForMandatory(this.cubeDesc, lastSplittedCuboidId);
        for (int i = 0; i < cuboid.getColumns().size(); ++i) {
            this.splitOffsets[i] = offset;
            TblColRef col = cuboid.getColumns().get(i);
            int colLength = this.colIO.getColumnLength(col);
            SplittedBytes split = this.splitBuffers[this.bufferSize++];
            split.length = colLength;
            System.arraycopy(bytes, offset, split.value, 0, colLength);
            offset += colLength;
        }
        return lastSplittedCuboidId;
    }
}

