/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceTool {
    private static String[] includes = null;
    private static String[] excludes = null;
    private static final TreeSet<String> pathsSkipChildrenCheck = new TreeSet();
    private static final Logger logger = LoggerFactory.getLogger(ResourceTool.class);
    private static final Set<String> IMMUTABLE_PREFIX = Sets.newHashSet((Object[])new String[]{"/UUID"});
    private static final List<String> SKIP_CHILDREN_CHECK_RESOURCE_ROOT = Lists.newArrayList((Object[])new String[]{"/execute", "/execute_output"});

    public static void main(String[] args) throws IOException {
        String cmd;
        String exclude;
        if ((args = StringUtil.filterSystemArgs(args)).length == 0) {
            System.out.println("Usage: ResourceTool list  RESOURCE_PATH");
            System.out.println("Usage: ResourceTool download  LOCAL_DIR");
            System.out.println("Usage: ResourceTool upload    LOCAL_DIR");
            System.out.println("Usage: ResourceTool reset");
            System.out.println("Usage: ResourceTool remove RESOURCE_PATH");
            System.out.println("Usage: ResourceTool cat RESOURCE_PATH");
            return;
        }
        String include = System.getProperty("include");
        if (include != null) {
            ResourceTool.addIncludes(include.split("\\s*,\\s*"));
        }
        if ((exclude = System.getProperty("exclude")) != null) {
            ResourceTool.addExcludes(exclude.split("\\s*,\\s*"));
        }
        ResourceTool.addExcludes(IMMUTABLE_PREFIX.toArray(new String[IMMUTABLE_PREFIX.size()]));
        switch (cmd = args[0]) {
            case "reset": {
                ResourceTool.reset(args.length == 1 ? KylinConfig.getInstanceFromEnv() : KylinConfig.createInstanceFromUri(args[1]));
                break;
            }
            case "list": {
                ResourceTool.list(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "download": {
                ResourceTool.copy(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]), true);
                break;
            }
            case "fetch": {
                ResourceTool.copy(KylinConfig.getInstanceFromEnv(), KylinConfig.createInstanceFromUri(args[1]), args[2], true);
                break;
            }
            case "upload": {
                ResourceTool.copy(KylinConfig.createInstanceFromUri(args[1]), KylinConfig.getInstanceFromEnv());
                break;
            }
            case "remove": {
                ResourceTool.remove(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            case "cat": {
                ResourceTool.cat(KylinConfig.getInstanceFromEnv(), args[1]);
                break;
            }
            default: {
                System.out.println("Unknown cmd: " + cmd);
            }
        }
    }

    public static String[] getIncludes() {
        return includes;
    }

    public static void addIncludes(String[] arg) {
        if (arg != null) {
            if (includes != null) {
                String[] nIncludes = new String[includes.length + arg.length];
                System.arraycopy(includes, 0, nIncludes, 0, includes.length);
                System.arraycopy(arg, 0, nIncludes, includes.length, arg.length);
                includes = nIncludes;
            } else {
                includes = arg;
            }
        }
    }

    public static String[] getExcludes() {
        return excludes;
    }

    public static void addExcludes(String[] arg) {
        if (arg != null) {
            if (excludes != null) {
                String[] nExcludes = new String[excludes.length + arg.length];
                System.arraycopy(excludes, 0, nExcludes, 0, excludes.length);
                System.arraycopy(arg, 0, nExcludes, excludes.length, arg.length);
                excludes = nExcludes;
            } else {
                excludes = arg;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String cat(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        InputStream is = store.getResource((String)path).inputStream;
        BufferedReader br = null;
        StringBuffer sb = new StringBuffer();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(is));
            while ((line = br.readLine()) != null) {
                System.out.println(line);
                sb.append(line).append('\n');
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly(br);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((Reader)br);
        return sb.toString();
    }

    public static NavigableSet<String> list(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        NavigableSet<String> result = store.listResources(path);
        System.out.println("" + result);
        return result;
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, String path) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, path, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, String path, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        for (String resourceRoot : SKIP_CHILDREN_CHECK_RESOURCE_ROOT) {
            NavigableSet<String> all = src.listResourcesRecursively(resourceRoot);
            if (all == null) continue;
            pathsSkipChildrenCheck.addAll(src.listResourcesRecursively(resourceRoot));
        }
        ResourceTool.copyR(src, dst, path, copyImmutableResource);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, paths, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, List<String> paths, boolean copyImmutableResource) throws IOException {
        ResourceStore src = ResourceStore.getStore(srcConfig);
        ResourceStore dst = ResourceStore.getStore(dstConfig);
        logger.info("Copy from {} to {}", (Object)src, (Object)dst);
        for (String path : paths) {
            ResourceTool.copyR(src, dst, path, copyImmutableResource);
        }
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, false);
    }

    public static void copy(KylinConfig srcConfig, KylinConfig dstConfig, boolean copyImmutableResource) throws IOException {
        ResourceTool.copy(srcConfig, dstConfig, "/", copyImmutableResource);
    }

    public static void copyR(ResourceStore src, ResourceStore dst, String path, boolean copyImmutableResource) throws IOException {
        block9: {
            if (!copyImmutableResource && IMMUTABLE_PREFIX.contains(path)) {
                return;
            }
            NavigableSet<String> children = null;
            if (!pathsSkipChildrenCheck.contains(path)) {
                children = src.listResources(path);
            }
            if (children == null) {
                if (ResourceTool.matchFilter(path)) {
                    try {
                        RawResource res = src.getResource(path);
                        if (res != null) {
                            dst.putResource(path, res.inputStream, res.timestamp);
                            res.inputStream.close();
                            break block9;
                        }
                        System.out.println("Resource not exist for " + path);
                    }
                    catch (Exception ex) {
                        System.err.println("Failed to open " + path);
                        logger.error(ex.getLocalizedMessage(), (Throwable)ex);
                    }
                }
            } else {
                for (String child : children) {
                    ResourceTool.copyR(src, dst, child, copyImmutableResource);
                }
            }
        }
    }

    private static boolean matchFilter(String path) {
        if (includes != null) {
            boolean in = false;
            for (String include : includes) {
                in = in || path.startsWith(include);
            }
            if (!in) {
                return false;
            }
        }
        if (excludes != null) {
            for (String exclude : excludes) {
                if (!path.startsWith(exclude)) continue;
                return false;
            }
        }
        return true;
    }

    public static void reset(KylinConfig config) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        ResourceTool.resetR(store, "/");
    }

    public static void resetR(ResourceStore store, String path) throws IOException {
        NavigableSet<String> children = store.listResources(path);
        if (children == null) {
            if (ResourceTool.matchFilter(path)) {
                store.deleteResource(path);
            }
        } else {
            for (String child : children) {
                ResourceTool.resetR(store, child);
            }
        }
    }

    private static void remove(KylinConfig config, String path) throws IOException {
        ResourceStore store = ResourceStore.getStore(config);
        ResourceTool.resetR(store, path);
    }
}

