/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.WriteConflictException;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceStore {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStore.class);
    public static final String CUBE_RESOURCE_ROOT = "/cube";
    public static final String CUBE_DESC_RESOURCE_ROOT = "/cube_desc";
    public static final String DATA_MODEL_DESC_RESOURCE_ROOT = "/model_desc";
    public static final String DICT_RESOURCE_ROOT = "/dict";
    public static final String PROJECT_RESOURCE_ROOT = "/project";
    public static final String SNAPSHOT_RESOURCE_ROOT = "/table_snapshot";
    public static final String TABLE_EXD_RESOURCE_ROOT = "/table_exd";
    public static final String TEMP_STATMENT_RESOURCE_ROOT = "/temp_statement";
    public static final String TABLE_RESOURCE_ROOT = "/table";
    public static final String EXTERNAL_FILTER_RESOURCE_ROOT = "/ext_filter";
    public static final String HYBRID_RESOURCE_ROOT = "/hybrid";
    public static final String EXECUTE_RESOURCE_ROOT = "/execute";
    public static final String EXECUTE_OUTPUT_RESOURCE_ROOT = "/execute_output";
    public static final String STREAMING_RESOURCE_ROOT = "/streaming";
    public static final String KAFKA_RESOURCE_ROOT = "/kafka";
    public static final String STREAMING_OUTPUT_RESOURCE_ROOT = "/streaming_output";
    public static final String CUBE_STATISTICS_ROOT = "/cube_statistics";
    public static final String BAD_QUERY_RESOURCE_ROOT = "/bad_query";
    public static final String DRAFT_RESOURCE_ROOT = "/draft";
    public static final String USER_ROOT = "/user";
    public static final String EXT_SNAPSHOT_RESOURCE_ROOT = "/ext_table_snapshot";
    public static final String METASTORE_UUID_TAG = "/UUID";
    private static final ConcurrentMap<KylinConfig, ResourceStore> CACHE = new ConcurrentHashMap<KylinConfig, ResourceStore>();
    protected final KylinConfig kylinConfig;
    ThreadLocal<Checkpoint> checkpointing = new ThreadLocal();

    private static ResourceStore createResourceStore(KylinConfig kylinConfig) {
        StorageURL metadataUrl = kylinConfig.getMetadataUrl();
        logger.info("Using metadata url " + metadataUrl + " for resource store");
        String clsName = kylinConfig.getResourceStoreImpls().get(metadataUrl.getScheme());
        try {
            Class<ResourceStore> cls = ClassUtil.forName(clsName, ResourceStore.class);
            ResourceStore store = cls.getConstructor(KylinConfig.class).newInstance(kylinConfig);
            if (!store.exists(METASTORE_UUID_TAG)) {
                store.putResource(METASTORE_UUID_TAG, new StringEntity(store.createMetaStoreUUID()), 0L, StringEntity.serializer);
            }
            return store;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to find metadata store by url: " + metadataUrl, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceStore getStore(KylinConfig kylinConfig) {
        if (CACHE.containsKey(kylinConfig)) {
            return (ResourceStore)CACHE.get(kylinConfig);
        }
        Class<ResourceStore> clazz = ResourceStore.class;
        synchronized (ResourceStore.class) {
            if (CACHE.containsKey(kylinConfig)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return (ResourceStore)CACHE.get(kylinConfig);
            }
            CACHE.putIfAbsent(kylinConfig, ResourceStore.createResourceStore(kylinConfig));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (ResourceStore)CACHE.get(kylinConfig);
        }
    }

    protected ResourceStore(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public final KylinConfig getConfig() {
        return this.kylinConfig;
    }

    public final NavigableSet<String> listResources(String folderPath) throws IOException {
        String path = this.norm(folderPath);
        return this.listResourcesImpl(path, false);
    }

    public final NavigableSet<String> listResourcesRecursively(String folderPath) throws IOException {
        String path = this.norm(folderPath);
        return this.listResourcesImpl(path, true);
    }

    protected abstract NavigableSet<String> listResourcesImpl(String var1, boolean var2) throws IOException;

    protected String createMetaStoreUUID() throws IOException {
        return UUID.randomUUID().toString();
    }

    public String getMetaStoreUUID() throws IOException {
        if (!this.exists(METASTORE_UUID_TAG)) {
            this.putResource(METASTORE_UUID_TAG, new StringEntity(this.createMetaStoreUUID()), 0L, StringEntity.serializer);
        }
        StringEntity entity = this.getResource(METASTORE_UUID_TAG, StringEntity.class, StringEntity.serializer);
        return entity.toString();
    }

    public final boolean exists(String resPath) throws IOException {
        return this.existsImpl(this.norm(resPath));
    }

    protected abstract boolean existsImpl(String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RootPersistentEntity> T getResource(String resPath, Class<T> clz, Serializer<T> serializer) throws IOException {
        RawResource res = this.getResourceImpl(resPath = this.norm(resPath));
        if (res == null) {
            return null;
        }
        DataInputStream din = new DataInputStream(res.inputStream);
        try {
            T r = serializer.deserialize(din);
            ((RootPersistentEntity)r).setLastModified(res.timestamp);
            T t = r;
            return t;
        }
        finally {
            IOUtils.closeQuietly((InputStream)din);
            IOUtils.closeQuietly((InputStream)res.inputStream);
        }
    }

    public final RawResource getResource(String resPath) throws IOException {
        return this.getResourceImpl(this.norm(resPath));
    }

    public final long getResourceTimestamp(String resPath) throws IOException {
        return this.getResourceTimestampImpl(this.norm(resPath));
    }

    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, Class<T> clazz, Serializer<T> serializer) throws IOException {
        return this.getAllResources(folderPath, Long.MIN_VALUE, Long.MAX_VALUE, clazz, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends RootPersistentEntity> List<T> getAllResources(String folderPath, long timeStart, long timeEndExclusive, Class<T> clazz, Serializer<T> serializer) throws IOException {
        ArrayList arrayList;
        List<RawResource> allResources = this.getAllResourcesImpl(folderPath, timeStart, timeEndExclusive);
        if (allResources == null || allResources.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)allResources.size());
        try {
            for (RawResource rawResource : allResources) {
                T element = serializer.deserialize(new DataInputStream(rawResource.inputStream));
                ((RootPersistentEntity)element).setLastModified(rawResource.timestamp);
                result.add(element);
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            for (RawResource rawResource : allResources) {
                if (rawResource == null) continue;
                IOUtils.closeQuietly((InputStream)rawResource.inputStream);
            }
            throw throwable;
        }
        for (RawResource rawResource : allResources) {
            if (rawResource == null) continue;
            IOUtils.closeQuietly((InputStream)rawResource.inputStream);
        }
        return arrayList;
    }

    protected abstract List<RawResource> getAllResourcesImpl(String var1, long var2, long var4) throws IOException;

    protected abstract RawResource getResourceImpl(String var1) throws IOException;

    protected abstract long getResourceTimestampImpl(String var1) throws IOException;

    public final <T extends RootPersistentEntity> void putResourceWithoutCheck(String resPath, T obj, long ts, Serializer<T> serializer) throws IOException {
        resPath = this.norm(resPath);
        logger.trace("Directly saving resource " + resPath + " (Store " + this.kylinConfig.getMetadataUrl() + ")");
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        serializer.serialize(obj, dout);
        dout.close();
        buf.close();
        ByteArrayInputStream is = new ByteArrayInputStream(buf.toByteArray());
        this.putResourceCheckpoint(resPath, is, ts);
        is.close();
    }

    public final void putResource(String resPath, InputStream content, long ts) throws IOException {
        resPath = this.norm(resPath);
        logger.trace("Directly saving resource " + resPath + " (Store " + this.kylinConfig.getMetadataUrl() + ")");
        this.putResourceCheckpoint(resPath, content, ts);
    }

    private void putResourceCheckpoint(String resPath, InputStream content, long ts) throws IOException {
        this.beforeChange(resPath);
        this.putResourceImpl(resPath, content, ts);
    }

    protected abstract void putResourceImpl(String var1, InputStream var2, long var3) throws IOException;

    public final <T extends RootPersistentEntity> long putResource(String resPath, T obj, Serializer<T> serializer) throws IOException, WriteConflictException {
        return this.putResource(resPath, obj, System.currentTimeMillis(), serializer);
    }

    public final <T extends RootPersistentEntity> long putResource(String resPath, T obj, long newTS, Serializer<T> serializer) throws IOException, WriteConflictException {
        resPath = this.norm(resPath);
        long oldTS = obj.getLastModified();
        obj.setLastModified(newTS);
        try {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(buf);
            serializer.serialize(obj, dout);
            dout.close();
            buf.close();
            newTS = this.checkAndPutResourceCheckpoint(resPath, buf.toByteArray(), oldTS, newTS);
            obj.setLastModified(newTS);
            return newTS;
        }
        catch (IOException e) {
            obj.setLastModified(oldTS);
            throw e;
        }
        catch (RuntimeException e) {
            obj.setLastModified(oldTS);
            throw e;
        }
    }

    private long checkAndPutResourceCheckpoint(String resPath, byte[] content, long oldTS, long newTS) throws IOException, WriteConflictException {
        this.beforeChange(resPath);
        return this.checkAndPutResourceImpl(resPath, content, oldTS, newTS);
    }

    protected abstract long checkAndPutResourceImpl(String var1, byte[] var2, long var3, long var5) throws IOException, WriteConflictException;

    public final void deleteResource(String resPath) throws IOException {
        logger.trace("Deleting resource " + resPath + " (Store " + this.kylinConfig.getMetadataUrl() + ")");
        this.deleteResourceCheckpoint(this.norm(resPath));
    }

    private void deleteResourceCheckpoint(String resPath) throws IOException {
        this.beforeChange(resPath);
        this.deleteResourceImpl(resPath);
    }

    protected abstract void deleteResourceImpl(String var1) throws IOException;

    public final String getReadableResourcePath(String resPath) {
        return this.getReadableResourcePathImpl(this.norm(resPath));
    }

    protected abstract String getReadableResourcePathImpl(String var1);

    private String norm(String resPath) {
        resPath = resPath.trim();
        while (resPath.startsWith("//")) {
            resPath = resPath.substring(1);
        }
        while (resPath.endsWith("/")) {
            resPath = resPath.substring(0, resPath.length() - 1);
        }
        if (!resPath.startsWith("/")) {
            resPath = "/" + resPath;
        }
        return resPath;
    }

    public Checkpoint checkpoint() {
        Checkpoint cp = this.checkpointing.get();
        if (cp != null) {
            throw new IllegalStateException("A checkpoint has been open for this thread: " + cp);
        }
        cp = new Checkpoint();
        this.checkpointing.set(cp);
        return cp;
    }

    private void beforeChange(String resPath) throws IOException {
        Checkpoint cp = this.checkpointing.get();
        if (cp != null) {
            cp.beforeChange(resPath);
        }
    }

    public void scanRecursively(String path, Visitor visitor) throws IOException {
        NavigableSet<String> children = this.listResources(path);
        if (children != null) {
            for (String child : children) {
                this.scanRecursively(child, visitor);
            }
            return;
        }
        if (this.exists(path)) {
            visitor.visit(path);
        }
    }

    public List<String> collectResourceRecursively(String root, final String suffix) throws IOException {
        final ArrayList collector = Lists.newArrayList();
        this.scanRecursively(root, new Visitor(){

            @Override
            public void visit(String path) {
                if (path.endsWith(suffix)) {
                    collector.add(path);
                }
            }
        });
        return collector;
    }

    public static String dumpResources(KylinConfig kylinConfig, Collection<String> dumpList) throws IOException {
        File tmp = File.createTempFile("kylin_job_meta", "");
        FileUtils.forceDelete((File)tmp);
        File metaDir = new File(tmp, "meta");
        metaDir.mkdirs();
        File kylinPropsFile = new File(metaDir, "kylin.properties");
        kylinConfig.exportToFile(kylinPropsFile);
        ResourceStore from = ResourceStore.getStore(kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri(metaDir.getAbsolutePath());
        ResourceStore to = ResourceStore.getStore(localConfig);
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.inputStream, res.timestamp);
            res.inputStream.close();
        }
        String metaDirURI = OptionsHelper.convertToFileURL(metaDir.getAbsolutePath());
        metaDirURI = metaDirURI.startsWith("/") ? "file://" + metaDirURI : "file:///" + metaDirURI;
        logger.info("meta dir is: " + metaDirURI);
        return metaDirURI;
    }

    public static interface Visitor {
        public void visit(String var1) throws IOException;
    }

    public class Checkpoint
    implements Closeable {
        LinkedHashMap<String, byte[]> origResData = new LinkedHashMap();
        LinkedHashMap<String, Long> origResTimestamp = new LinkedHashMap();

        private void beforeChange(String resPath) throws IOException {
            if (this.origResData.containsKey(resPath)) {
                return;
            }
            RawResource raw = ResourceStore.this.getResourceImpl(resPath);
            if (raw == null) {
                this.origResData.put(resPath, null);
                this.origResTimestamp.put(resPath, null);
            } else {
                this.origResData.put(resPath, this.readAll(raw.inputStream));
                this.origResTimestamp.put(resPath, raw.timestamp);
            }
        }

        private byte[] readAll(InputStream inputStream) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)inputStream, (OutputStream)out);
            inputStream.close();
            out.close();
            return out.toByteArray();
        }

        public void rollback() {
            this.checkThread();
            for (String resPath : this.origResData.keySet()) {
                logger.debug("Rollbacking " + resPath);
                try {
                    byte[] data = this.origResData.get(resPath);
                    Long ts = this.origResTimestamp.get(resPath);
                    if (data == null || ts == null) {
                        ResourceStore.this.deleteResourceImpl(resPath);
                        continue;
                    }
                    ResourceStore.this.putResourceImpl(resPath, new ByteArrayInputStream(data), ts);
                }
                catch (IOException ex) {
                    logger.error("Failed to rollback " + resPath, (Throwable)ex);
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.checkThread();
            this.origResData = null;
            this.origResTimestamp = null;
            ResourceStore.this.checkpointing.set(null);
        }

        private void checkThread() {
            Checkpoint cp = ResourceStore.this.checkpointing.get();
            if (this != cp) {
                throw new IllegalStateException();
            }
        }
    }
}

