/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kylin.common.exceptions.KylinTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContext {
    private static final Logger logger = LoggerFactory.getLogger(QueryContext.class);
    private long queryStartMillis;
    private final String queryId;
    private String username;
    private Set<String> groups;
    private AtomicLong scannedRows = new AtomicLong();
    private AtomicLong returnedRows = new AtomicLong();
    private AtomicLong scannedBytes = new AtomicLong();
    private Object calcitePlan;
    private AtomicBoolean isRunning = new AtomicBoolean(true);
    private volatile Throwable throwable;
    private String stopReason;
    private List<QueryStopListener> stopListeners = Lists.newCopyOnWriteArrayList();
    private List<RPCStatistics> rpcStatisticsList = Lists.newCopyOnWriteArrayList();
    private Map<Integer, CubeSegmentStatisticsResult> cubeSegmentStatisticsResultMap = Maps.newConcurrentMap();

    QueryContext() {
        this(System.currentTimeMillis());
    }

    QueryContext(long startMills) {
        this.queryId = UUID.randomUUID().toString();
        this.queryStartMillis = startMills;
    }

    public long getQueryStartMillis() {
        return this.queryStartMillis;
    }

    public void checkMillisBeforeDeadline() {
        if (Thread.interrupted()) {
            throw new KylinTimeoutException("Query timeout");
        }
    }

    public String getQueryId() {
        return this.queryId == null ? "" : this.queryId;
    }

    public long getAccumulatedMillis() {
        return System.currentTimeMillis() - this.queryStartMillis;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public Object getCalcitePlan() {
        return this.calcitePlan;
    }

    public void setCalcitePlan(Object calcitePlan) {
        this.calcitePlan = calcitePlan;
    }

    public long getScannedRows() {
        return this.scannedRows.get();
    }

    public long addAndGetScannedRows(long deltaRows) {
        return this.scannedRows.addAndGet(deltaRows);
    }

    public long getReturnedRows() {
        return this.returnedRows.get();
    }

    public long addAndGetReturnedRows(long deltaRows) {
        return this.returnedRows.addAndGet(deltaRows);
    }

    public long getScannedBytes() {
        return this.scannedBytes.get();
    }

    public long addAndGetScannedBytes(long deltaBytes) {
        return this.scannedBytes.addAndGet(deltaBytes);
    }

    public void addQueryStopListener(QueryStopListener listener) {
        this.stopListeners.add(listener);
    }

    public boolean isStopped() {
        return !this.isRunning.get();
    }

    public String getStopReason() {
        return this.stopReason;
    }

    public void stop(Throwable t) {
        this.stopQuery(t, t.getMessage());
    }

    public void stopEarly(String reason) {
        this.stopQuery(null, reason);
    }

    private void stopQuery(Throwable t, String reason) {
        if (!this.isRunning.compareAndSet(true, false)) {
            return;
        }
        this.throwable = t;
        this.stopReason = reason;
        for (QueryStopListener stopListener : this.stopListeners) {
            stopListener.stop(this);
        }
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void addContext(int ctxId, String type, boolean ifCube) {
        ConcurrentMap cubeSegmentStatisticsMap = null;
        if (ifCube) {
            cubeSegmentStatisticsMap = Maps.newConcurrentMap();
        }
        this.cubeSegmentStatisticsResultMap.put(ctxId, new CubeSegmentStatisticsResult(type, cubeSegmentStatisticsMap));
    }

    public void setContextRealization(int ctxId, String realizationName, int realizationType) {
        CubeSegmentStatisticsResult cubeSegmentStatisticsResult = this.cubeSegmentStatisticsResultMap.get(ctxId);
        if (cubeSegmentStatisticsResult == null) {
            logger.warn("Cannot find CubeSegmentStatisticsResult for context " + ctxId);
            return;
        }
        cubeSegmentStatisticsResult.setRealization(realizationName);
        cubeSegmentStatisticsResult.setRealizationType(realizationType);
    }

    public List<RPCStatistics> getRpcStatisticsList() {
        return this.rpcStatisticsList;
    }

    public List<CubeSegmentStatisticsResult> getCubeSegmentStatisticsResultList() {
        return Lists.newArrayList(this.cubeSegmentStatisticsResultMap.values());
    }

    public void addRPCStatistics(int ctxId, String rpcServer, String cubeName, String segmentName, long sourceCuboidId, long targetCuboidId, long filterMask, Exception e, long rpcCallTimeMs, long skippedRows, long scannedRows, long returnedRows, long aggregatedRows, long scannedBytes) {
        CubeSegmentStatistics segmentStatistics;
        RPCStatistics rpcStatistics = new RPCStatistics();
        rpcStatistics.setWrapper(cubeName, rpcServer);
        rpcStatistics.setStats(rpcCallTimeMs, skippedRows, scannedRows, returnedRows, aggregatedRows, scannedBytes);
        rpcStatistics.setException(e);
        this.rpcStatisticsList.add(rpcStatistics);
        CubeSegmentStatisticsResult cubeSegmentStatisticsResult = this.cubeSegmentStatisticsResultMap.get(ctxId);
        if (cubeSegmentStatisticsResult == null) {
            logger.warn("CubeSegmentStatisticsResult should be initialized for context " + ctxId);
            return;
        }
        Map cubeSegmentStatisticsMap = cubeSegmentStatisticsResult.cubeSegmentStatisticsMap;
        if (cubeSegmentStatisticsMap == null) {
            logger.warn("cubeSegmentStatisticsMap should be initialized for CubeSegmentStatisticsResult with query type " + cubeSegmentStatisticsResult.queryType);
            return;
        }
        Map segmentStatisticsMap = (Map)cubeSegmentStatisticsMap.get(cubeName);
        if (segmentStatisticsMap == null) {
            segmentStatisticsMap = Maps.newConcurrentMap();
            cubeSegmentStatisticsMap.put(cubeName, segmentStatisticsMap);
        }
        if ((segmentStatistics = (CubeSegmentStatistics)segmentStatisticsMap.get(segmentName)) == null) {
            segmentStatistics = new CubeSegmentStatistics();
            segmentStatisticsMap.put(segmentName, segmentStatistics);
            segmentStatistics.setWrapper(cubeName, segmentName, sourceCuboidId, targetCuboidId, filterMask);
        }
        if (segmentStatistics.sourceCuboidId != sourceCuboidId || segmentStatistics.targetCuboidId != targetCuboidId || segmentStatistics.filterMask != filterMask) {
            StringBuilder inconsistency = new StringBuilder();
            if (segmentStatistics.sourceCuboidId != sourceCuboidId) {
                inconsistency.append("sourceCuboidId exist " + segmentStatistics.sourceCuboidId + " input " + sourceCuboidId);
            }
            if (segmentStatistics.targetCuboidId != targetCuboidId) {
                inconsistency.append("targetCuboidId exist " + segmentStatistics.targetCuboidId + " input " + targetCuboidId);
            }
            if (segmentStatistics.filterMask != filterMask) {
                inconsistency.append("filterMask exist " + segmentStatistics.filterMask + " input " + filterMask);
            }
            logger.error("cube segment statistics wrapper is not consistent due to " + inconsistency.toString());
            return;
        }
        segmentStatistics.addRPCStats(rpcCallTimeMs, skippedRows, scannedRows, returnedRows, aggregatedRows, scannedBytes, e == null);
    }

    public static class CubeSegmentStatisticsResult
    implements Serializable {
        protected static final long serialVersionUID = 1L;
        private String queryType;
        private Map<String, Map<String, CubeSegmentStatistics>> cubeSegmentStatisticsMap;
        private String realization;
        private int realizationType;

        public CubeSegmentStatisticsResult() {
        }

        public CubeSegmentStatisticsResult(String queryType, Map<String, Map<String, CubeSegmentStatistics>> cubeSegmentStatisticsMap) {
            this.queryType = queryType;
            this.cubeSegmentStatisticsMap = cubeSegmentStatisticsMap;
        }

        public void setRealization(String realization) {
            this.realization = realization;
        }

        public String getRealization() {
            return this.realization;
        }

        public int getRealizationType() {
            return this.realizationType;
        }

        public void setRealizationType(int realizationType) {
            this.realizationType = realizationType;
        }

        public void setQueryType(String queryType) {
            this.queryType = queryType;
        }

        public void setCubeSegmentStatisticsMap(Map<String, Map<String, CubeSegmentStatistics>> cubeSegmentStatisticsMap) {
            this.cubeSegmentStatisticsMap = cubeSegmentStatisticsMap;
        }

        public String getQueryType() {
            return this.queryType;
        }

        public Map<String, Map<String, CubeSegmentStatistics>> getCubeSegmentStatisticsMap() {
            return this.cubeSegmentStatisticsMap;
        }

        public String toString() {
            return "CubeSegmentStatisticsResult [queryType=" + this.queryType + ",realization=" + this.realization + ",realizationType=" + this.realizationType + ",cubeSegmentStatisticsMap=" + this.cubeSegmentStatisticsMap + "]";
        }
    }

    public static class CubeSegmentStatistics
    implements Serializable {
        protected static final long serialVersionUID = 1L;
        private String cubeName;
        private String segmentName;
        private long sourceCuboidId;
        private long targetCuboidId;
        private long filterMask;
        private boolean ifSuccess = true;
        private long callCount = 0L;
        private long callTimeSum = 0L;
        private long callTimeMax = 0L;
        private long storageSkippedRows = 0L;
        private long storageScannedRows = 0L;
        private long storageReturnedRows = 0L;
        private long storageAggregatedRows = 0L;
        private long storageScannedBytes = 0L;

        public void setWrapper(String cubeName, String segmentName, long sourceCuboidId, long targetCuboidId, long filterMask) {
            this.cubeName = cubeName;
            this.segmentName = segmentName;
            this.sourceCuboidId = sourceCuboidId;
            this.targetCuboidId = targetCuboidId;
            this.filterMask = filterMask;
        }

        public void addRPCStats(long callTimeMs, long skipCount, long scanCount, long returnCount, long aggrCount, long scanBytes, boolean ifSuccess) {
            ++this.callCount;
            this.callTimeSum += callTimeMs;
            if (this.callTimeMax < callTimeMs) {
                this.callTimeMax = callTimeMs;
            }
            this.storageSkippedRows += skipCount;
            this.storageScannedRows += scanCount;
            this.storageReturnedRows += returnCount;
            this.storageAggregatedRows += aggrCount;
            this.ifSuccess = this.ifSuccess && ifSuccess;
            this.storageScannedBytes += scanBytes;
        }

        public void setCubeName(String cubeName) {
            this.cubeName = cubeName;
        }

        public void setSegmentName(String segmentName) {
            this.segmentName = segmentName;
        }

        public void setSourceCuboidId(long sourceCuboidId) {
            this.sourceCuboidId = sourceCuboidId;
        }

        public void setTargetCuboidId(long targetCuboidId) {
            this.targetCuboidId = targetCuboidId;
        }

        public void setFilterMask(long filterMask) {
            this.filterMask = filterMask;
        }

        public void setIfSuccess(boolean ifSuccess) {
            this.ifSuccess = ifSuccess;
        }

        public void setCallCount(long callCount) {
            this.callCount = callCount;
        }

        public void setCallTimeSum(long callTimeSum) {
            this.callTimeSum = callTimeSum;
        }

        public void setCallTimeMax(long callTimeMax) {
            this.callTimeMax = callTimeMax;
        }

        public void setStorageSkippedRows(long storageSkippedRows) {
            this.storageSkippedRows = storageSkippedRows;
        }

        public void setStorageScannedRows(long storageScannedRows) {
            this.storageScannedRows = storageScannedRows;
        }

        public void setStorageReturnedRows(long storageReturnedRows) {
            this.storageReturnedRows = storageReturnedRows;
        }

        public void setStorageAggregatedRows(long storageAggregatedRows) {
            this.storageAggregatedRows = storageAggregatedRows;
        }

        public void setStorageScannedBytes(long storageScannedBytes) {
            this.storageScannedBytes = storageScannedBytes;
        }

        public String getCubeName() {
            return this.cubeName;
        }

        public long getStorageScannedBytes() {
            return this.storageScannedBytes;
        }

        public long getStorageAggregatedRows() {
            return this.storageAggregatedRows;
        }

        public long getStorageReturnedRows() {
            return this.storageReturnedRows;
        }

        public long getStorageSkippedRows() {
            return this.storageSkippedRows;
        }

        public long getStorageScannedRows() {
            return this.storageScannedRows;
        }

        public long getCallTimeMax() {
            return this.callTimeMax;
        }

        public long getCallTimeSum() {
            return this.callTimeSum;
        }

        public long getCallCount() {
            return this.callCount;
        }

        public boolean isIfSuccess() {
            return this.ifSuccess;
        }

        public long getFilterMask() {
            return this.filterMask;
        }

        public long getTargetCuboidId() {
            return this.targetCuboidId;
        }

        public long getSourceCuboidId() {
            return this.sourceCuboidId;
        }

        public String getSegmentName() {
            return this.segmentName;
        }

        public String toString() {
            return "CubeSegmentStatistics [cubeName=" + this.cubeName + ",segmentName=" + this.segmentName + ",sourceCuboidId=" + this.sourceCuboidId + ",targetCuboidId=" + this.targetCuboidId + ",filterMask=" + this.filterMask + "]";
        }
    }

    public static class RPCStatistics
    implements Serializable {
        protected static final long serialVersionUID = 1L;
        private String realizationName;
        private String rpcServer;
        private Exception exception;
        private long callTimeMs;
        private long skippedRows;
        private long scannedRows;
        private long returnedRows;
        private long aggregatedRows;
        private long scannedBytes;

        public void setWrapper(String realizationName, String rpcServer) {
            this.realizationName = realizationName;
            this.rpcServer = rpcServer;
        }

        public void setStats(long callTimeMs, long skipCount, long scanCount, long returnCount, long aggrCount, long scanBytes) {
            this.callTimeMs = callTimeMs;
            this.skippedRows = skipCount;
            this.scannedRows = scanCount;
            this.returnedRows = returnCount;
            this.aggregatedRows = aggrCount;
            this.scannedBytes = scanBytes;
        }

        public void setException(Exception e) {
            this.exception = e;
        }

        public String getRealizationName() {
            return this.realizationName;
        }

        public String getRpcServer() {
            return this.rpcServer;
        }

        public Exception getException() {
            return this.exception;
        }

        public long getCallTimeMs() {
            return this.callTimeMs;
        }

        public long getSkippedRows() {
            return this.skippedRows;
        }

        public void setRealizationName(String realizationName) {
            this.realizationName = realizationName;
        }

        public void setRpcServer(String rpcServer) {
            this.rpcServer = rpcServer;
        }

        public void setCallTimeMs(long callTimeMs) {
            this.callTimeMs = callTimeMs;
        }

        public void setSkippedRows(long skippedRows) {
            this.skippedRows = skippedRows;
        }

        public void setScannedRows(long scannedRows) {
            this.scannedRows = scannedRows;
        }

        public void setReturnedRows(long returnedRows) {
            this.returnedRows = returnedRows;
        }

        public void setAggregatedRows(long aggregatedRows) {
            this.aggregatedRows = aggregatedRows;
        }

        public void setScannedBytes(long scannedBytes) {
            this.scannedBytes = scannedBytes;
        }

        public long getScannedRows() {
            return this.scannedRows;
        }

        public long getReturnedRows() {
            return this.returnedRows;
        }

        public long getAggregatedRows() {
            return this.aggregatedRows;
        }

        public long getScannedBytes() {
            return this.scannedBytes;
        }

        public String toString() {
            return "RPCStatistics [rpcServer=" + this.rpcServer + ",realizationName=" + this.realizationName + "]";
        }
    }

    public static interface QueryStopListener {
        public void stop(QueryContext var1);
    }
}

