/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.measure.MeasureCodec;
import org.apache.kylin.metadata.datatype.DoubleMutable;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.storage.hbase.util.Results;

public class RowValueDecoder
implements Cloneable {
    private final HBaseColumnDesc hbaseColumn;
    private final byte[] hbaseColumnFamily;
    private final byte[] hbaseColumnQualifier;
    private final MeasureCodec codec;
    private final BitSet projectionIndex;
    private final MeasureDesc[] measures;
    private final Object[] values;

    public RowValueDecoder(HBaseColumnDesc hbaseColumn) {
        this.hbaseColumn = hbaseColumn;
        this.hbaseColumnFamily = Bytes.toBytes((String)hbaseColumn.getColumnFamilyName());
        this.hbaseColumnQualifier = Bytes.toBytes((String)hbaseColumn.getQualifier());
        this.projectionIndex = new BitSet();
        this.measures = hbaseColumn.getMeasures();
        this.codec = new MeasureCodec(this.measures);
        this.values = new Object[this.measures.length];
    }

    public void decodeAndConvertJavaObj(Result hbaseRow) {
        this.decode(hbaseRow, true);
    }

    public void decode(Result hbaseRow) {
        this.decode(hbaseRow, false);
    }

    private void decode(Result hbaseRow, boolean convertToJavaObject) {
        ByteBuffer buffer = Results.getValueAsByteBuffer(hbaseRow, this.hbaseColumnFamily, this.hbaseColumnQualifier);
        this.decode(buffer, convertToJavaObject);
    }

    public void decodeAndConvertJavaObj(byte[] bytes) {
        this.decode(ByteBuffer.wrap(bytes), true);
    }

    public void decode(byte[] bytes) {
        this.decode(ByteBuffer.wrap(bytes), false);
    }

    private void decode(ByteBuffer buffer, boolean convertToJavaObject) {
        this.codec.decode(buffer, this.values);
        if (convertToJavaObject) {
            this.convertToJavaObjects(this.values, this.values, convertToJavaObject);
        }
    }

    private void convertToJavaObjects(Object[] mapredObjs, Object[] results, boolean convertToJavaObject) {
        for (int i = 0; i < mapredObjs.length; ++i) {
            Object o = mapredObjs[i];
            if (o instanceof LongMutable) {
                o = ((LongMutable)o).get();
            } else if (o instanceof DoubleMutable) {
                o = ((DoubleMutable)o).get();
            }
            results[i] = o;
        }
    }

    public void setProjectIndex(int bitIndex) {
        this.projectionIndex.set(bitIndex);
    }

    public BitSet getProjectionIndex() {
        return this.projectionIndex;
    }

    public HBaseColumnDesc getHBaseColumn() {
        return this.hbaseColumn;
    }

    public Object[] getValues() {
        return this.values;
    }

    public MeasureDesc[] getMeasures() {
        return this.measures;
    }

    public void loadCubeMeasureArray(Object[] result) {
        int[] measureIndex = this.hbaseColumn.getMeasureIndex();
        for (int i = 0; i < measureIndex.length; ++i) {
            result[measureIndex[i]] = this.values[i];
        }
    }

    public boolean hasMemHungryMeasures() {
        int i = this.projectionIndex.nextSetBit(0);
        while (i >= 0) {
            FunctionDesc func = this.measures[i].getFunction();
            if (func.getMeasureType().isMemoryHungry()) {
                return true;
            }
            i = this.projectionIndex.nextSetBit(i + 1);
        }
        return false;
    }

    public static boolean hasMemHungryMeasures(Collection<RowValueDecoder> rowValueDecoders) {
        for (RowValueDecoder decoder : rowValueDecoders) {
            if (!decoder.hasMemHungryMeasures()) continue;
            return true;
        }
        return false;
    }
}

