/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.HiveCmdBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.job.engine.JobEngineConfig;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class StorageCleanupJob
extends AbstractApplication {
    protected static final Option OPTION_DELETE;
    protected static final Option OPTION_FORCE;
    protected static final Logger logger;
    public static final int deleteTimeout = 10;
    protected boolean delete = false;
    protected boolean force = false;
    protected static ExecutableManager executableManager;

    private void cleanUnusedHBaseTables(Configuration conf) throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)kylinConfig);
        Connection conn = HBaseConnection.get(kylinConfig.getStorageUrl());
        Admin hbaseAdmin = conn.getAdmin();
        String tableNamePrefix = kylinConfig.getHBaseTableNamePrefix();
        HTableDescriptor[] tableDescriptors = hbaseAdmin.listTables(tableNamePrefix + ".*");
        ArrayList<String> allTablesNeedToBeDropped = new ArrayList<String>();
        for (HTableDescriptor desc : tableDescriptors) {
            String host = desc.getValue("KYLIN_HOST");
            if (!kylinConfig.getMetadataUrlPrefix().equalsIgnoreCase(host)) continue;
            allTablesNeedToBeDropped.add(desc.getTableName().getNameAsString());
        }
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String tablename = seg.getStorageLocationIdentifier();
                if (!allTablesNeedToBeDropped.contains(tablename)) continue;
                allTablesNeedToBeDropped.remove(tablename);
                logger.info("Exclude table " + tablename + " from drop list, as the table belongs to cube " + cube.getName() + " with status " + cube.getStatus());
            }
        }
        if (this.delete) {
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            for (String htableName : allTablesNeedToBeDropped) {
                FutureTask futureTask = new FutureTask(new DeleteHTableRunnable(hbaseAdmin, htableName));
                executorService.execute(futureTask);
                try {
                    futureTask.get(10L, TimeUnit.MINUTES);
                }
                catch (TimeoutException e) {
                    logger.warn("It fails to delete htable " + htableName + ", for it cost more than " + 10 + " minutes!");
                    futureTask.cancel(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    futureTask.cancel(true);
                }
            }
            executorService.shutdown();
        } else {
            System.out.println("--------------- Tables To Be Dropped ---------------");
            for (String htableName : allTablesNeedToBeDropped) {
                System.out.println(htableName);
            }
            System.out.println("----------------------------------------------------");
        }
        hbaseAdmin.close();
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DELETE);
        options.addOption(OPTION_FORCE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        logger.info("options: '" + optionsHelper.getOptionsAsString() + "'");
        logger.info("delete option value: '" + optionsHelper.getOptionValue(OPTION_DELETE) + "'");
        logger.info("force option value: '" + optionsHelper.getOptionValue(OPTION_FORCE) + "'");
        this.delete = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_DELETE));
        this.force = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_FORCE));
        Configuration conf = HBaseConfiguration.create();
        this.cleanUnusedIntermediateHiveTable(conf);
        this.cleanUnusedHdfsFiles(conf);
        this.cleanUnusedHBaseTables(conf);
    }

    private void cleanUnusedHdfsFiles(Configuration conf) throws IOException {
        String path;
        FileStatus[] fStatus;
        JobEngineConfig engineConfig = new JobEngineConfig(KylinConfig.getInstanceFromEnv());
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        FileSystem fs = HadoopUtil.getWorkingFileSystem((Configuration)conf);
        ArrayList<String> allHdfsPathsNeedToBeDeleted = new ArrayList<String>();
        for (FileStatus status : fStatus = fs.listStatus(new Path(KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory()))) {
            path = status.getPath().getName();
            if (!path.startsWith("kylin-")) continue;
            String kylinJobPath = engineConfig.getHdfsWorkingDirectory() + path;
            allHdfsPathsNeedToBeDeleted.add(kylinJobPath);
        }
        List allJobs = executableManager.getAllJobIds();
        for (String jobId : allJobs) {
            ExecutableState state = executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            path = JobBuilderSupport.getJobWorkingDir((String)engineConfig.getHdfsWorkingDirectory(), (String)jobId);
            allHdfsPathsNeedToBeDeleted.remove(path);
            logger.info("Skip " + path + " from deletion list, as the path belongs to job " + jobId + " with status " + state);
        }
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment seg : cube.getSegments()) {
                String jobUuid = seg.getLastBuildJobID();
                if (jobUuid == null || jobUuid.equals("")) continue;
                String path2 = JobBuilderSupport.getJobWorkingDir((String)engineConfig.getHdfsWorkingDirectory(), (String)jobUuid);
                allHdfsPathsNeedToBeDeleted.remove(path2);
                logger.info("Skip " + path2 + " from deletion list, as the path belongs to segment " + seg + " of cube " + cube.getName());
            }
        }
        if (this.delete) {
            for (String hdfsPath : allHdfsPathsNeedToBeDeleted) {
                logger.info("Deleting hdfs path " + hdfsPath);
                Path p = new Path(hdfsPath);
                if (fs.exists(p)) {
                    fs.delete(p, true);
                    logger.info("Deleted hdfs path " + hdfsPath);
                    continue;
                }
                logger.info("Hdfs path " + hdfsPath + "does not exist");
            }
        } else {
            System.out.println("--------------- HDFS Path To Be Deleted ---------------");
            for (String hdfsPath : allHdfsPathsNeedToBeDeleted) {
                System.out.println(hdfsPath);
            }
            System.out.println("-------------------------------------------------------");
        }
    }

    private void cleanUnusedIntermediateHiveTable(Configuration conf) throws IOException {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CliCommandExecutor cmdExec = config.getCliCommandExecutor();
        int uuidLength = 36;
        String preFix = "kylin_intermediate_";
        String uuidPattern = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}";
        String useDatabaseHql = "USE " + config.getHiveDatabaseForIntermediateTable() + ";";
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
        hiveCmdBuilder.addStatement(useDatabaseHql);
        hiveCmdBuilder.addStatement("show tables 'kylin_intermediate_*'; ");
        Pair result = cmdExec.execute(hiveCmdBuilder.build());
        String outputStr = (String)result.getSecond();
        BufferedReader reader = new BufferedReader(new StringReader(outputStr));
        String line = null;
        List allJobs = executableManager.getAllJobIds();
        ArrayList<String> allHiveTablesNeedToBeDeleted = new ArrayList<String>();
        ArrayList<String> workingJobList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String jobId : allJobs) {
            ExecutableState state = executableManager.getOutput(jobId).getState();
            if (state.isFinalState()) continue;
            workingJobList.add(jobId);
            sb.append(jobId).append("(").append(state).append("), ");
        }
        logger.info("Working jobIDs: " + workingJobList);
        while ((line = reader.readLine()) != null) {
            logger.info("Checking table " + line);
            if (!line.startsWith("kylin_intermediate_")) continue;
            if (this.force) {
                logger.warn("!!!!!!!!!!!!!!!Warning: will delete all intermediate hive tables!!!!!!!!!!!!!!!!!!!!!!");
                allHiveTablesNeedToBeDeleted.add(line);
                continue;
            }
            boolean isNeedDel = true;
            if (line.length() > "kylin_intermediate_".length() + 36) {
                String uuid = line.substring(line.length() - 36, line.length());
                uuid = uuid.replace("_", "-");
                Pattern UUId_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}");
                if (UUId_PATTERN.matcher(uuid).matches()) {
                    if (this.isTableInUse(uuid, workingJobList)) {
                        logger.info("Skip because not isTableInUse");
                        isNeedDel = false;
                    }
                } else {
                    logger.info("Skip because not match pattern");
                    isNeedDel = false;
                }
            } else {
                logger.info("Skip because length not qualified");
                isNeedDel = false;
            }
            if (!isNeedDel) continue;
            allHiveTablesNeedToBeDeleted.add(line);
        }
        if (this.delete) {
            hiveCmdBuilder.reset();
            hiveCmdBuilder.addStatement(useDatabaseHql);
            for (String delHive : allHiveTablesNeedToBeDeleted) {
                hiveCmdBuilder.addStatement("drop table if exists " + delHive + "; ");
                logger.info("Remove " + delHive + " from hive tables.");
            }
            try {
                cmdExec.execute(hiveCmdBuilder.build());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("------ Intermediate Hive Tables To Be Dropped ------");
            for (String hiveTable : allHiveTablesNeedToBeDeleted) {
                System.out.println(hiveTable);
            }
            System.out.println("----------------------------------------------------");
        }
        if (reader != null) {
            reader.close();
        }
    }

    private boolean isTableInUse(String segUuid, List<String> workingJobList) {
        for (String jobId : workingJobList) {
            AbstractExecutable abstractExecutable = executableManager.getJob(jobId);
            String segmentId = abstractExecutable.getParam("segmentId");
            if (null == segmentId) continue;
            return segUuid.equals(segmentId);
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        logger.warn("org.apache.kylin.storage.hbase.util.StorageCleanupJob is deprecated, use org.apache.kylin.tool.StorageCleanupJob instead");
        StorageCleanupJob cli = new StorageCleanupJob();
        cli.execute(args);
    }

    static {
        OptionBuilder.withArgName((String)"delete");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Delete the unused storage");
        OPTION_DELETE = OptionBuilder.create((String)"delete");
        OptionBuilder.withArgName((String)"force");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Warning: will delete all kylin intermediate hive tables");
        OPTION_FORCE = OptionBuilder.create((String)"force");
        logger = LoggerFactory.getLogger(StorageCleanupJob.class);
        executableManager = ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    class DeleteHTableRunnable
    implements Callable {
        Admin hbaseAdmin;
        String htableName;

        DeleteHTableRunnable(Admin hbaseAdmin, String htableName) {
            this.hbaseAdmin = hbaseAdmin;
            this.htableName = htableName;
        }

        public Object call() throws Exception {
            logger.info("Deleting HBase table " + this.htableName);
            if (this.hbaseAdmin.tableExists(TableName.valueOf((String)this.htableName))) {
                if (this.hbaseAdmin.isTableEnabled(TableName.valueOf((String)this.htableName))) {
                    this.hbaseAdmin.disableTable(TableName.valueOf((String)this.htableName));
                }
                this.hbaseAdmin.deleteTable(TableName.valueOf((String)this.htableName));
                logger.info("Deleted HBase table " + this.htableName);
            } else {
                logger.info("HBase table" + this.htableName + " does not exist");
            }
            return null;
        }
    }
}

