/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.kylin.common.util.MemoryBudgetController;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.storage.hbase.common.coprocessor.AggrKey;

public abstract class AggregationCache {
    static final long MEMORY_USAGE_CAP = 524288000L;
    static final long MEMOERY_MAX_BYTES = Runtime.getRuntime().maxMemory();
    protected final Map<AggrKey, MeasureAggregator[]> aggBufMap = Maps.newHashMap();
    transient int rowMemBytes;
    private AggrKey firstKey = null;

    public abstract MeasureAggregator[] createBuffer();

    public MeasureAggregator[] getBuffer(AggrKey aggkey) {
        MeasureAggregator[] aggBuf = this.aggBufMap.get(aggkey);
        if (aggBuf == null) {
            aggBuf = this.createBuffer();
            AggrKey key = aggkey.copy();
            this.aggBufMap.put(key, aggBuf);
            if (this.firstKey == null) {
                this.firstKey = key;
            }
        }
        return aggBuf;
    }

    public long getSize() {
        return this.aggBufMap.size();
    }

    public void checkMemoryUsage() {
        int size;
        long memUsage;
        if (this.firstKey == null) {
            return;
        }
        if (this.rowMemBytes <= 0 && this.aggBufMap.size() > 0) {
            MeasureAggregator[] measureAggregators;
            this.rowMemBytes = 0;
            for (MeasureAggregator agg : measureAggregators = this.aggBufMap.get(this.firstKey)) {
                this.rowMemBytes += agg.getMemBytesEstimate();
            }
        }
        if ((memUsage = (40L + (long)this.rowMemBytes) * (long)(size = this.aggBufMap.size())) > 524288000L) {
            throw new RuntimeException("Kylin coprocessor memory usage goes beyond cap, (40 + " + this.rowMemBytes + ") * " + size + " > " + 524288000L + ". Abort coprocessor.");
        }
        long avail = MemoryBudgetController.getSystemAvailBytes();
        if (avail < MEMOERY_MAX_BYTES / 20L) {
            throw new RuntimeException("Running Kylin coprocessor when too little memory is left. Abort coprocessor. Current available memory is " + avail + ". Max memory is " + MEMOERY_MAX_BYTES);
        }
    }
}

