/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import com.google.common.collect.Lists;
import java.util.List;
import junit.framework.TestCase;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.storage.hbase.util.ZookeeperAclBuilder;
import org.apache.zookeeper.ZooDefs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ZookeeperAclBuilderTest
extends LocalFileMetadataTestCase {
    @BeforeClass
    public static void setupResource() throws Exception {
        ZookeeperAclBuilderTest.staticCreateTestMetadata((String[])new String[0]);
    }

    @AfterClass
    public static void tearDownResource() {
        ZookeeperAclBuilderTest.cleanAfterClass();
    }

    @Test
    public void testAclEnabled() {
        KylinConfig testConfig = KylinConfig.getInstanceFromEnv();
        testConfig.setProperty("kylin.env.zookeeper-acl-enabled", "true");
        ZookeeperAclBuilder zookeeperAclBuilder = new ZookeeperAclBuilder().invoke();
        Assert.assertNotNull((Object)zookeeperAclBuilder);
        Assert.assertTrue((boolean)zookeeperAclBuilder.isNeedAcl());
        List zkAcls = Lists.newArrayList();
        try {
            zkAcls = ZookeeperAclBuilder.getZKAcls();
            Assert.assertFalse((boolean)zkAcls.isEmpty());
        }
        catch (Exception e) {
            TestCase.fail((String)"Couldn't read ACLs based on 'kylin.env.zookeeper.zk-acl' in kylin.properties");
        }
        List zkAuthInfo = Lists.newArrayList();
        try {
            zkAuthInfo = ZookeeperAclBuilder.getZKAuths();
            Assert.assertFalse((boolean)zkAuthInfo.isEmpty());
        }
        catch (Exception e) {
            TestCase.fail((String)"Couldn't read Auth based on 'kylin.env.zookeeper.zk-auth' in kylin.properties");
        }
        CuratorFrameworkFactory.Builder builder = zookeeperAclBuilder.setZKAclBuilder(CuratorFrameworkFactory.builder());
        Assert.assertNotNull((Object)builder);
        Assert.assertEquals(zkAcls, (Object)builder.getAclProvider().getDefaultAcl());
        Assert.assertNotNull((Object)builder.getAuthInfos());
    }

    @Test
    public void testAclDisabled() {
        KylinConfig testConfig = KylinConfig.getInstanceFromEnv();
        testConfig.setProperty("kylin.env.zookeeper-acl-enabled", "false");
        ZookeeperAclBuilder zookeeperAclBuilder = new ZookeeperAclBuilder().invoke();
        Assert.assertNotNull((Object)zookeeperAclBuilder);
        Assert.assertFalse((boolean)zookeeperAclBuilder.isNeedAcl());
        CuratorFrameworkFactory.Builder builder = zookeeperAclBuilder.setZKAclBuilder(CuratorFrameworkFactory.builder());
        Assert.assertNotNull((Object)builder);
        Assert.assertEquals((Object)ZooDefs.Ids.OPEN_ACL_UNSAFE, (Object)builder.getAclProvider().getDefaultAcl());
        Assert.assertNull((Object)builder.getAuthInfos());
    }
}

